/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;

public class ScimGroupJsonSerializer
extends JsonSerializer<ScimGroup> {
    public void serialize(ScimGroup group, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        HashMap roles = new HashMap();
        for (ScimGroupMember.Role authority : ScimGroupMember.Role.values()) {
            String role = authority.toString().toLowerCase() + "s";
            roles.put(role, new ArrayList());
            if (group.getMembers() == null) continue;
            for (ScimGroupMember member : group.getMembers()) {
                if (!member.getRoles().contains((Object)authority)) continue;
                ((List)roles.get(role)).add(member);
            }
        }
        HashMap<Object, Object> groupJson = new HashMap<Object, Object>();
        this.addNonNull(groupJson, "meta", group.getMeta());
        this.addNonNull(groupJson, "schemas", group.getSchemas());
        this.addNonNull(groupJson, "id", group.getId());
        this.addNonNull(groupJson, "displayName", group.getDisplayName());
        for (Map.Entry entry : roles.entrySet()) {
            this.addNonNull(groupJson, entry.getKey(), entry.getValue());
        }
        jgen.writeObject(groupJson);
    }

    private void addNonNull(Map<Object, Object> map, Object key, Object value) {
        if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) {
            return;
        }
        map.put(key, value);
    }
}

