/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.error.InvalidCodeException;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.login.ConflictException;
import org.cloudfoundry.identity.uaa.login.ForgotPasswordInfo;
import org.cloudfoundry.identity.uaa.login.NotFoundException;
import org.cloudfoundry.identity.uaa.login.ResetPasswordService;
import org.cloudfoundry.identity.uaa.password.event.PasswordChangeEvent;
import org.cloudfoundry.identity.uaa.password.event.PasswordChangeFailureEvent;
import org.cloudfoundry.identity.uaa.password.event.ResetPasswordRequestEvent;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordChange;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;

public class UaaResetPasswordService
implements ResetPasswordService,
ApplicationEventPublisherAware {
    public static final int PASSWORD_RESET_LIFETIME = 1800000;
    private final ScimUserProvisioning scimUserProvisioning;
    private final ExpiringCodeStore expiringCodeStore;
    private final PasswordValidator passwordValidator;
    private final ClientDetailsService clientDetailsService;
    private ApplicationEventPublisher publisher;

    public UaaResetPasswordService(ScimUserProvisioning scimUserProvisioning, ExpiringCodeStore expiringCodeStore, PasswordValidator passwordValidator, ClientDetailsService clientDetailsService) {
        this.scimUserProvisioning = scimUserProvisioning;
        this.expiringCodeStore = expiringCodeStore;
        this.passwordValidator = passwordValidator;
        this.clientDetailsService = clientDetailsService;
    }

    @Override
    public ResetPasswordService.ResetPasswordResponse resetPassword(String code, String newPassword) throws InvalidPasswordException {
        try {
            this.passwordValidator.validate(newPassword);
            return this.changePasswordCodeAuthenticated(code, newPassword);
        }
        catch (RestClientException e) {
            throw new UaaException(e.getMessage());
        }
    }

    private ResetPasswordService.ResetPasswordResponse changePasswordCodeAuthenticated(String code, String newPassword) {
        String userId;
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code);
        if (expiringCode == null) {
            throw new InvalidCodeException("invalid_code", "Sorry, your reset password link is no longer valid. Please request a new one", 422);
        }
        String userName = null;
        Date passwordLastModified = null;
        String clientId = null;
        String redirectUri = null;
        try {
            PasswordChange change = (PasswordChange)JsonUtils.readValue((String)expiringCode.getData(), PasswordChange.class);
            userId = change.getUserId();
            userName = change.getUsername();
            passwordLastModified = change.getPasswordModifiedTime();
            clientId = change.getClientId();
            redirectUri = change.getRedirectUri();
        }
        catch (JsonUtils.JsonUtilException x) {
            userId = expiringCode.getData();
        }
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        try {
            if (this.isUserModified(user, expiringCode.getExpiresAt(), userName, passwordLastModified)) {
                throw new UaaException("Invalid password reset request.");
            }
            if (!user.isVerified()) {
                this.scimUserProvisioning.verifyUser(userId, -1);
            }
            if (this.scimUserProvisioning.checkPasswordMatches(userId, newPassword)) {
                throw new InvalidPasswordException("Your new password cannot be the same as the old password.", HttpStatus.UNPROCESSABLE_ENTITY);
            }
            this.scimUserProvisioning.changePassword(userId, null, newPassword);
            this.publish((ApplicationEvent)new PasswordChangeEvent("Password changed", this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            String redirectLocation = "home";
            if (!StringUtils.isEmpty((Object)clientId) && !StringUtils.isEmpty((Object)redirectUri)) {
                try {
                    ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
                    Set redirectUris = clientDetails.getRegisteredRedirectUri() == null ? Collections.emptySet() : clientDetails.getRegisteredRedirectUri();
                    Set wildcards = UaaStringUtils.constructWildcards((Collection)redirectUris);
                    if (UaaStringUtils.matches((Set)wildcards, (String)redirectUri)) {
                        redirectLocation = redirectUri;
                    }
                }
                catch (NoSuchClientException noSuchClientException) {
                    // empty catch block
                }
            }
            return new ResetPasswordService.ResetPasswordResponse(user, redirectLocation, clientId);
        }
        catch (Exception e) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(e.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            throw e;
        }
    }

    @Override
    public ForgotPasswordInfo forgotPassword(String email, String clientId, String redirectUri) {
        String jsonEmail = JsonUtils.writeValueAsString((Object)email);
        List results = this.scimUserProvisioning.query("userName eq " + jsonEmail + " and origin eq \"" + "uaa" + "\"");
        if (results.isEmpty()) {
            results = this.scimUserProvisioning.query("userName eq " + jsonEmail);
            if (results.isEmpty()) {
                throw new NotFoundException();
            }
            throw new ConflictException(((ScimUser)results.get(0)).getId());
        }
        ScimUser scimUser = (ScimUser)results.get(0);
        PasswordChange change = new PasswordChange(scimUser.getId(), scimUser.getUserName(), scimUser.getPasswordLastModified(), clientId, redirectUri);
        ExpiringCode code = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString((Object)change), new Timestamp(System.currentTimeMillis() + 1800000L));
        this.publish((ApplicationEvent)new ResetPasswordRequestEvent(email, code.getCode(), SecurityContextHolder.getContext().getAuthentication()));
        return new ForgotPasswordInfo(scimUser.getId(), code);
    }

    private boolean isUserModified(ScimUser user, Timestamp expiresAt, String userName, Date passwordLastModified) {
        boolean modified = false;
        if (userName != null) {
            boolean bl = modified = !userName.equals(user.getUserName());
        }
        if (passwordLastModified != null && !modified) {
            modified = user.getPasswordLastModified().getTime() != passwordLastModified.getTime();
        }
        return modified;
    }

    private UaaUser getUaaUser(ScimUser scimUser) {
        Date today = new Date();
        return new UaaUser(scimUser.getId(), scimUser.getUserName(), "N/A", scimUser.getPrimaryEmail(), null, scimUser.getGivenName(), scimUser.getFamilyName(), today, today, scimUser.getOrigin(), scimUser.getExternalId(), scimUser.isVerified(), scimUser.getZoneId(), scimUser.getSalt(), scimUser.getPasswordLastModified());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    protected void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

