/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.error.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.error.ExceptionReport;
import org.cloudfoundry.identity.uaa.error.InvalidCodeException;
import org.cloudfoundry.identity.uaa.login.ConflictException;
import org.cloudfoundry.identity.uaa.login.ForgotPasswordInfo;
import org.cloudfoundry.identity.uaa.login.NotFoundException;
import org.cloudfoundry.identity.uaa.login.ResetPasswordService;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordReset;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
public class PasswordResetEndpoint {
    private final ResetPasswordService resetPasswordService;
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);
    private ExpiringCodeStore codeStore;

    public PasswordResetEndpoint(ResetPasswordService resetPasswordService) {
        this.resetPasswordService = resetPasswordService;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    @RequestMapping(value={"/password_resets"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> resetPassword(@RequestBody String email, @RequestParam(required=false, value="client_id") String clientId, @RequestParam(required=false, value="redirect_uri") String redirectUri) throws IOException {
        Authentication authentication;
        if (clientId == null && (authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof OAuth2Authentication) {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            clientId = oAuth2Authentication.getOAuth2Request().getClientId();
        }
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            ForgotPasswordInfo forgotPasswordInfo = this.resetPasswordService.forgotPassword(email, clientId, redirectUri);
            response.put("code", forgotPasswordInfo.getResetPasswordCode().getCode());
            response.put("user_id", forgotPasswordInfo.getUserId());
            return new ResponseEntity(response, HttpStatus.CREATED);
        }
        catch (ConflictException e) {
            response.put("user_id", e.getUserId());
            return new ResponseEntity(response, HttpStatus.CONFLICT);
        }
        catch (NotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/password_change"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> changePassword(@RequestBody PasswordReset passwordReset) {
        if (passwordReset.getCode() != null) {
            try {
                ResetPasswordService.ResetPasswordResponse response = this.resetPasswordService.resetPassword(passwordReset.getCode(), passwordReset.getNewPassword());
                ScimUser user = response.getUser();
                ExpiringCode loginCode = this.getCode(user.getId(), user.getUserName(), response.getClientId());
                HashMap<String, String> responseBody = new HashMap<String, String>();
                responseBody.put("user_id", user.getId());
                responseBody.put("username", user.getUserName());
                responseBody.put("email", user.getPrimaryEmail());
                responseBody.put("code", loginCode.getCode());
                return new ResponseEntity(responseBody, HttpStatus.OK);
            }
            catch (BadCredentialsException e) {
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
            catch (ScimResourceNotFoundException e) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            catch (InvalidCodeException | InvalidPasswordException e) {
                throw e;
            }
            catch (Exception e) {
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.BAD_REQUEST);
        return responseEntity;
    }

    private ExpiringCode getCode(String id, String username, String clientId) {
        HashMap<String, String> codeData = new HashMap<String, String>();
        codeData.put("user_id", id);
        codeData.put("username", username);
        codeData.put("client_id", clientId);
        codeData.put("origin", "uaa");
        codeData.put("action", ExpiringCodeType.AUTOLOGIN.name());
        return this.codeStore.generateCode(JsonUtils.writeValueAsString(codeData), new Timestamp(System.currentTimeMillis() + 300000L));
    }

    @ExceptionHandler(value={InvalidPasswordException.class})
    public View handleException(InvalidPasswordException t) throws ScimException {
        return new ConvertingExceptionView(new ResponseEntity((Object)new ExceptionReport((Exception)t, false), HttpStatus.UNPROCESSABLE_ENTITY), this.messageConverters);
    }

    @ExceptionHandler(value={InvalidCodeException.class})
    public View handleCodeException(InvalidCodeException t) throws ScimException {
        return new ConvertingExceptionView(new ResponseEntity((Object)new ExceptionReport((Exception)((Object)t), false), HttpStatus.UNPROCESSABLE_ENTITY), this.messageConverters);
    }

    public void setCodeStore(ExpiringCodeStore codeStore) {
        this.codeStore = codeStore;
    }
}

