/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.rest.SearchResults;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.endpoints.ScimUserEndpoints;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.cloudfoundry.identity.uaa.zone.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.View;

@Controller
public class UserIdConversionEndpoints
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private ScimUserEndpoints scimUserEndpoints;
    private IdentityProviderProvisioning provisioning;
    private boolean enabled = true;

    public UserIdConversionEndpoints(IdentityProviderProvisioning provisioning) {
        this.provisioning = provisioning;
    }

    void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    public void setScimUserEndpoints(ScimUserEndpoints scimUserEndpoints) {
        this.scimUserEndpoints = scimUserEndpoints;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @RequestMapping(value={"/ids/Users"})
    @ResponseBody
    public SearchResults<?> findUsers(@RequestParam(required=true, defaultValue="") String filter, @RequestParam(required=false, defaultValue="ascending") String sortOrder, @RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count, @RequestParam(required=false, defaultValue="false") boolean includeInactive) {
        if (!this.enabled) {
            this.logger.warn((Object)("Request from user " + this.securityContextAccessor.getAuthenticationInfo() + " received at disabled Id translation endpoint with filter:" + filter));
            throw new ScimException("Illegal operation.", HttpStatus.BAD_REQUEST);
        }
        filter = filter.trim();
        this.checkFilter(filter);
        List activeIdentityProviders = this.provisioning.retrieveActive(IdentityZoneHolder.get().getId());
        if (!includeInactive) {
            if (activeIdentityProviders.isEmpty()) {
                return new SearchResults(Arrays.asList(ScimCore.SCHEMAS), new ArrayList(), startIndex, count, 0);
            }
            String originFilter = activeIdentityProviders.stream().map(identityProvider -> "".concat("origin eq \"" + identityProvider.getOriginKey() + "\"")).collect(Collectors.joining(" OR "));
            filter = filter + " AND (" + originFilter + " )";
        }
        return this.scimUserEndpoints.findUsers("id,userName,origin", filter, "userName", sortOrder, startIndex, count);
    }

    @ExceptionHandler
    public View handleException(Exception t, HttpServletRequest request) throws ScimException {
        return this.scimUserEndpoints.handleException(t, request);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handleException() {
    }

    private void checkFilter(String filter) {
        if (filter.isEmpty()) {
            throw new ScimException("a 'filter' parameter is required", HttpStatus.BAD_REQUEST);
        }
        try {
            SCIMFilter scimFilter = SCIMFilter.parse((String)filter);
            if (!this.checkFilter(scimFilter)) {
                throw new ScimException("Invalid filter attribute.", HttpStatus.BAD_REQUEST);
            }
        }
        catch (SCIMException e) {
            this.logger.debug((Object)("/ids/Users received an invalid filter [" + filter + "]"), (Throwable)e);
            throw new ScimException("Invalid filter '" + filter + "'", HttpStatus.BAD_REQUEST);
        }
    }

    private boolean checkFilter(SCIMFilter filter) {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                return this.checkFilter((SCIMFilter)filter.getFilterComponents().get(0)) | this.checkFilter((SCIMFilter)filter.getFilterComponents().get(1));
            }
            case EQUALITY: {
                String name = filter.getFilterAttribute().getAttributeName();
                if ("id".equalsIgnoreCase(name) || "userName".equalsIgnoreCase(name)) {
                    return true;
                }
                if ("origin".equalsIgnoreCase(name)) {
                    return false;
                }
                throw new ScimException("Invalid filter attribute.", HttpStatus.BAD_REQUEST);
            }
            case PRESENCE: 
            case STARTS_WITH: 
            case CONTAINS: {
                throw new ScimException("Wildcards are not allowed in filter.", HttpStatus.BAD_REQUEST);
            }
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_OR_EQUAL: {
                throw new ScimException("Invalid operator.", HttpStatus.BAD_REQUEST);
            }
        }
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.scimUserEndpoints, (String)"ScimUserEndpoints must be set");
    }
}

