/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import org.cloudfoundry.security.DelegatingX509ExtendedKeyManager;
import org.cloudfoundry.security.FileWatchingX509ExtendedKeyManager;

abstract class CloudFoundryContainerKeyManagerFactory
extends KeyManagerFactorySpi {
    private static final String CERTIFICATES_PROPERTY = "CF_INSTANCE_CERT";
    private static final Object MONITOR = new Object();
    private static final String PRIVATE_KEY_PROPERTY = "CF_INSTANCE_KEY";
    private static FileWatchingX509ExtendedKeyManager CACHED_CONTAINER_KEY_MANAGER;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String algorithm;
    private final Path certificates;
    private final Path privateKey;
    private final KeyManagerFactory systemKeyManagerFactory;
    private X509ExtendedKeyManager cachedSystemKeyManager;

    private CloudFoundryContainerKeyManagerFactory(String algorithm, Path certificates, Path privateKey) {
        this.algorithm = algorithm;
        this.certificates = certificates;
        this.privateKey = privateKey;
        this.systemKeyManagerFactory = this.getKeyManagerFactory();
        this.logger.fine(String.format("Algorithm: %s", algorithm));
        this.logger.fine(String.format("Certificates: %s", certificates));
        this.logger.fine(String.format("Private Key: %s", privateKey));
    }

    @Override
    protected final KeyManager[] engineGetKeyManagers() {
        FileWatchingX509ExtendedKeyManager containerKeyManager;
        ArrayList<X509ExtendedKeyManager> delegates = new ArrayList<X509ExtendedKeyManager>();
        X509ExtendedKeyManager systemKeyManager = this.getSystemKeyManager();
        if (systemKeyManager != null) {
            delegates.add(systemKeyManager);
        }
        if ((containerKeyManager = this.getContainerKeyManager()) != null) {
            delegates.add(containerKeyManager);
        }
        return new KeyManager[]{new DelegatingX509ExtendedKeyManager(delegates)};
    }

    @Override
    protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.systemKeyManagerFactory.init(managerFactoryParameters);
        this.invalidateSystemKeyManager();
    }

    @Override
    protected final void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.systemKeyManagerFactory.init(keyStore, chars);
        this.invalidateSystemKeyManager();
    }

    private static Path getProperty(String name) {
        String candidate = System.getenv(name);
        return candidate != null ? Paths.get(candidate, new String[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWatchingX509ExtendedKeyManager getContainerKeyManager() {
        Object object = MONITOR;
        synchronized (object) {
            if (CACHED_CONTAINER_KEY_MANAGER == null && this.certificates != null && Files.exists(this.certificates, new LinkOption[0]) && this.privateKey != null && Files.exists(this.privateKey, new LinkOption[0])) {
                this.logger.info(String.format("Adding Key Manager for %s and %s", this.privateKey, this.certificates));
                CACHED_CONTAINER_KEY_MANAGER = new FileWatchingX509ExtendedKeyManager(this.certificates, this.privateKey, this.getKeyManagerFactory());
            }
            return CACHED_CONTAINER_KEY_MANAGER;
        }
    }

    private KeyManagerFactory getKeyManagerFactory() {
        try {
            return KeyManagerFactory.getInstance(this.algorithm, "SunJSSE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509ExtendedKeyManager getSystemKeyManager() {
        Object object = MONITOR;
        synchronized (object) {
            if (this.cachedSystemKeyManager == null) {
                for (KeyManager candidate : this.systemKeyManagerFactory.getKeyManagers()) {
                    if (!(candidate instanceof X509ExtendedKeyManager)) continue;
                    this.logger.info("Adding System Key Manager");
                    this.cachedSystemKeyManager = (X509ExtendedKeyManager)candidate;
                    break;
                }
            }
            return this.cachedSystemKeyManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSystemKeyManager() {
        Object object = MONITOR;
        synchronized (object) {
            this.cachedSystemKeyManager = null;
        }
    }

    public static final class X509
    extends CloudFoundryContainerKeyManagerFactory {
        public X509() throws NoSuchAlgorithmException, NoSuchProviderException {
            this(CloudFoundryContainerKeyManagerFactory.getProperty(CloudFoundryContainerKeyManagerFactory.CERTIFICATES_PROPERTY), CloudFoundryContainerKeyManagerFactory.getProperty(CloudFoundryContainerKeyManagerFactory.PRIVATE_KEY_PROPERTY));
        }

        X509(Path certificates, Path privateKey) throws NoSuchAlgorithmException, NoSuchProviderException {
            super("NewSunX509", certificates, privateKey);
        }
    }

    public static final class SunX509
    extends CloudFoundryContainerKeyManagerFactory {
        public SunX509() throws NoSuchAlgorithmException, NoSuchProviderException {
            this(CloudFoundryContainerKeyManagerFactory.getProperty(CloudFoundryContainerKeyManagerFactory.CERTIFICATES_PROPERTY), CloudFoundryContainerKeyManagerFactory.getProperty(CloudFoundryContainerKeyManagerFactory.PRIVATE_KEY_PROPERTY));
        }

        SunX509(Path certificates, Path privateKey) throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SunX509", certificates, privateKey);
        }
    }
}

