/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.security.Provider;
import java.util.logging.Logger;

public final class CloudFoundryContainerProvider
extends Provider {
    static final String KEY_MANAGER_ENABLED = "org.cloudfoundry.security.keymanager.enabled";
    static final String TRUST_MANAGER_ENABLED = "org.cloudfoundry.security.trustmanager.enabled";
    private static final long serialVersionUID = -2667509590306131953L;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public CloudFoundryContainerProvider() {
        super("Cloud Foundry Container", 1.0, "KeyManagerFactory and TrustManagerFactory based on artifacts within a Cloud Foundry application container");
        if (CloudFoundryContainerProvider.get(KEY_MANAGER_ENABLED)) {
            this.logger.fine("KeyManager enabled");
            this.put("KeyManagerFactory.SunX509", "org.cloudfoundry.security.CloudFoundryContainerKeyManagerFactory$SunX509");
            this.put("KeyManagerFactory.NewSunX509", "org.cloudfoundry.security.CloudFoundryContainerKeyManagerFactory$X509");
            this.put("Alg.Alias.KeyManagerFactory.PKIX", "NewSunX509");
        }
        if (CloudFoundryContainerProvider.get(TRUST_MANAGER_ENABLED)) {
            this.logger.fine("TrustManager enabled");
            this.put("TrustManagerFactory.SunX509", "org.cloudfoundry.security.CloudFoundryContainerTrustManagerFactory$SimpleFactory");
            this.put("TrustManagerFactory.PKIX", "org.cloudfoundry.security.CloudFoundryContainerTrustManagerFactory$PKIXFactory");
            this.put("Alg.Alias.TrustManagerFactory.SunPKIX", "PKIX");
            this.put("Alg.Alias.TrustManagerFactory.X509", "PKIX");
            this.put("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        }
        this.logger.fine("Provider loaded");
    }

    private static boolean get(String key) {
        String value = System.getProperty(key);
        return value == null || value.trim().isEmpty() ? true : Boolean.valueOf(value);
    }
}

