/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Socket;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.cloudfoundry.security.FileWatcher;
import org.cloudfoundry.security.KeyStoreEntryCollector;
import org.cloudfoundry.security.PrivateKeyFactory;
import org.cloudfoundry.security.X509CertificateFactory;

final class FileWatchingX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Path certificates;
    private final AtomicReference<X509ExtendedKeyManager> keyManager = new AtomicReference();
    private final KeyManagerFactory keyManagerFactory;
    private final Path privateKey;

    FileWatchingX509ExtendedKeyManager(Path certificates, Path privateKey, KeyManagerFactory keyManagerFactory) {
        this.certificates = certificates;
        this.privateKey = privateKey;
        this.keyManagerFactory = keyManagerFactory;
        new FileWatcher(this.certificates, new FileWatcherCallback()).watch();
        if (this.keyManager.compareAndSet(null, this.getKeyManager(this.getKeyStore()))) {
            this.logger.info(String.format("Initialized KeyManager for %s and %s", this.privateKey, this.certificates));
        }
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManager.get().chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        return this.keyManager.get().chooseEngineClientAlias(strings, principals, sslEngine);
    }

    @Override
    public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
        return this.keyManager.get().chooseEngineServerAlias(s, principals, sslEngine);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.keyManager.get().chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.keyManager.get().getCertificateChain(s);
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.keyManager.get().getClientAliases(s, principals);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.keyManager.get().getPrivateKey(s);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.keyManager.get().getServerAliases(s, principals);
    }

    private X509ExtendedKeyManager getKeyManager(KeyStore keyStore) {
        try {
            this.keyManagerFactory.init(keyStore, new char[0]);
            for (KeyManager keyManager : this.keyManagerFactory.getKeyManagers()) {
                if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                return (X509ExtendedKeyManager)keyManager;
            }
            throw new IllegalStateException("No X509ExtendedKeyManager available");
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private KeyStore getKeyStore() {
        try {
            KeyStore keyStore = KeyStoreEntryCollector.identity();
            PrivateKey privateKey = PrivateKeyFactory.generate(this.privateKey);
            List<X509Certificate> certificates = X509CertificateFactory.generate(this.certificates);
            KeyStoreEntryCollector.accumulate(keyStore, privateKey, new char[0], certificates.toArray(new Certificate[certificates.size()]));
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private final class FileWatcherCallback
    implements Runnable {
        private FileWatcherCallback() {
        }

        @Override
        public void run() {
            if (FileWatchingX509ExtendedKeyManager.this.keyManager.getAndSet(FileWatchingX509ExtendedKeyManager.this.getKeyManager(FileWatchingX509ExtendedKeyManager.this.getKeyStore())) == null) {
                FileWatchingX509ExtendedKeyManager.this.logger.info(String.format("Initialized KeyManager for %s and %s", FileWatchingX509ExtendedKeyManager.this.privateKey, FileWatchingX509ExtendedKeyManager.this.certificates));
            } else {
                FileWatchingX509ExtendedKeyManager.this.logger.info(String.format("Updated KeyManager for %s and %s", FileWatchingX509ExtendedKeyManager.this.privateKey, FileWatchingX509ExtendedKeyManager.this.certificates));
            }
        }
    }
}

