/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import org.cloudfoundry.security.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.cloudfoundry.security.org.bouncycastle.openssl.PEMKeyPair;
import org.cloudfoundry.security.org.bouncycastle.openssl.PEMParser;
import org.cloudfoundry.security.org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

final class PrivateKeyFactory {
    private static final JcaPEMKeyConverter CONVERTER = new JcaPEMKeyConverter();

    PrivateKeyFactory() {
    }

    static PrivateKey generate(Path path) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            PEMParser parser = new PEMParser(in);
            Object keyPair = parser.readObject();
            if (!(keyPair instanceof PEMKeyPair)) {
                throw new IllegalStateException(String.format("%s contains an artifact that is not a key pair: %s", path, keyPair));
            }
            PrivateKeyInfo privateKeyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
            if (privateKeyInfo == null) {
                throw new IllegalStateException(String.format("%s does not contain a private key", path));
            }
            PrivateKey privateKey = CONVERTER.getPrivateKey(privateKeyInfo);
            return privateKey;
        }
    }
}

