/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.security.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.cloudfoundry.security.org.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import org.cloudfoundry.security.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.cloudfoundry.security.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.cloudfoundry.security.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.cloudfoundry.security.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.cloudfoundry.security.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.cloudfoundry.security.org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.cloudfoundry.security.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import org.cloudfoundry.security.org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.cloudfoundry.security.org.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import org.cloudfoundry.security.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.mceliece.McElieceCCA2KeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.mceliece.McElieceKeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.qtesla.QTESLAKeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.rainbow.RainbowKeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import org.cloudfoundry.security.org.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Security Provider v1.69";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, (String)"java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "org.cloudfoundry.security.org.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "ARIA", "Blowfish", "Camellia", "CAST5", "CAST6", "ChaCha", "DES", "DESede", "GOST28147", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC2", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Shacal2", "Skipjack", "SM4", "TEA", "Twofish", "Threefish", "VMPC", "VMPCKSA3", "XTEA", "XSalsa20", "OpenSSLPBKDF", "DSTU7624", "GOST3412_2015", "Zuc"};
    private static final String ASYMMETRIC_PACKAGE = "org.cloudfoundry.security.org.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC"};
    private static final String DIGEST_PACKAGE = "org.cloudfoundry.security.org.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka"};
    private static final String KEYSTORE_PACKAGE = "org.cloudfoundry.security.org.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "org.cloudfoundry.security.org.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};

    public BouncyCastleProvider() {
        super("BC", 1.69, info);
        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setup() {
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.digest.", DIGESTS);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_GENERIC);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_MACS);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_CIPHERS);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_GENERIC);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_CIPHERS);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.keystore.", KEYSTORES);
        this.loadAlgorithms("org.cloudfoundry.security.org.bouncycastle.jcajce.provider.drbg.", SECURE_RANDOMS);
        this.loadPQCKeys();
        this.put((Object)"X509Store.CERTIFICATE/COLLECTION", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreCertCollection");
        this.put((Object)"X509Store.ATTRIBUTECERTIFICATE/COLLECTION", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        this.put((Object)"X509Store.CRL/COLLECTION", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreCRLCollection");
        this.put((Object)"X509Store.CERTIFICATEPAIR/COLLECTION", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreCertPairCollection");
        this.put((Object)"X509Store.CERTIFICATE/LDAP", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreLDAPCerts");
        this.put((Object)"X509Store.CRL/LDAP", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        this.put((Object)"X509Store.ATTRIBUTECERTIFICATE/LDAP", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        this.put((Object)"X509Store.CERTIFICATEPAIR/LDAP", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        this.put((Object)"X509StreamParser.CERTIFICATE", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509CertParser");
        this.put((Object)"X509StreamParser.ATTRIBUTECERTIFICATE", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509AttrCertParser");
        this.put((Object)"X509StreamParser.CRL", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509CRLParser");
        this.put((Object)"X509StreamParser.CERTIFICATEPAIR", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509CertPairParser");
        this.put((Object)"Cipher.BROKENPBEWITHMD5ANDDES", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put((Object)"Cipher.BROKENPBEWITHSHA1ANDDES", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put((Object)"Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            this.put((Object)"CertPathValidator.RFC3281", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3281", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put((Object)"CertPathValidator.PKIX", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put((Object)"CertPathValidator.RFC3281", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3281", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.PKIX", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put((Object)"CertStore.Collection", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put((Object)"CertStore.LDAP", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put((Object)"CertStore.Multi", (Object)"org.cloudfoundry.security.org.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put((Object)"Alg.Alias.CertStore.X509LDAP", (Object)"LDAP");
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, (String)(string + stringArray[i] + "$Mappings"));
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure((ConfigurableProvider)this);
                continue;
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + stringArray[i] + "$Mappings : " + exception);
            }
        }
    }

    private void loadPQCKeys() {
        this.addKeyInfoConverter(PQCObjectIdentifiers.sphincs256, (AsymmetricKeyInfoConverter)new Sphincs256KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.newHope, (AsymmetricKeyInfoConverter)new NHKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss_mt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmssmt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.mcEliece, (AsymmetricKeyInfoConverter)new McElieceKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.mcElieceCca2, (AsymmetricKeyInfoConverter)new McElieceCCA2KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.rainbow, (AsymmetricKeyInfoConverter)new RainbowKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.qTESLA_p_I, (AsymmetricKeyInfoConverter)new QTESLAKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.qTESLA_p_III, (AsymmetricKeyInfoConverter)new QTESLAKeyFactorySpi());
        this.addKeyInfoConverter(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, (AsymmetricKeyInfoConverter)new LMSKeyFactorySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey((Object)(string + "." + string2)) || this.containsKey((Object)("Alg.Alias." + string + "." + string2));
    }

    public void addAlgorithm(String string, String string2) {
        if (this.containsKey((Object)string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put((Object)string, (Object)string2);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
        this.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    public void addAttributes(String string, Map<String, String> map) {
        for (String string2 : map.keySet()) {
            String string3 = string + " " + string2;
            if (this.containsKey((Object)string3)) {
                throw new IllegalStateException("duplicate provider attribute key (" + string3 + ") found");
            }
            this.put((Object)string3, (Object)map.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    static /* synthetic */ void access$000(BouncyCastleProvider bouncyCastleProvider) {
        bouncyCastleProvider.setup();
    }
}

