/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import org.cloudfoundry.security.org.bouncycastle.math.ec.ECCurve;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECPoint;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP128R1Field;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP128R1FieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat128;

public class SecP128R1Point
extends ECPoint.AbstractFp {
    SecP128R1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
    }

    SecP128R1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    protected ECPoint detach() {
        return new SecP128R1Point(null, this.getAffineXCoord(), this.getAffineYCoord());
    }

    @Override
    public ECPoint add(ECPoint eCPoint) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this;
        }
        if (this == eCPoint) {
            return this.twice();
        }
        ECCurve eCCurve = this.getCurve();
        SecP128R1FieldElement secP128R1FieldElement = (SecP128R1FieldElement)this.x;
        SecP128R1FieldElement secP128R1FieldElement2 = (SecP128R1FieldElement)this.y;
        SecP128R1FieldElement secP128R1FieldElement3 = (SecP128R1FieldElement)eCPoint.getXCoord();
        SecP128R1FieldElement secP128R1FieldElement4 = (SecP128R1FieldElement)eCPoint.getYCoord();
        SecP128R1FieldElement secP128R1FieldElement5 = (SecP128R1FieldElement)this.zs[0];
        SecP128R1FieldElement secP128R1FieldElement6 = (SecP128R1FieldElement)eCPoint.getZCoord(0);
        int[] nArray5 = Nat128.createExt();
        int[] nArray6 = Nat128.create();
        int[] nArray7 = Nat128.create();
        int[] nArray8 = Nat128.create();
        boolean bl = secP128R1FieldElement5.isOne();
        if (bl) {
            nArray4 = secP128R1FieldElement3.x;
            nArray3 = secP128R1FieldElement4.x;
        } else {
            nArray3 = nArray7;
            SecP128R1Field.square((int[])secP128R1FieldElement5.x, (int[])nArray3);
            nArray4 = nArray6;
            SecP128R1Field.multiply((int[])nArray3, (int[])secP128R1FieldElement3.x, (int[])nArray4);
            SecP128R1Field.multiply((int[])nArray3, (int[])secP128R1FieldElement5.x, (int[])nArray3);
            SecP128R1Field.multiply((int[])nArray3, (int[])secP128R1FieldElement4.x, (int[])nArray3);
        }
        boolean bl2 = secP128R1FieldElement6.isOne();
        if (bl2) {
            nArray2 = secP128R1FieldElement.x;
            nArray = secP128R1FieldElement2.x;
        } else {
            nArray = nArray8;
            SecP128R1Field.square((int[])secP128R1FieldElement6.x, (int[])nArray);
            nArray2 = nArray5;
            SecP128R1Field.multiply((int[])nArray, (int[])secP128R1FieldElement.x, (int[])nArray2);
            SecP128R1Field.multiply((int[])nArray, (int[])secP128R1FieldElement6.x, (int[])nArray);
            SecP128R1Field.multiply((int[])nArray, (int[])secP128R1FieldElement2.x, (int[])nArray);
        }
        int[] nArray9 = Nat128.create();
        SecP128R1Field.subtract((int[])nArray2, (int[])nArray4, (int[])nArray9);
        int[] nArray10 = nArray6;
        SecP128R1Field.subtract((int[])nArray, (int[])nArray3, (int[])nArray10);
        if (Nat128.isZero((int[])nArray9)) {
            if (Nat128.isZero((int[])nArray10)) {
                return this.twice();
            }
            return eCCurve.getInfinity();
        }
        int[] nArray11 = nArray7;
        SecP128R1Field.square((int[])nArray9, (int[])nArray11);
        int[] nArray12 = Nat128.create();
        SecP128R1Field.multiply((int[])nArray11, (int[])nArray9, (int[])nArray12);
        int[] nArray13 = nArray7;
        SecP128R1Field.multiply((int[])nArray11, (int[])nArray2, (int[])nArray13);
        SecP128R1Field.negate((int[])nArray12, (int[])nArray12);
        Nat128.mul((int[])nArray, (int[])nArray12, (int[])nArray5);
        int n = Nat128.addBothTo((int[])nArray13, (int[])nArray13, (int[])nArray12);
        SecP128R1Field.reduce32((int)n, (int[])nArray12);
        SecP128R1FieldElement secP128R1FieldElement7 = new SecP128R1FieldElement(nArray8);
        SecP128R1Field.square((int[])nArray10, (int[])secP128R1FieldElement7.x);
        SecP128R1Field.subtract((int[])secP128R1FieldElement7.x, (int[])nArray12, (int[])secP128R1FieldElement7.x);
        SecP128R1FieldElement secP128R1FieldElement8 = new SecP128R1FieldElement(nArray12);
        SecP128R1Field.subtract((int[])nArray13, (int[])secP128R1FieldElement7.x, (int[])secP128R1FieldElement8.x);
        SecP128R1Field.multiplyAddToExt((int[])secP128R1FieldElement8.x, (int[])nArray10, (int[])nArray5);
        SecP128R1Field.reduce((int[])nArray5, (int[])secP128R1FieldElement8.x);
        SecP128R1FieldElement secP128R1FieldElement9 = new SecP128R1FieldElement(nArray9);
        if (!bl) {
            SecP128R1Field.multiply((int[])secP128R1FieldElement9.x, (int[])secP128R1FieldElement5.x, (int[])secP128R1FieldElement9.x);
        }
        if (!bl2) {
            SecP128R1Field.multiply((int[])secP128R1FieldElement9.x, (int[])secP128R1FieldElement6.x, (int[])secP128R1FieldElement9.x);
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[]{secP128R1FieldElement9};
        return new SecP128R1Point(eCCurve, (ECFieldElement)secP128R1FieldElement7, (ECFieldElement)secP128R1FieldElement8, eCFieldElementArray);
    }

    @Override
    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        ECCurve eCCurve = this.getCurve();
        SecP128R1FieldElement secP128R1FieldElement = (SecP128R1FieldElement)this.y;
        if (secP128R1FieldElement.isZero()) {
            return eCCurve.getInfinity();
        }
        SecP128R1FieldElement secP128R1FieldElement2 = (SecP128R1FieldElement)this.x;
        SecP128R1FieldElement secP128R1FieldElement3 = (SecP128R1FieldElement)this.zs[0];
        int[] nArray = Nat128.create();
        int[] nArray2 = Nat128.create();
        int[] nArray3 = Nat128.create();
        SecP128R1Field.square((int[])secP128R1FieldElement.x, (int[])nArray3);
        int[] nArray4 = Nat128.create();
        SecP128R1Field.square((int[])nArray3, (int[])nArray4);
        boolean bl = secP128R1FieldElement3.isOne();
        int[] nArray5 = secP128R1FieldElement3.x;
        if (!bl) {
            nArray5 = nArray2;
            SecP128R1Field.square((int[])secP128R1FieldElement3.x, (int[])nArray5);
        }
        SecP128R1Field.subtract((int[])secP128R1FieldElement2.x, (int[])nArray5, (int[])nArray);
        int[] nArray6 = nArray2;
        SecP128R1Field.add((int[])secP128R1FieldElement2.x, (int[])nArray5, (int[])nArray6);
        SecP128R1Field.multiply((int[])nArray6, (int[])nArray, (int[])nArray6);
        int n = Nat128.addBothTo((int[])nArray6, (int[])nArray6, (int[])nArray6);
        SecP128R1Field.reduce32((int)n, (int[])nArray6);
        int[] nArray7 = nArray3;
        SecP128R1Field.multiply((int[])nArray3, (int[])secP128R1FieldElement2.x, (int[])nArray7);
        n = Nat.shiftUpBits(4, nArray7, 2, 0);
        SecP128R1Field.reduce32((int)n, (int[])nArray7);
        n = Nat.shiftUpBits(4, nArray4, 3, 0, nArray);
        SecP128R1Field.reduce32((int)n, (int[])nArray);
        SecP128R1FieldElement secP128R1FieldElement4 = new SecP128R1FieldElement(nArray4);
        SecP128R1Field.square((int[])nArray6, (int[])secP128R1FieldElement4.x);
        SecP128R1Field.subtract((int[])secP128R1FieldElement4.x, (int[])nArray7, (int[])secP128R1FieldElement4.x);
        SecP128R1Field.subtract((int[])secP128R1FieldElement4.x, (int[])nArray7, (int[])secP128R1FieldElement4.x);
        SecP128R1FieldElement secP128R1FieldElement5 = new SecP128R1FieldElement(nArray7);
        SecP128R1Field.subtract((int[])nArray7, (int[])secP128R1FieldElement4.x, (int[])secP128R1FieldElement5.x);
        SecP128R1Field.multiply((int[])secP128R1FieldElement5.x, (int[])nArray6, (int[])secP128R1FieldElement5.x);
        SecP128R1Field.subtract((int[])secP128R1FieldElement5.x, (int[])nArray, (int[])secP128R1FieldElement5.x);
        SecP128R1FieldElement secP128R1FieldElement6 = new SecP128R1FieldElement(nArray6);
        SecP128R1Field.twice((int[])secP128R1FieldElement.x, (int[])secP128R1FieldElement6.x);
        if (!bl) {
            SecP128R1Field.multiply((int[])secP128R1FieldElement6.x, (int[])secP128R1FieldElement3.x, (int[])secP128R1FieldElement6.x);
        }
        return new SecP128R1Point(eCCurve, (ECFieldElement)secP128R1FieldElement4, (ECFieldElement)secP128R1FieldElement5, new ECFieldElement[]{secP128R1FieldElement6});
    }

    @Override
    public ECPoint twicePlus(ECPoint eCPoint) {
        if (this == eCPoint) {
            return this.threeTimes();
        }
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.twice();
        }
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return eCPoint;
        }
        return this.twice().add(eCPoint);
    }

    @Override
    public ECPoint threeTimes() {
        if (this.isInfinity() || this.y.isZero()) {
            return this;
        }
        return this.twice().add((ECPoint)this);
    }

    @Override
    public ECPoint negate() {
        if (this.isInfinity()) {
            return this;
        }
        return new SecP128R1Point(this.curve, this.x, this.y.negate(), this.zs);
    }
}

