/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECConstants;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECCurve;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECLookupTable;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECPoint;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP160R1Field;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP160R1FieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP160R1Point;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat160;
import org.cloudfoundry.security.org.bouncycastle.util.encoders.Hex;

public class SecP160R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP160R1FieldElement.Q;
    private static final int SECP160R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP160R1_AFFINE_ZS = new ECFieldElement[]{new SecP160R1FieldElement(ECConstants.ONE)};
    protected SecP160R1Point infinity = new SecP160R1Point((ECCurve)this, null, null);

    public SecP160R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45")));
        this.order = new BigInteger(1, Hex.decodeStrict("0100000000000000000001F4C8F927AED3CA752257"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP160R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP160R1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP160R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 5 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat160.copy((int[])((SecP160R1FieldElement)eCPoint.getRawXCoord()).x, (int)0, (int[])nArray, (int)n3);
            Nat160.copy((int[])((SecP160R1FieldElement)eCPoint.getRawYCoord()).x, (int)0, (int[])nArray, (int)(n3 += 5));
            n3 += 5;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        SecP160R1Field.random((SecureRandom)secureRandom, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        SecP160R1Field.randomMult((SecureRandom)secureRandom, (int[])nArray);
        return new SecP160R1FieldElement(nArray);
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECP160R1_AFFINE_ZS;
    }
}

