/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import org.cloudfoundry.security.org.bouncycastle.math.ec.ECCurve;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECPoint;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP160R1Field;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP160R1FieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat160;

public class SecP160R1Point
extends ECPoint.AbstractFp {
    SecP160R1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
    }

    SecP160R1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    protected ECPoint detach() {
        return new SecP160R1Point(null, this.getAffineXCoord(), this.getAffineYCoord());
    }

    @Override
    public ECPoint add(ECPoint eCPoint) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this;
        }
        if (this == eCPoint) {
            return this.twice();
        }
        ECCurve eCCurve = this.getCurve();
        SecP160R1FieldElement secP160R1FieldElement = (SecP160R1FieldElement)this.x;
        SecP160R1FieldElement secP160R1FieldElement2 = (SecP160R1FieldElement)this.y;
        SecP160R1FieldElement secP160R1FieldElement3 = (SecP160R1FieldElement)eCPoint.getXCoord();
        SecP160R1FieldElement secP160R1FieldElement4 = (SecP160R1FieldElement)eCPoint.getYCoord();
        SecP160R1FieldElement secP160R1FieldElement5 = (SecP160R1FieldElement)this.zs[0];
        SecP160R1FieldElement secP160R1FieldElement6 = (SecP160R1FieldElement)eCPoint.getZCoord(0);
        int[] nArray5 = Nat160.createExt();
        int[] nArray6 = Nat160.create();
        int[] nArray7 = Nat160.create();
        int[] nArray8 = Nat160.create();
        boolean bl = secP160R1FieldElement5.isOne();
        if (bl) {
            nArray4 = secP160R1FieldElement3.x;
            nArray3 = secP160R1FieldElement4.x;
        } else {
            nArray3 = nArray7;
            SecP160R1Field.square((int[])secP160R1FieldElement5.x, (int[])nArray3);
            nArray4 = nArray6;
            SecP160R1Field.multiply((int[])nArray3, (int[])secP160R1FieldElement3.x, (int[])nArray4);
            SecP160R1Field.multiply((int[])nArray3, (int[])secP160R1FieldElement5.x, (int[])nArray3);
            SecP160R1Field.multiply((int[])nArray3, (int[])secP160R1FieldElement4.x, (int[])nArray3);
        }
        boolean bl2 = secP160R1FieldElement6.isOne();
        if (bl2) {
            nArray2 = secP160R1FieldElement.x;
            nArray = secP160R1FieldElement2.x;
        } else {
            nArray = nArray8;
            SecP160R1Field.square((int[])secP160R1FieldElement6.x, (int[])nArray);
            nArray2 = nArray5;
            SecP160R1Field.multiply((int[])nArray, (int[])secP160R1FieldElement.x, (int[])nArray2);
            SecP160R1Field.multiply((int[])nArray, (int[])secP160R1FieldElement6.x, (int[])nArray);
            SecP160R1Field.multiply((int[])nArray, (int[])secP160R1FieldElement2.x, (int[])nArray);
        }
        int[] nArray9 = Nat160.create();
        SecP160R1Field.subtract((int[])nArray2, (int[])nArray4, (int[])nArray9);
        int[] nArray10 = nArray6;
        SecP160R1Field.subtract((int[])nArray, (int[])nArray3, (int[])nArray10);
        if (Nat160.isZero((int[])nArray9)) {
            if (Nat160.isZero((int[])nArray10)) {
                return this.twice();
            }
            return eCCurve.getInfinity();
        }
        int[] nArray11 = nArray7;
        SecP160R1Field.square((int[])nArray9, (int[])nArray11);
        int[] nArray12 = Nat160.create();
        SecP160R1Field.multiply((int[])nArray11, (int[])nArray9, (int[])nArray12);
        int[] nArray13 = nArray7;
        SecP160R1Field.multiply((int[])nArray11, (int[])nArray2, (int[])nArray13);
        SecP160R1Field.negate((int[])nArray12, (int[])nArray12);
        Nat160.mul((int[])nArray, (int[])nArray12, (int[])nArray5);
        int n = Nat160.addBothTo((int[])nArray13, (int[])nArray13, (int[])nArray12);
        SecP160R1Field.reduce32((int)n, (int[])nArray12);
        SecP160R1FieldElement secP160R1FieldElement7 = new SecP160R1FieldElement(nArray8);
        SecP160R1Field.square((int[])nArray10, (int[])secP160R1FieldElement7.x);
        SecP160R1Field.subtract((int[])secP160R1FieldElement7.x, (int[])nArray12, (int[])secP160R1FieldElement7.x);
        SecP160R1FieldElement secP160R1FieldElement8 = new SecP160R1FieldElement(nArray12);
        SecP160R1Field.subtract((int[])nArray13, (int[])secP160R1FieldElement7.x, (int[])secP160R1FieldElement8.x);
        SecP160R1Field.multiplyAddToExt((int[])secP160R1FieldElement8.x, (int[])nArray10, (int[])nArray5);
        SecP160R1Field.reduce((int[])nArray5, (int[])secP160R1FieldElement8.x);
        SecP160R1FieldElement secP160R1FieldElement9 = new SecP160R1FieldElement(nArray9);
        if (!bl) {
            SecP160R1Field.multiply((int[])secP160R1FieldElement9.x, (int[])secP160R1FieldElement5.x, (int[])secP160R1FieldElement9.x);
        }
        if (!bl2) {
            SecP160R1Field.multiply((int[])secP160R1FieldElement9.x, (int[])secP160R1FieldElement6.x, (int[])secP160R1FieldElement9.x);
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[]{secP160R1FieldElement9};
        return new SecP160R1Point(eCCurve, (ECFieldElement)secP160R1FieldElement7, (ECFieldElement)secP160R1FieldElement8, eCFieldElementArray);
    }

    @Override
    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        ECCurve eCCurve = this.getCurve();
        SecP160R1FieldElement secP160R1FieldElement = (SecP160R1FieldElement)this.y;
        if (secP160R1FieldElement.isZero()) {
            return eCCurve.getInfinity();
        }
        SecP160R1FieldElement secP160R1FieldElement2 = (SecP160R1FieldElement)this.x;
        SecP160R1FieldElement secP160R1FieldElement3 = (SecP160R1FieldElement)this.zs[0];
        int[] nArray = Nat160.create();
        int[] nArray2 = Nat160.create();
        int[] nArray3 = Nat160.create();
        SecP160R1Field.square((int[])secP160R1FieldElement.x, (int[])nArray3);
        int[] nArray4 = Nat160.create();
        SecP160R1Field.square((int[])nArray3, (int[])nArray4);
        boolean bl = secP160R1FieldElement3.isOne();
        int[] nArray5 = secP160R1FieldElement3.x;
        if (!bl) {
            nArray5 = nArray2;
            SecP160R1Field.square((int[])secP160R1FieldElement3.x, (int[])nArray5);
        }
        SecP160R1Field.subtract((int[])secP160R1FieldElement2.x, (int[])nArray5, (int[])nArray);
        int[] nArray6 = nArray2;
        SecP160R1Field.add((int[])secP160R1FieldElement2.x, (int[])nArray5, (int[])nArray6);
        SecP160R1Field.multiply((int[])nArray6, (int[])nArray, (int[])nArray6);
        int n = Nat160.addBothTo((int[])nArray6, (int[])nArray6, (int[])nArray6);
        SecP160R1Field.reduce32((int)n, (int[])nArray6);
        int[] nArray7 = nArray3;
        SecP160R1Field.multiply((int[])nArray3, (int[])secP160R1FieldElement2.x, (int[])nArray7);
        n = Nat.shiftUpBits(5, nArray7, 2, 0);
        SecP160R1Field.reduce32((int)n, (int[])nArray7);
        n = Nat.shiftUpBits(5, nArray4, 3, 0, nArray);
        SecP160R1Field.reduce32((int)n, (int[])nArray);
        SecP160R1FieldElement secP160R1FieldElement4 = new SecP160R1FieldElement(nArray4);
        SecP160R1Field.square((int[])nArray6, (int[])secP160R1FieldElement4.x);
        SecP160R1Field.subtract((int[])secP160R1FieldElement4.x, (int[])nArray7, (int[])secP160R1FieldElement4.x);
        SecP160R1Field.subtract((int[])secP160R1FieldElement4.x, (int[])nArray7, (int[])secP160R1FieldElement4.x);
        SecP160R1FieldElement secP160R1FieldElement5 = new SecP160R1FieldElement(nArray7);
        SecP160R1Field.subtract((int[])nArray7, (int[])secP160R1FieldElement4.x, (int[])secP160R1FieldElement5.x);
        SecP160R1Field.multiply((int[])secP160R1FieldElement5.x, (int[])nArray6, (int[])secP160R1FieldElement5.x);
        SecP160R1Field.subtract((int[])secP160R1FieldElement5.x, (int[])nArray, (int[])secP160R1FieldElement5.x);
        SecP160R1FieldElement secP160R1FieldElement6 = new SecP160R1FieldElement(nArray6);
        SecP160R1Field.twice((int[])secP160R1FieldElement.x, (int[])secP160R1FieldElement6.x);
        if (!bl) {
            SecP160R1Field.multiply((int[])secP160R1FieldElement6.x, (int[])secP160R1FieldElement3.x, (int[])secP160R1FieldElement6.x);
        }
        return new SecP160R1Point(eCCurve, (ECFieldElement)secP160R1FieldElement4, (ECFieldElement)secP160R1FieldElement5, new ECFieldElement[]{secP160R1FieldElement6});
    }

    @Override
    public ECPoint twicePlus(ECPoint eCPoint) {
        if (this == eCPoint) {
            return this.threeTimes();
        }
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.twice();
        }
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return eCPoint;
        }
        return this.twice().add(eCPoint);
    }

    @Override
    public ECPoint threeTimes() {
        if (this.isInfinity() || this.y.isZero()) {
            return this;
        }
        return this.twice().add((ECPoint)this);
    }

    @Override
    public ECPoint negate() {
        if (this.isInfinity()) {
            return this;
        }
        return new SecP160R1Point(this.curve, this.x, this.y.negate(), this.zs);
    }
}

