/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Mod;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat192;
import org.cloudfoundry.security.org.bouncycastle.util.Pack;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecP192K1Field {
    static final int[] P = new int[]{-4553, -2, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{20729809, 9106, 1, 0, 0, 0, -9106, -3, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-20729809, -9107, -2, -1, -1, -1, 9105, 2};
    private static final int P5 = -1;
    private static final int PExt11 = -1;
    private static final int PInv33 = 4553;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat192.add((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0 || nArray3[5] == -1 && Nat192.gte((int[])nArray3, (int[])P)) {
            Nat.add33To(6, 4553, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add(12, nArray, nArray2, nArray3);
        if ((n != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, PExt)) && Nat.addTo(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.incAt(12, nArray3, PExtInv.length);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n = Nat.inc(6, nArray, nArray2);
        if (n != 0 || nArray2[5] == -1 && Nat192.gte((int[])nArray2, (int[])P)) {
            Nat.add33To(6, 4553, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat192.fromBigInteger((BigInteger)bigInteger);
        if (nArray[5] == -1 && Nat192.gte((int[])nArray, (int[])P)) {
            Nat192.subFrom((int[])P, (int[])nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(6, nArray, 0, nArray2);
        } else {
            int n = Nat192.add((int[])nArray, (int[])P, (int[])nArray2);
            Nat.shiftDownBit(6, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n |= nArray[i];
        }
        n = n >>> 1 | n & 1;
        return n - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat192.createExt();
        Nat192.mul((int[])nArray, (int[])nArray2, (int[])nArray4);
        SecP192K1Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat192.mulAddTo((int[])nArray, (int[])nArray2, (int[])nArray3);
        if ((n != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, PExt)) && Nat.addTo(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.incAt(12, nArray3, PExtInv.length);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (0 != SecP192K1Field.isZero((int[])nArray)) {
            Nat192.sub((int[])P, (int[])P, (int[])nArray2);
        } else {
            Nat192.sub((int[])P, (int[])nArray, (int[])nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        byte[] byArray = new byte[24];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 6);
        } while (0 == Nat.lessThan(6, nArray, P));
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP192K1Field.random((SecureRandom)secureRandom, (int[])nArray);
        } while (0 != SecP192K1Field.isZero((int[])nArray));
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = Nat192.mul33Add((int)4553, (int[])nArray, (int)6, (int[])nArray, (int)0, (int[])nArray2, (int)0);
        int n = Nat192.mul33DWordAdd((int)4553, (long)l, (int[])nArray2, (int)0);
        if (n != 0 || nArray2[5] == -1 && Nat192.gte((int[])nArray2, (int[])P)) {
            Nat.add33To(6, 4553, nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        if (n != 0 && Nat192.mul33WordAdd((int)4553, (int)n, (int[])nArray, (int)0) != 0 || nArray[5] == -1 && Nat192.gte((int[])nArray, (int[])P)) {
            Nat.add33To(6, 4553, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square((int[])nArray, (int[])nArray3);
        SecP192K1Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat192.createExt();
        Nat192.square((int[])nArray, (int[])nArray3);
        SecP192K1Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            Nat192.square((int[])nArray2, (int[])nArray3);
            SecP192K1Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat192.sub((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0) {
            Nat.sub33From(6, 4553, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub(12, nArray, nArray2, nArray3);
        if (n != 0 && Nat.subFrom(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.decAt(12, nArray3, PExtInv.length);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n = Nat.shiftUpBit(6, nArray, 0, nArray2);
        if (n != 0 || nArray2[5] == -1 && Nat192.gte((int[])nArray2, (int[])P)) {
            Nat.add33To(6, 4553, nArray2);
        }
    }
}

