/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import org.cloudfoundry.security.org.bouncycastle.math.ec.ECCurve;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECPoint;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP256K1Field;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP256K1FieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat256;

public class SecP256K1Point
extends ECPoint.AbstractFp {
    SecP256K1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
    }

    SecP256K1Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    protected ECPoint detach() {
        return new SecP256K1Point(null, this.getAffineXCoord(), this.getAffineYCoord());
    }

    @Override
    public ECPoint add(ECPoint eCPoint) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this;
        }
        if (this == eCPoint) {
            return this.twice();
        }
        ECCurve eCCurve = this.getCurve();
        SecP256K1FieldElement secP256K1FieldElement = (SecP256K1FieldElement)this.x;
        SecP256K1FieldElement secP256K1FieldElement2 = (SecP256K1FieldElement)this.y;
        SecP256K1FieldElement secP256K1FieldElement3 = (SecP256K1FieldElement)eCPoint.getXCoord();
        SecP256K1FieldElement secP256K1FieldElement4 = (SecP256K1FieldElement)eCPoint.getYCoord();
        SecP256K1FieldElement secP256K1FieldElement5 = (SecP256K1FieldElement)this.zs[0];
        SecP256K1FieldElement secP256K1FieldElement6 = (SecP256K1FieldElement)eCPoint.getZCoord(0);
        int[] nArray5 = Nat256.createExt();
        int[] nArray6 = Nat256.create();
        int[] nArray7 = Nat256.create();
        int[] nArray8 = Nat256.create();
        boolean bl = secP256K1FieldElement5.isOne();
        if (bl) {
            nArray4 = secP256K1FieldElement3.x;
            nArray3 = secP256K1FieldElement4.x;
        } else {
            nArray3 = nArray7;
            SecP256K1Field.square((int[])secP256K1FieldElement5.x, (int[])nArray3);
            nArray4 = nArray6;
            SecP256K1Field.multiply((int[])nArray3, (int[])secP256K1FieldElement3.x, (int[])nArray4);
            SecP256K1Field.multiply((int[])nArray3, (int[])secP256K1FieldElement5.x, (int[])nArray3);
            SecP256K1Field.multiply((int[])nArray3, (int[])secP256K1FieldElement4.x, (int[])nArray3);
        }
        boolean bl2 = secP256K1FieldElement6.isOne();
        if (bl2) {
            nArray2 = secP256K1FieldElement.x;
            nArray = secP256K1FieldElement2.x;
        } else {
            nArray = nArray8;
            SecP256K1Field.square((int[])secP256K1FieldElement6.x, (int[])nArray);
            nArray2 = nArray5;
            SecP256K1Field.multiply((int[])nArray, (int[])secP256K1FieldElement.x, (int[])nArray2);
            SecP256K1Field.multiply((int[])nArray, (int[])secP256K1FieldElement6.x, (int[])nArray);
            SecP256K1Field.multiply((int[])nArray, (int[])secP256K1FieldElement2.x, (int[])nArray);
        }
        int[] nArray9 = Nat256.create();
        SecP256K1Field.subtract((int[])nArray2, (int[])nArray4, (int[])nArray9);
        int[] nArray10 = nArray6;
        SecP256K1Field.subtract((int[])nArray, (int[])nArray3, (int[])nArray10);
        if (Nat256.isZero((int[])nArray9)) {
            if (Nat256.isZero((int[])nArray10)) {
                return this.twice();
            }
            return eCCurve.getInfinity();
        }
        int[] nArray11 = nArray7;
        SecP256K1Field.square((int[])nArray9, (int[])nArray11);
        int[] nArray12 = Nat256.create();
        SecP256K1Field.multiply((int[])nArray11, (int[])nArray9, (int[])nArray12);
        int[] nArray13 = nArray7;
        SecP256K1Field.multiply((int[])nArray11, (int[])nArray2, (int[])nArray13);
        SecP256K1Field.negate((int[])nArray12, (int[])nArray12);
        Nat256.mul((int[])nArray, (int[])nArray12, (int[])nArray5);
        int n = Nat256.addBothTo((int[])nArray13, (int[])nArray13, (int[])nArray12);
        SecP256K1Field.reduce32((int)n, (int[])nArray12);
        SecP256K1FieldElement secP256K1FieldElement7 = new SecP256K1FieldElement(nArray8);
        SecP256K1Field.square((int[])nArray10, (int[])secP256K1FieldElement7.x);
        SecP256K1Field.subtract((int[])secP256K1FieldElement7.x, (int[])nArray12, (int[])secP256K1FieldElement7.x);
        SecP256K1FieldElement secP256K1FieldElement8 = new SecP256K1FieldElement(nArray12);
        SecP256K1Field.subtract((int[])nArray13, (int[])secP256K1FieldElement7.x, (int[])secP256K1FieldElement8.x);
        SecP256K1Field.multiplyAddToExt((int[])secP256K1FieldElement8.x, (int[])nArray10, (int[])nArray5);
        SecP256K1Field.reduce((int[])nArray5, (int[])secP256K1FieldElement8.x);
        SecP256K1FieldElement secP256K1FieldElement9 = new SecP256K1FieldElement(nArray9);
        if (!bl) {
            SecP256K1Field.multiply((int[])secP256K1FieldElement9.x, (int[])secP256K1FieldElement5.x, (int[])secP256K1FieldElement9.x);
        }
        if (!bl2) {
            SecP256K1Field.multiply((int[])secP256K1FieldElement9.x, (int[])secP256K1FieldElement6.x, (int[])secP256K1FieldElement9.x);
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[]{secP256K1FieldElement9};
        return new SecP256K1Point(eCCurve, (ECFieldElement)secP256K1FieldElement7, (ECFieldElement)secP256K1FieldElement8, eCFieldElementArray);
    }

    @Override
    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        ECCurve eCCurve = this.getCurve();
        SecP256K1FieldElement secP256K1FieldElement = (SecP256K1FieldElement)this.y;
        if (secP256K1FieldElement.isZero()) {
            return eCCurve.getInfinity();
        }
        SecP256K1FieldElement secP256K1FieldElement2 = (SecP256K1FieldElement)this.x;
        SecP256K1FieldElement secP256K1FieldElement3 = (SecP256K1FieldElement)this.zs[0];
        int[] nArray = Nat256.create();
        SecP256K1Field.square((int[])secP256K1FieldElement.x, (int[])nArray);
        int[] nArray2 = Nat256.create();
        SecP256K1Field.square((int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat256.create();
        SecP256K1Field.square((int[])secP256K1FieldElement2.x, (int[])nArray3);
        int n = Nat256.addBothTo((int[])nArray3, (int[])nArray3, (int[])nArray3);
        SecP256K1Field.reduce32((int)n, (int[])nArray3);
        int[] nArray4 = nArray;
        SecP256K1Field.multiply((int[])nArray, (int[])secP256K1FieldElement2.x, (int[])nArray4);
        n = Nat.shiftUpBits(8, nArray4, 2, 0);
        SecP256K1Field.reduce32((int)n, (int[])nArray4);
        int[] nArray5 = Nat256.create();
        n = Nat.shiftUpBits(8, nArray2, 3, 0, nArray5);
        SecP256K1Field.reduce32((int)n, (int[])nArray5);
        SecP256K1FieldElement secP256K1FieldElement4 = new SecP256K1FieldElement(nArray2);
        SecP256K1Field.square((int[])nArray3, (int[])secP256K1FieldElement4.x);
        SecP256K1Field.subtract((int[])secP256K1FieldElement4.x, (int[])nArray4, (int[])secP256K1FieldElement4.x);
        SecP256K1Field.subtract((int[])secP256K1FieldElement4.x, (int[])nArray4, (int[])secP256K1FieldElement4.x);
        SecP256K1FieldElement secP256K1FieldElement5 = new SecP256K1FieldElement(nArray4);
        SecP256K1Field.subtract((int[])nArray4, (int[])secP256K1FieldElement4.x, (int[])secP256K1FieldElement5.x);
        SecP256K1Field.multiply((int[])secP256K1FieldElement5.x, (int[])nArray3, (int[])secP256K1FieldElement5.x);
        SecP256K1Field.subtract((int[])secP256K1FieldElement5.x, (int[])nArray5, (int[])secP256K1FieldElement5.x);
        SecP256K1FieldElement secP256K1FieldElement6 = new SecP256K1FieldElement(nArray3);
        SecP256K1Field.twice((int[])secP256K1FieldElement.x, (int[])secP256K1FieldElement6.x);
        if (!secP256K1FieldElement3.isOne()) {
            SecP256K1Field.multiply((int[])secP256K1FieldElement6.x, (int[])secP256K1FieldElement3.x, (int[])secP256K1FieldElement6.x);
        }
        return new SecP256K1Point(eCCurve, (ECFieldElement)secP256K1FieldElement4, (ECFieldElement)secP256K1FieldElement5, new ECFieldElement[]{secP256K1FieldElement6});
    }

    @Override
    public ECPoint twicePlus(ECPoint eCPoint) {
        if (this == eCPoint) {
            return this.threeTimes();
        }
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.twice();
        }
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return eCPoint;
        }
        return this.twice().add(eCPoint);
    }

    @Override
    public ECPoint threeTimes() {
        if (this.isInfinity() || this.y.isZero()) {
            return this;
        }
        return this.twice().add((ECPoint)this);
    }

    @Override
    public ECPoint negate() {
        if (this.isInfinity()) {
            return this;
        }
        return new SecP256K1Point(this.curve, this.x, this.y.negate(), this.zs);
    }
}

