/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecP521R1Field;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat;
import org.cloudfoundry.security.org.bouncycastle.util.Arrays;
import org.cloudfoundry.security.org.bouncycastle.util.encoders.Hex;

public class SecP521R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"));
    protected int[] x;

    public SecP521R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP521R1FieldElement");
        }
        this.x = SecP521R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP521R1FieldElement() {
        this.x = Nat.create(17);
    }

    protected SecP521R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat.isZero(17, this.x);
    }

    @Override
    public boolean isOne() {
        return Nat.isOne(17, this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat.toBigInteger(17, this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP521R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.add((int[])this.x, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.subtract((int[])this.x, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.multiply((int[])this.x, (int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat.create(17);
        SecP521R1Field.inv((int[])((SecP521R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP521R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.square((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat.create(17);
        SecP521R1Field.inv((int[])this.x, (int[])nArray);
        return new SecP521R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat.isZero(17, nArray) || Nat.isOne(17, nArray)) {
            return this;
        }
        int[] nArray2 = Nat.create(17);
        int[] nArray3 = Nat.create(17);
        SecP521R1Field.squareN((int[])nArray, (int)519, (int[])nArray2);
        SecP521R1Field.square((int[])nArray2, (int[])nArray3);
        return Nat.eq(17, nArray, nArray3) ? new SecP521R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP521R1FieldElement)) {
            return false;
        }
        SecP521R1FieldElement secP521R1FieldElement = (SecP521R1FieldElement)object;
        return Nat.eq(17, this.x, secP521R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 17);
    }
}

