/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecT131Field;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat192;
import org.cloudfoundry.security.org.bouncycastle.util.Arrays;

public class SecT131FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT131FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > 131) {
            throw new IllegalArgumentException("x value invalid for SecT131FieldElement");
        }
        this.x = SecT131Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecT131FieldElement() {
        this.x = Nat192.create64();
    }

    protected SecT131FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat192.isOne64((long[])this.x);
    }

    @Override
    public boolean isZero() {
        return Nat192.isZero64((long[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat192.toBigInteger64((long[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT131Field";
    }

    @Override
    public int getFieldSize() {
        return 131;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        long[] lArray = Nat192.create64();
        SecT131Field.add((long[])this.x, (long[])((SecT131FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat192.create64();
        SecT131Field.addOne((long[])this.x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        long[] lArray = Nat192.create64();
        SecT131Field.multiply((long[])this.x, (long[])((SecT131FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT131FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT131FieldElement)eCFieldElement2).x;
        long[] lArray4 = ((SecT131FieldElement)eCFieldElement3).x;
        long[] lArray5 = Nat.create64(5);
        SecT131Field.multiplyAddToExt((long[])lArray, (long[])lArray2, (long[])lArray5);
        SecT131Field.multiplyAddToExt((long[])lArray3, (long[])lArray4, (long[])lArray5);
        long[] lArray6 = Nat192.create64();
        SecT131Field.reduce((long[])lArray5, (long[])lArray6);
        return new SecT131FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat192.create64();
        SecT131Field.square((long[])this.x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT131FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT131FieldElement)eCFieldElement2).x;
        long[] lArray4 = Nat.create64(5);
        SecT131Field.squareAddToExt((long[])lArray, (long[])lArray4);
        SecT131Field.multiplyAddToExt((long[])lArray2, (long[])lArray3, (long[])lArray4);
        long[] lArray5 = Nat192.create64();
        SecT131Field.reduce((long[])lArray4, (long[])lArray5);
        return new SecT131FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return this;
        }
        long[] lArray = Nat192.create64();
        SecT131Field.squareN((long[])this.x, (int)n, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement halfTrace() {
        long[] lArray = Nat192.create64();
        SecT131Field.halfTrace((long[])this.x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT131Field.trace((long[])this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat192.create64();
        SecT131Field.invert((long[])this.x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat192.create64();
        SecT131Field.sqrt((long[])this.x, (long[])lArray);
        return new SecT131FieldElement(lArray);
    }

    public int getRepresentation() {
        return 3;
    }

    public int getM() {
        return 131;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 3;
    }

    public int getK3() {
        return 8;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecT131FieldElement)) {
            return false;
        }
        SecT131FieldElement secT131FieldElement = (SecT131FieldElement)object;
        return Nat192.eq64((long[])this.x, (long[])secT131FieldElement.x);
    }

    public int hashCode() {
        return 0x202F8 ^ Arrays.hashCode(this.x, 0, 3);
    }
}

