/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECConstants;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECCurve;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECLookupTable;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECMultiplier;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECPoint;
import org.cloudfoundry.security.org.bouncycastle.math.ec.WTauNafMultiplier;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecT163FieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecT163K1Point;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat192;
import org.cloudfoundry.security.org.bouncycastle.util.encoders.Hex;

public class SecT163K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT163K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT163K1_AFFINE_ZS = new ECFieldElement[]{new SecT163FieldElement(ECConstants.ONE)};
    protected SecT163K1Point infinity = new SecT163K1Point((ECCurve)this, null, null);

    public SecT163K1Curve() {
        super(163, 3, 6, 7);
        this.b = this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decodeStrict("04000000000000000000020108A2E0CC0D99F8A5EF"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT163K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 163;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT163FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT163K1Point((ECCurve)this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT163K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 163;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 3;
    }

    public int getK2() {
        return 6;
    }

    public int getK3() {
        return 7;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        long[] lArray = new long[n2 * 3 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat192.copy64((long[])((SecT163FieldElement)eCPoint.getRawXCoord()).x, (int)0, (long[])lArray, (int)n3);
            Nat192.copy64((long[])((SecT163FieldElement)eCPoint.getRawYCoord()).x, (int)0, (long[])lArray, (int)(n3 += 3));
            n3 += 3;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ ECFieldElement[] access$000() {
        return SECT163K1_AFFINE_ZS;
    }
}

