/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.cloudfoundry.security.org.bouncycastle.math.ec.ECFieldElement;
import org.cloudfoundry.security.org.bouncycastle.math.ec.custom.sec.SecT193Field;
import org.cloudfoundry.security.org.bouncycastle.math.raw.Nat256;
import org.cloudfoundry.security.org.bouncycastle.util.Arrays;

public class SecT193FieldElement
extends ECFieldElement.AbstractF2m {
    protected long[] x;

    public SecT193FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > 193) {
            throw new IllegalArgumentException("x value invalid for SecT193FieldElement");
        }
        this.x = SecT193Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecT193FieldElement() {
        this.x = Nat256.create64();
    }

    protected SecT193FieldElement(long[] lArray) {
        this.x = lArray;
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne64((long[])this.x);
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero64((long[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return (this.x[0] & 1L) != 0L;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger64((long[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecT193Field";
    }

    @Override
    public int getFieldSize() {
        return 193;
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        long[] lArray = Nat256.create64();
        SecT193Field.add((long[])this.x, (long[])((SecT193FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement addOne() {
        long[] lArray = Nat256.create64();
        SecT193Field.addOne((long[])this.x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        long[] lArray = Nat256.create64();
        SecT193Field.multiply((long[])this.x, (long[])((SecT193FieldElement)eCFieldElement).x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
    }

    @Override
    public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT193FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT193FieldElement)eCFieldElement2).x;
        long[] lArray4 = ((SecT193FieldElement)eCFieldElement3).x;
        long[] lArray5 = Nat256.createExt64();
        SecT193Field.multiplyAddToExt((long[])lArray, (long[])lArray2, (long[])lArray5);
        SecT193Field.multiplyAddToExt((long[])lArray3, (long[])lArray4, (long[])lArray5);
        long[] lArray6 = Nat256.create64();
        SecT193Field.reduce((long[])lArray5, (long[])lArray6);
        return new SecT193FieldElement(lArray6);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        return this.multiply(eCFieldElement.invert());
    }

    @Override
    public ECFieldElement negate() {
        return this;
    }

    @Override
    public ECFieldElement square() {
        long[] lArray = Nat256.create64();
        SecT193Field.square((long[])this.x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        long[] lArray = this.x;
        long[] lArray2 = ((SecT193FieldElement)eCFieldElement).x;
        long[] lArray3 = ((SecT193FieldElement)eCFieldElement2).x;
        long[] lArray4 = Nat256.createExt64();
        SecT193Field.squareAddToExt((long[])lArray, (long[])lArray4);
        SecT193Field.multiplyAddToExt((long[])lArray2, (long[])lArray3, (long[])lArray4);
        long[] lArray5 = Nat256.create64();
        SecT193Field.reduce((long[])lArray4, (long[])lArray5);
        return new SecT193FieldElement(lArray5);
    }

    @Override
    public ECFieldElement squarePow(int n) {
        if (n < 1) {
            return this;
        }
        long[] lArray = Nat256.create64();
        SecT193Field.squareN((long[])this.x, (int)n, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement halfTrace() {
        long[] lArray = Nat256.create64();
        SecT193Field.halfTrace((long[])this.x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public boolean hasFastTrace() {
        return true;
    }

    @Override
    public int trace() {
        return SecT193Field.trace((long[])this.x);
    }

    @Override
    public ECFieldElement invert() {
        long[] lArray = Nat256.create64();
        SecT193Field.invert((long[])this.x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    @Override
    public ECFieldElement sqrt() {
        long[] lArray = Nat256.create64();
        SecT193Field.sqrt((long[])this.x, (long[])lArray);
        return new SecT193FieldElement(lArray);
    }

    public int getRepresentation() {
        return 2;
    }

    public int getM() {
        return 193;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecT193FieldElement)) {
            return false;
        }
        SecT193FieldElement secT193FieldElement = (SecT193FieldElement)object;
        return Nat256.eq64((long[])this.x, (long[])secT193FieldElement.x);
    }

    public int hashCode() {
        return 0x1D731F ^ Arrays.hashCode(this.x, 0, 4);
    }
}

