package org.cloudgraph.test.datatypes;


import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.jena.ext.com.google.common.primitives.UnsignedInteger;
import org.apache.jena.ext.com.google.common.primitives.UnsignedLong;
import org.cloudgraph.test.datatypes.Concurrent;
import org.cloudgraph.test.datatypes.Node;

/**
 * A test entity which contains every SDO 2.1 datatype.
 * <p></p>
 * Generated interface representing the domain model entity <b>Node</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/datatypes</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>B</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.datatypes.Concurrent Concurrent
 * @see org.cloudgraph.test.datatypes.Node Node
 */
public interface Node extends Concurrent
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/datatypes";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_NODE = "Node";
	
	
	
	/**
	 * The parent node(s)
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>parent</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.P</b>.
	 */
	public static final String PARENT = "parent";
	
	/**
	 * The child node(s)
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>child</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.C</b>.
	 */
	public static final String CHILD = "child";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>name</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.A</b>.
	 */
	public static final String NAME = "name";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>booleanField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.B</b>.
	 */
	public static final String BOOLEAN_FIELD = "booleanField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>bytesField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.C2</b>.
	 */
	public static final String BYTES_FIELD = "bytesField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>characterField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.D</b>.
	 */
	public static final String CHARACTER_FIELD = "characterField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>dateField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.E</b>.
	 */
	public static final String DATE_FIELD = "dateField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>dateTimeField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.F</b>.
	 */
	public static final String DATE_TIME_FIELD = "dateTimeField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>dayField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.G</b>.
	 */
	public static final String DAY_FIELD = "dayField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>decimalField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.H</b>.
	 */
	public static final String DECIMAL_FIELD = "decimalField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>doubleField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.I</b>.
	 */
	public static final String DOUBLE_FIELD = "doubleField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>durationField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.J</b>.
	 */
	public static final String DURATION_FIELD = "durationField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>floatField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.K</b>.
	 */
	public static final String FLOAT_FIELD = "floatField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>intField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.L</b>.
	 */
	public static final String INT_FIELD = "intField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>integerField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.M</b>.
	 */
	public static final String INTEGER_FIELD = "integerField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>unsignedIntField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.N</b>.
	 */
	public static final String UNSIGNED_INT_FIELD = "unsignedIntField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>longField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.O</b>.
	 */
	public static final String LONG_FIELD = "longField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>unsignedLongField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.P2</b>.
	 */
	public static final String UNSIGNED_LONG_FIELD = "unsignedLongField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>monthField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.Q</b>.
	 */
	public static final String MONTH_FIELD = "monthField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>monthDayField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.R</b>.
	 */
	public static final String MONTH_DAY_FIELD = "monthDayField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>objectField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.S</b>.
	 */
	public static final String OBJECT_FIELD = "objectField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>shortField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.T</b>.
	 */
	public static final String SHORT_FIELD = "shortField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>stringField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.U</b>.
	 */
	public static final String STRING_FIELD = "stringField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>stringsField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.V</b>.
	 */
	public static final String STRINGS_FIELD = "stringsField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>timeField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.W</b>.
	 */
	public static final String TIME_FIELD = "timeField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>uriField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.X</b>.
	 */
	public static final String URI_FIELD = "uriField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>YearField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.YF</b>.
	 */
	public static final String YEAR_FIELD = "YearField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>yearMonthField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.Z</b>.
	 */
	public static final String YEAR_MONTH_FIELD = "yearMonthField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>yearMonthDayField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.A1</b>.
	 */
	public static final String YEAR_MONTH_DAY_FIELD = "yearMonthDayField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>byteField</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.B1</b>.
	 */
	public static final String BYTE_FIELD = "byteField";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>rootId</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.C1</b>.
	 */
	public static final String ROOT_ID = "rootId";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>id</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.D1</b>.
	 */
	public static final String ID = "id";
	



	/**
	 * Returns true if the <b>parent</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getParent() getParent} or {@link #setParent(Node value) setParent(...)} for a definition of property <b>parent</b>
	 * @return true if the <b>parent</b> property is set.
	 */
	public boolean isSetParent();

	/**
	 * Unsets the <b>parent</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getParent() getParent} or {@link #setParent(Node value) setParent(...)} for a definition of property <b>parent</b>
	 */
	public void unsetParent();

	/**
	 * Creates and returns a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>parent</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getParent() getParent} or {@link #setParent(Node value) setParent(...)} for a definition of property <b>parent</b>
	 * @return a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property <b>parent</b>.
	 */
	public Node createParent();

	/**
	 * Returns the value of the <b>parent</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The parent node(s)
	 * @return the value of the <b>parent</b> property.
	 */
	public Node getParent();

	/**
	 * Sets the value of the <b>parent</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The parent node(s)
	 */
	public void setParent(Node value);


	/**
	 * Returns true if the <b>child</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @return true if the <b>child</b> property is set.
	 */
	public boolean isSetChild();

	/**
	 * Unsets the <b>child</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 */
	public void unsetChild();

	/**
	 * Creates and returns a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @return a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property <b>child</b>.
	 */
	public Node createChild();

	/**
	 * Returns an array of <b>Node</b> set for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The child node(s)
	 * @return an array of <b>Node</b> set for the object's multi-valued property <b>child</b>.
	 */
	public Node[] getChild();

	/**
	 * Returns the <b>Node</b> set for the object's multi-valued property <b>child</b> based on the given index.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @param idx the index
	 * @return the <b>Node</b> set for the object's multi-valued property <b>child</b> based on the given index.
	 */
	public Node getChild(int idx);

	/**
	 * Returns a count for multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @return a count for multi-valued property <b>child</b>.
	 */
	public int getChildCount();

	/**
	 * Sets the given array of Type <b>Node</b> for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The child node(s)
	 * @param value the array value
	 */
	public void setChild(Node[] value);

	/**
	 * Adds the given value of Type <b>Node</b> for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @param value the value to add
	 */
	public void addChild(Node value);

	/**
	 * Removes the given value of Type <b>Node</b> for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @param value the value to remove
	 */
	public void removeChild(Node value);


	/**
	 * Returns true if the <b>name</b> property is set.
	 * @return true if the <b>name</b> property is set.
	 */
	public boolean isSetName();

	/**
	 * Unsets the <b>name</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetName();

	/**
	 * Returns the value of the <b>name</b> property.
	 * @return the value of the <b>name</b> property.
	 */
	public String getName();

	/**
	 * Sets the value of the <b>name</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 60</pre>
	 */
	public void setName(String value);


	/**
	 * Returns true if the <b>booleanField</b> property is set.
	 * @return true if the <b>booleanField</b> property is set.
	 */
	public boolean isSetBooleanField();

	/**
	 * Unsets the <b>booleanField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetBooleanField();

	/**
	 * Returns the value of the <b>booleanField</b> property.
	 * @return the value of the <b>booleanField</b> property.
	 */
	public boolean getBooleanField();

	/**
	 * Sets the value of the <b>booleanField</b> property to the given value.
	 */
	public void setBooleanField(boolean value);


	/**
	 * Returns true if the <b>bytesField</b> property is set.
	 * @return true if the <b>bytesField</b> property is set.
	 */
	public boolean isSetBytesField();

	/**
	 * Unsets the <b>bytesField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetBytesField();

	/**
	 * Returns the value of the <b>bytesField</b> property.
	 * @return the value of the <b>bytesField</b> property.
	 */
	public byte[] getBytesField();

	/**
	 * Sets the value of the <b>bytesField</b> property to the given value.
	 */
	public void setBytesField(byte[] value);


	/**
	 * Returns true if the <b>characterField</b> property is set.
	 * @return true if the <b>characterField</b> property is set.
	 */
	public boolean isSetCharacterField();

	/**
	 * Unsets the <b>characterField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCharacterField();

	/**
	 * Returns the value of the <b>characterField</b> property.
	 * @return the value of the <b>characterField</b> property.
	 */
	public char getCharacterField();

	/**
	 * Sets the value of the <b>characterField</b> property to the given value.
	 */
	public void setCharacterField(char value);


	/**
	 * Returns true if the <b>dateField</b> property is set.
	 * @return true if the <b>dateField</b> property is set.
	 */
	public boolean isSetDateField();

	/**
	 * Unsets the <b>dateField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDateField();

	/**
	 * Returns the value of the <b>dateField</b> property.
	 * @return the value of the <b>dateField</b> property.
	 */
	public Date getDateField();

	/**
	 * Sets the value of the <b>dateField</b> property to the given value.
	 */
	public void setDateField(Date value);


	/**
	 * Returns true if the <b>dateTimeField</b> property is set.
	 * @return true if the <b>dateTimeField</b> property is set.
	 */
	public boolean isSetDateTimeField();

	/**
	 * Unsets the <b>dateTimeField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDateTimeField();

	/**
	 * Returns the value of the <b>dateTimeField</b> property.
	 * @return the value of the <b>dateTimeField</b> property.
	 */
	public String getDateTimeField();

	/**
	 * Sets the value of the <b>dateTimeField</b> property to the given value.
	 */
	public void setDateTimeField(String value);


	/**
	 * Returns true if the <b>dayField</b> property is set.
	 * @return true if the <b>dayField</b> property is set.
	 */
	public boolean isSetDayField();

	/**
	 * Unsets the <b>dayField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDayField();

	/**
	 * Returns the value of the <b>dayField</b> property.
	 * @return the value of the <b>dayField</b> property.
	 */
	public String getDayField();

	/**
	 * Sets the value of the <b>dayField</b> property to the given value.
	 */
	public void setDayField(String value);


	/**
	 * Returns true if the <b>decimalField</b> property is set.
	 * @return true if the <b>decimalField</b> property is set.
	 */
	public boolean isSetDecimalField();

	/**
	 * Unsets the <b>decimalField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDecimalField();

	/**
	 * Returns the value of the <b>decimalField</b> property.
	 * @return the value of the <b>decimalField</b> property.
	 */
	public BigDecimal getDecimalField();

	/**
	 * Sets the value of the <b>decimalField</b> property to the given value.
	 */
	public void setDecimalField(BigDecimal value);


	/**
	 * Returns true if the <b>doubleField</b> property is set.
	 * @return true if the <b>doubleField</b> property is set.
	 */
	public boolean isSetDoubleField();

	/**
	 * Unsets the <b>doubleField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDoubleField();

	/**
	 * Returns the value of the <b>doubleField</b> property.
	 * @return the value of the <b>doubleField</b> property.
	 */
	public double getDoubleField();

	/**
	 * Sets the value of the <b>doubleField</b> property to the given value.
	 */
	public void setDoubleField(double value);


	/**
	 * Returns true if the <b>durationField</b> property is set.
	 * @return true if the <b>durationField</b> property is set.
	 */
	public boolean isSetDurationField();

	/**
	 * Unsets the <b>durationField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDurationField();

	/**
	 * Returns the value of the <b>durationField</b> property.
	 * @return the value of the <b>durationField</b> property.
	 */
	public String getDurationField();

	/**
	 * Sets the value of the <b>durationField</b> property to the given value.
	 */
	public void setDurationField(String value);


	/**
	 * Returns true if the <b>floatField</b> property is set.
	 * @return true if the <b>floatField</b> property is set.
	 */
	public boolean isSetFloatField();

	/**
	 * Unsets the <b>floatField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetFloatField();

	/**
	 * Returns the value of the <b>floatField</b> property.
	 * @return the value of the <b>floatField</b> property.
	 */
	public float getFloatField();

	/**
	 * Sets the value of the <b>floatField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     fractionDigits: 11</pre>
	 */
	public void setFloatField(float value);


	/**
	 * Returns true if the <b>intField</b> property is set.
	 * @return true if the <b>intField</b> property is set.
	 */
	public boolean isSetIntField();

	/**
	 * Unsets the <b>intField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetIntField();

	/**
	 * Returns the value of the <b>intField</b> property.
	 * @return the value of the <b>intField</b> property.
	 */
	public int getIntField();

	/**
	 * Sets the value of the <b>intField</b> property to the given value.
	 */
	public void setIntField(int value);


	/**
	 * Returns true if the <b>integerField</b> property is set.
	 * @return true if the <b>integerField</b> property is set.
	 */
	public boolean isSetIntegerField();

	/**
	 * Unsets the <b>integerField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetIntegerField();

	/**
	 * Returns the value of the <b>integerField</b> property.
	 * @return the value of the <b>integerField</b> property.
	 */
	public BigInteger getIntegerField();

	/**
	 * Sets the value of the <b>integerField</b> property to the given value.
	 */
	public void setIntegerField(BigInteger value);


	/**
	 * Returns true if the <b>unsignedIntField</b> property is set.
	 * @return true if the <b>unsignedIntField</b> property is set.
	 */
	public boolean isSetUnsignedIntField();

	/**
	 * Unsets the <b>unsignedIntField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetUnsignedIntField();

	/**
	 * Returns the value of the <b>unsignedIntField</b> property.
	 * @return the value of the <b>unsignedIntField</b> property.
	 */
	public UnsignedInteger getUnsignedIntField();

	/**
	 * Sets the value of the <b>unsignedIntField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre></pre>
	 */
	public void setUnsignedIntField(UnsignedInteger value);


	/**
	 * Returns true if the <b>longField</b> property is set.
	 * @return true if the <b>longField</b> property is set.
	 */
	public boolean isSetLongField();

	/**
	 * Unsets the <b>longField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetLongField();

	/**
	 * Returns the value of the <b>longField</b> property.
	 * @return the value of the <b>longField</b> property.
	 */
	public long getLongField();

	/**
	 * Sets the value of the <b>longField</b> property to the given value.
	 */
	public void setLongField(long value);


	/**
	 * Returns true if the <b>unsignedLongField</b> property is set.
	 * @return true if the <b>unsignedLongField</b> property is set.
	 */
	public boolean isSetUnsignedLongField();

	/**
	 * Unsets the <b>unsignedLongField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetUnsignedLongField();

	/**
	 * Returns the value of the <b>unsignedLongField</b> property.
	 * @return the value of the <b>unsignedLongField</b> property.
	 */
	public UnsignedLong getUnsignedLongField();

	/**
	 * Sets the value of the <b>unsignedLongField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre></pre>
	 */
	public void setUnsignedLongField(UnsignedLong value);


	/**
	 * Returns true if the <b>monthField</b> property is set.
	 * @return true if the <b>monthField</b> property is set.
	 */
	public boolean isSetMonthField();

	/**
	 * Unsets the <b>monthField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetMonthField();

	/**
	 * Returns the value of the <b>monthField</b> property.
	 * @return the value of the <b>monthField</b> property.
	 */
	public String getMonthField();

	/**
	 * Sets the value of the <b>monthField</b> property to the given value.
	 */
	public void setMonthField(String value);


	/**
	 * Returns true if the <b>monthDayField</b> property is set.
	 * @return true if the <b>monthDayField</b> property is set.
	 */
	public boolean isSetMonthDayField();

	/**
	 * Unsets the <b>monthDayField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetMonthDayField();

	/**
	 * Returns the value of the <b>monthDayField</b> property.
	 * @return the value of the <b>monthDayField</b> property.
	 */
	public String getMonthDayField();

	/**
	 * Sets the value of the <b>monthDayField</b> property to the given value.
	 */
	public void setMonthDayField(String value);


	/**
	 * Returns true if the <b>objectField</b> property is set.
	 * @return true if the <b>objectField</b> property is set.
	 */
	public boolean isSetObjectField();

	/**
	 * Unsets the <b>objectField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetObjectField();

	/**
	 * Returns the value of the <b>objectField</b> property.
	 * @return the value of the <b>objectField</b> property.
	 */
	public Object getObjectField();

	/**
	 * Sets the value of the <b>objectField</b> property to the given value.
	 */
	public void setObjectField(Object value);


	/**
	 * Returns true if the <b>shortField</b> property is set.
	 * @return true if the <b>shortField</b> property is set.
	 */
	public boolean isSetShortField();

	/**
	 * Unsets the <b>shortField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetShortField();

	/**
	 * Returns the value of the <b>shortField</b> property.
	 * @return the value of the <b>shortField</b> property.
	 */
	public short getShortField();

	/**
	 * Sets the value of the <b>shortField</b> property to the given value.
	 */
	public void setShortField(short value);


	/**
	 * Returns true if the <b>stringField</b> property is set.
	 * @return true if the <b>stringField</b> property is set.
	 */
	public boolean isSetStringField();

	/**
	 * Unsets the <b>stringField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetStringField();

	/**
	 * Returns the value of the <b>stringField</b> property.
	 * @return the value of the <b>stringField</b> property.
	 */
	public String getStringField();

	/**
	 * Sets the value of the <b>stringField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 20</pre>
	 */
	public void setStringField(String value);


	/**
	 * Returns true if the <b>stringsField</b> property is set.
	 * @return true if the <b>stringsField</b> property is set.
	 */
	public boolean isSetStringsField();

	/**
	 * Unsets the <b>stringsField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetStringsField();

	/**
	 * Returns the value of the <b>stringsField</b> property.
	 * @return the value of the <b>stringsField</b> property.
	 */
	public List getStringsField();

	/**
	 * Sets the value of the <b>stringsField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 30</pre>
	 */
	public void setStringsField(List value);


	/**
	 * Returns true if the <b>timeField</b> property is set.
	 * @return true if the <b>timeField</b> property is set.
	 */
	public boolean isSetTimeField();

	/**
	 * Unsets the <b>timeField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetTimeField();

	/**
	 * Returns the value of the <b>timeField</b> property.
	 * @return the value of the <b>timeField</b> property.
	 */
	public String getTimeField();

	/**
	 * Sets the value of the <b>timeField</b> property to the given value.
	 */
	public void setTimeField(String value);


	/**
	 * Returns true if the <b>uriField</b> property is set.
	 * @return true if the <b>uriField</b> property is set.
	 */
	public boolean isSetUriField();

	/**
	 * Unsets the <b>uriField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetUriField();

	/**
	 * Returns the value of the <b>uriField</b> property.
	 * @return the value of the <b>uriField</b> property.
	 */
	public String getUriField();

	/**
	 * Sets the value of the <b>uriField</b> property to the given value.
	 */
	public void setUriField(String value);


	/**
	 * Returns true if the <b>YearField</b> property is set.
	 * @return true if the <b>YearField</b> property is set.
	 */
	public boolean isSetYearField();

	/**
	 * Unsets the <b>YearField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetYearField();

	/**
	 * Returns the value of the <b>YearField</b> property.
	 * @return the value of the <b>YearField</b> property.
	 */
	public String getYearField();

	/**
	 * Sets the value of the <b>YearField</b> property to the given value.
	 */
	public void setYearField(String value);


	/**
	 * Returns true if the <b>yearMonthField</b> property is set.
	 * @return true if the <b>yearMonthField</b> property is set.
	 */
	public boolean isSetYearMonthField();

	/**
	 * Unsets the <b>yearMonthField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetYearMonthField();

	/**
	 * Returns the value of the <b>yearMonthField</b> property.
	 * @return the value of the <b>yearMonthField</b> property.
	 */
	public String getYearMonthField();

	/**
	 * Sets the value of the <b>yearMonthField</b> property to the given value.
	 */
	public void setYearMonthField(String value);


	/**
	 * Returns true if the <b>yearMonthDayField</b> property is set.
	 * @return true if the <b>yearMonthDayField</b> property is set.
	 */
	public boolean isSetYearMonthDayField();

	/**
	 * Unsets the <b>yearMonthDayField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetYearMonthDayField();

	/**
	 * Returns the value of the <b>yearMonthDayField</b> property.
	 * @return the value of the <b>yearMonthDayField</b> property.
	 */
	public String getYearMonthDayField();

	/**
	 * Sets the value of the <b>yearMonthDayField</b> property to the given value.
	 */
	public void setYearMonthDayField(String value);


	/**
	 * Returns true if the <b>byteField</b> property is set.
	 * @return true if the <b>byteField</b> property is set.
	 */
	public boolean isSetByteField();

	/**
	 * Unsets the <b>byteField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetByteField();

	/**
	 * Returns the value of the <b>byteField</b> property.
	 * @return the value of the <b>byteField</b> property.
	 */
	public byte getByteField();

	/**
	 * Sets the value of the <b>byteField</b> property to the given value.
	 */
	public void setByteField(byte value);


	/**
	 * Returns true if the <b>rootId</b> property is set.
	 * @return true if the <b>rootId</b> property is set.
	 */
	public boolean isSetRootId();

	/**
	 * Unsets the <b>rootId</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetRootId();

	/**
	 * Returns the value of the <b>rootId</b> property.
	 * @return the value of the <b>rootId</b> property.
	 */
	public int getRootId();

	/**
	 * Sets the value of the <b>rootId</b> property to the given value.
	 */
	public void setRootId(int value);


	/**
	 * Returns true if the <b>id</b> property is set.
	 * @return true if the <b>id</b> property is set.
	 */
	public boolean isSetId();

	/**
	 * Unsets the <b>id</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetId();

	/**
	 * Returns the value of the <b>id</b> property.
	 * @return the value of the <b>id</b> property.
	 */
	public String getId();

	/**
	 * Sets the value of the <b>id</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 36</pre>
	 */
	public void setId(String value);
}