package org.cloudgraph.test.datatypes.impl;

import java.io.Serializable;
import org.plasma.sdo.core.CoreDataObject;
import java.util.List;
import java.util.ArrayList;
import java.lang.Object;
import java.lang.String;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.jena.ext.com.google.common.primitives.UnsignedInteger;
import org.apache.jena.ext.com.google.common.primitives.UnsignedLong;
import org.cloudgraph.test.datatypes.Concurrent;
import org.cloudgraph.test.datatypes.LongNode;
import org.cloudgraph.test.datatypes.Node;

/**
 * Generated implementation class representing the domain model entity <b>LongNode</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>L</b>.
 * <p></p>
 *
 */
public class LongNodeSDO extends CoreDataObject implements Serializable, LongNode
{
	private static final long serialVersionUID = 1L;
	/** The SDO namespace URI associated with the SDO Type for this class */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/datatypes";

	/**
	 * Default No-arg constructor required for serialization operations. This method
	 * is NOT intended to be used within application source code.
	 */
	public LongNodeSDO() {
		super();
	}
	public LongNodeSDO(commonj.sdo.Type type) {
		super(type);
	}


	/**
	 * Returns true if the <b>YearField</b> property is set.
	 * @return true if the <b>YearField</b> property is set.
	 */
	public boolean isSetYearField(){
		return super.isSet(Node.YEAR_FIELD);
	}

	/**
	 * Unsets the <b>YearField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetYearField(){
		super.unset(Node.YEAR_FIELD);
	}

	/**
	 * Returns the value of the <b>YearField</b> property.
	 * @return the value of the <b>YearField</b> property.
	 */
	public String getYearField(){
		return (String)super.get(Node.YEAR_FIELD);
	}

	/**
	 * Sets the value of the <b>YearField</b> property to the given value.
	 */
	public void setYearField(String value){
		super.set(Node.YEAR_FIELD, value);
	}


	/**
	 * Returns true if the <b>booleanField</b> property is set.
	 * @return true if the <b>booleanField</b> property is set.
	 */
	public boolean isSetBooleanField(){
		return super.isSet(Node.BOOLEAN_FIELD);
	}

	/**
	 * Unsets the <b>booleanField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetBooleanField(){
		super.unset(Node.BOOLEAN_FIELD);
	}

	/**
	 * Returns the value of the <b>booleanField</b> property.
	 * @return the value of the <b>booleanField</b> property.
	 */
	public boolean getBooleanField(){
		Boolean result = (Boolean)super.get(Node.BOOLEAN_FIELD);
		if (result != null)
			return result.booleanValue();
		else return false;
	}

	/**
	 * Sets the value of the <b>booleanField</b> property to the given value.
	 */
	public void setBooleanField(boolean value){
		super.set(Node.BOOLEAN_FIELD, value);
	}


	/**
	 * Returns true if the <b>byteField</b> property is set.
	 * @return true if the <b>byteField</b> property is set.
	 */
	public boolean isSetByteField(){
		return super.isSet(Node.BYTE_FIELD);
	}

	/**
	 * Unsets the <b>byteField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetByteField(){
		super.unset(Node.BYTE_FIELD);
	}

	/**
	 * Returns the value of the <b>byteField</b> property.
	 * @return the value of the <b>byteField</b> property.
	 */
	public byte getByteField(){
		Byte result = (Byte)super.get(Node.BYTE_FIELD);
		if (result != null)
			return result.byteValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>byteField</b> property to the given value.
	 */
	public void setByteField(byte value){
		super.set(Node.BYTE_FIELD, value);
	}


	/**
	 * Returns true if the <b>bytesField</b> property is set.
	 * @return true if the <b>bytesField</b> property is set.
	 */
	public boolean isSetBytesField(){
		return super.isSet(Node.BYTES_FIELD);
	}

	/**
	 * Unsets the <b>bytesField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetBytesField(){
		super.unset(Node.BYTES_FIELD);
	}

	/**
	 * Returns the value of the <b>bytesField</b> property.
	 * @return the value of the <b>bytesField</b> property.
	 */
	public byte[] getBytesField(){
		return (byte[])super.get(Node.BYTES_FIELD);
	}

	/**
	 * Sets the value of the <b>bytesField</b> property to the given value.
	 */
	public void setBytesField(byte[] value){
		super.set(Node.BYTES_FIELD, value);
	}


	/**
	 * Returns true if the <b>characterField</b> property is set.
	 * @return true if the <b>characterField</b> property is set.
	 */
	public boolean isSetCharacterField(){
		return super.isSet(Node.CHARACTER_FIELD);
	}

	/**
	 * Unsets the <b>characterField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCharacterField(){
		super.unset(Node.CHARACTER_FIELD);
	}

	/**
	 * Returns the value of the <b>characterField</b> property.
	 * @return the value of the <b>characterField</b> property.
	 */
	public char getCharacterField(){
		Character result = (Character)super.get(Node.CHARACTER_FIELD);
		if (result != null)
			return result.charValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>characterField</b> property to the given value.
	 */
	public void setCharacterField(char value){
		super.set(Node.CHARACTER_FIELD, value);
	}


	/**
	 * Returns true if the <b>child</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @return true if the <b>child</b> property is set.
	 */
	public boolean isSetChild(){
		return super.isSet(Node.CHILD);
	}

	/**
	 * Unsets the <b>child</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 */
	public void unsetChild(){
		super.unset(Node.CHILD);
	}

	/**
	 * Creates and returns a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @return a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property <b>child</b>.
	 */
	public Node createChild(){
		return (Node)super.createDataObject(Node.CHILD);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Node</b> set for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The child node(s)
	 * @return an array of <b>Node</b> set for the object's multi-valued property <b>child</b>.
	 */
	public Node[] getChild(){
		List<Node> list = (List<Node>)super.get(Node.CHILD);
		if (list != null) {
			Node[] array = new Node[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Node[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Node</b> set for the object's multi-valued property <b>child</b> based on the given index.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @param idx the index
	 * @return the <b>Node</b> set for the object's multi-valued property <b>child</b> based on the given index.
	 */
	public Node getChild(int idx){
		List<Node> list = (List<Node>)super.get(Node.CHILD);
		if (list != null) {
			return (Node)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @return a count for multi-valued property <b>child</b>.
	 */
	public int getChildCount(){
		List<Node> list = (List<Node>)super.get(Node.CHILD);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Node</b> for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The child node(s)
	 * @param value the array value
	 */
	public void setChild(Node[] value){
		List<Node> list = (List<Node>)super.get(Node.CHILD);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Node>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Node.CHILD, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetChild() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Node</b> for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @param value the value to add
	 */
	public void addChild(Node value){
		List<Node> list = (List<Node>)super.get(Node.CHILD);
		if (list == null)
			list = new ArrayList<Node>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.CHILD, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Node</b> for the object's multi-valued property <b>child</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getChild() getChild} or {@link #setChild(Node[] value) setChild(...)} for a definition of property <b>child</b>
	 * @param value the value to remove
	 */
	public void removeChild(Node value){
		List<Node> list = (List<Node>)super.get(Node.CHILD);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.CHILD, list);
	}


	/**
	 * Returns true if the <b>createdBy</b> property is set.
	 * @return true if the <b>createdBy</b> property is set.
	 */
	public boolean isSetCreatedBy(){
		return super.isSet(Concurrent.CREATED_BY);
	}

	/**
	 * Unsets the <b>createdBy</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCreatedBy(){
		super.unset(Concurrent.CREATED_BY);
	}

	/**
	 * Returns the value of the <b>createdBy</b> property.
	 * @return the value of the <b>createdBy</b> property.
	 */
	public String getCreatedBy(){
		return (String)super.get(Concurrent.CREATED_BY);
	}

	/**
	 * Sets the value of the <b>createdBy</b> property to the given value.
	 */
	public void setCreatedBy(String value){
		super.set(Concurrent.CREATED_BY, value);
	}


	/**
	 * Returns true if the <b>createdOn</b> property is set.
	 * @return true if the <b>createdOn</b> property is set.
	 */
	public boolean isSetCreatedOn(){
		return super.isSet(Concurrent.CREATED_ON);
	}

	/**
	 * Unsets the <b>createdOn</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCreatedOn(){
		super.unset(Concurrent.CREATED_ON);
	}

	/**
	 * Returns the value of the <b>createdOn</b> property.
	 * @return the value of the <b>createdOn</b> property.
	 */
	public String getCreatedOn(){
		return (String)super.get(Concurrent.CREATED_ON);
	}

	/**
	 * Sets the value of the <b>createdOn</b> property to the given value.
	 */
	public void setCreatedOn(String value){
		super.set(Concurrent.CREATED_ON, value);
	}


	/**
	 * Returns true if the <b>dateField</b> property is set.
	 * @return true if the <b>dateField</b> property is set.
	 */
	public boolean isSetDateField(){
		return super.isSet(Node.DATE_FIELD);
	}

	/**
	 * Unsets the <b>dateField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDateField(){
		super.unset(Node.DATE_FIELD);
	}

	/**
	 * Returns the value of the <b>dateField</b> property.
	 * @return the value of the <b>dateField</b> property.
	 */
	public Date getDateField(){
		return (Date)super.get(Node.DATE_FIELD);
	}

	/**
	 * Sets the value of the <b>dateField</b> property to the given value.
	 */
	public void setDateField(Date value){
		super.set(Node.DATE_FIELD, value);
	}


	/**
	 * Returns true if the <b>dateTimeField</b> property is set.
	 * @return true if the <b>dateTimeField</b> property is set.
	 */
	public boolean isSetDateTimeField(){
		return super.isSet(Node.DATE_TIME_FIELD);
	}

	/**
	 * Unsets the <b>dateTimeField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDateTimeField(){
		super.unset(Node.DATE_TIME_FIELD);
	}

	/**
	 * Returns the value of the <b>dateTimeField</b> property.
	 * @return the value of the <b>dateTimeField</b> property.
	 */
	public String getDateTimeField(){
		return (String)super.get(Node.DATE_TIME_FIELD);
	}

	/**
	 * Sets the value of the <b>dateTimeField</b> property to the given value.
	 */
	public void setDateTimeField(String value){
		super.set(Node.DATE_TIME_FIELD, value);
	}


	/**
	 * Returns true if the <b>dayField</b> property is set.
	 * @return true if the <b>dayField</b> property is set.
	 */
	public boolean isSetDayField(){
		return super.isSet(Node.DAY_FIELD);
	}

	/**
	 * Unsets the <b>dayField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDayField(){
		super.unset(Node.DAY_FIELD);
	}

	/**
	 * Returns the value of the <b>dayField</b> property.
	 * @return the value of the <b>dayField</b> property.
	 */
	public String getDayField(){
		return (String)super.get(Node.DAY_FIELD);
	}

	/**
	 * Sets the value of the <b>dayField</b> property to the given value.
	 */
	public void setDayField(String value){
		super.set(Node.DAY_FIELD, value);
	}


	/**
	 * Returns true if the <b>decimalField</b> property is set.
	 * @return true if the <b>decimalField</b> property is set.
	 */
	public boolean isSetDecimalField(){
		return super.isSet(Node.DECIMAL_FIELD);
	}

	/**
	 * Unsets the <b>decimalField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDecimalField(){
		super.unset(Node.DECIMAL_FIELD);
	}

	/**
	 * Returns the value of the <b>decimalField</b> property.
	 * @return the value of the <b>decimalField</b> property.
	 */
	public BigDecimal getDecimalField(){
		return (BigDecimal)super.get(Node.DECIMAL_FIELD);
	}

	/**
	 * Sets the value of the <b>decimalField</b> property to the given value.
	 */
	public void setDecimalField(BigDecimal value){
		super.set(Node.DECIMAL_FIELD, value);
	}


	/**
	 * Returns true if the <b>doubleField</b> property is set.
	 * @return true if the <b>doubleField</b> property is set.
	 */
	public boolean isSetDoubleField(){
		return super.isSet(Node.DOUBLE_FIELD);
	}

	/**
	 * Unsets the <b>doubleField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDoubleField(){
		super.unset(Node.DOUBLE_FIELD);
	}

	/**
	 * Returns the value of the <b>doubleField</b> property.
	 * @return the value of the <b>doubleField</b> property.
	 */
	public double getDoubleField(){
		Double result = (Double)super.get(Node.DOUBLE_FIELD);
		if (result != null)
			return result.doubleValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>doubleField</b> property to the given value.
	 */
	public void setDoubleField(double value){
		super.set(Node.DOUBLE_FIELD, value);
	}


	/**
	 * Returns true if the <b>durationField</b> property is set.
	 * @return true if the <b>durationField</b> property is set.
	 */
	public boolean isSetDurationField(){
		return super.isSet(Node.DURATION_FIELD);
	}

	/**
	 * Unsets the <b>durationField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDurationField(){
		super.unset(Node.DURATION_FIELD);
	}

	/**
	 * Returns the value of the <b>durationField</b> property.
	 * @return the value of the <b>durationField</b> property.
	 */
	public String getDurationField(){
		return (String)super.get(Node.DURATION_FIELD);
	}

	/**
	 * Sets the value of the <b>durationField</b> property to the given value.
	 */
	public void setDurationField(String value){
		super.set(Node.DURATION_FIELD, value);
	}


	/**
	 * Returns true if the <b>floatField</b> property is set.
	 * @return true if the <b>floatField</b> property is set.
	 */
	public boolean isSetFloatField(){
		return super.isSet(Node.FLOAT_FIELD);
	}

	/**
	 * Unsets the <b>floatField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetFloatField(){
		super.unset(Node.FLOAT_FIELD);
	}

	/**
	 * Returns the value of the <b>floatField</b> property.
	 * @return the value of the <b>floatField</b> property.
	 */
	public float getFloatField(){
		Float result = (Float)super.get(Node.FLOAT_FIELD);
		if (result != null)
			return result.floatValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>floatField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     fractionDigits: 11</pre>
	 */
	public void setFloatField(float value){
		super.set(Node.FLOAT_FIELD, value);
	}


	/**
	 * Returns true if the <b>id</b> property is set.
	 * @return true if the <b>id</b> property is set.
	 */
	public boolean isSetId(){
		return super.isSet(Node.ID);
	}

	/**
	 * Unsets the <b>id</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetId(){
		super.unset(Node.ID);
	}

	/**
	 * Returns the value of the <b>id</b> property.
	 * @return the value of the <b>id</b> property.
	 */
	public String getId(){
		return (String)super.get(Node.ID);
	}

	/**
	 * Sets the value of the <b>id</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 36</pre>
	 */
	public void setId(String value){
		super.set(Node.ID, value);
	}


	/**
	 * Returns true if the <b>intField</b> property is set.
	 * @return true if the <b>intField</b> property is set.
	 */
	public boolean isSetIntField(){
		return super.isSet(Node.INT_FIELD);
	}

	/**
	 * Unsets the <b>intField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetIntField(){
		super.unset(Node.INT_FIELD);
	}

	/**
	 * Returns the value of the <b>intField</b> property.
	 * @return the value of the <b>intField</b> property.
	 */
	public int getIntField(){
		Integer result = (Integer)super.get(Node.INT_FIELD);
		if (result != null)
			return result.intValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>intField</b> property to the given value.
	 */
	public void setIntField(int value){
		super.set(Node.INT_FIELD, value);
	}


	/**
	 * Returns true if the <b>integerField</b> property is set.
	 * @return true if the <b>integerField</b> property is set.
	 */
	public boolean isSetIntegerField(){
		return super.isSet(Node.INTEGER_FIELD);
	}

	/**
	 * Unsets the <b>integerField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetIntegerField(){
		super.unset(Node.INTEGER_FIELD);
	}

	/**
	 * Returns the value of the <b>integerField</b> property.
	 * @return the value of the <b>integerField</b> property.
	 */
	public BigInteger getIntegerField(){
		return (BigInteger)super.get(Node.INTEGER_FIELD);
	}

	/**
	 * Sets the value of the <b>integerField</b> property to the given value.
	 */
	public void setIntegerField(BigInteger value){
		super.set(Node.INTEGER_FIELD, value);
	}


	/**
	 * Returns true if the <b>lastAccessedOn</b> property is set.
	 * @return true if the <b>lastAccessedOn</b> property is set.
	 */
	public boolean isSetLastAccessedOn(){
		return super.isSet(Concurrent.LAST_ACCESSED_ON);
	}

	/**
	 * Unsets the <b>lastAccessedOn</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetLastAccessedOn(){
		super.unset(Concurrent.LAST_ACCESSED_ON);
	}

	/**
	 * Returns the value of the <b>lastAccessedOn</b> property.
	 * @return the value of the <b>lastAccessedOn</b> property.
	 */
	public String getLastAccessedOn(){
		return (String)super.get(Concurrent.LAST_ACCESSED_ON);
	}

	/**
	 * Sets the value of the <b>lastAccessedOn</b> property to the given value.
	 */
	public void setLastAccessedOn(String value){
		super.set(Concurrent.LAST_ACCESSED_ON, value);
	}


	/**
	 * Returns true if the <b>lastModifiedBy</b> property is set.
	 * @return true if the <b>lastModifiedBy</b> property is set.
	 */
	public boolean isSetLastModifiedBy(){
		return super.isSet(Concurrent.LAST_MODIFIED_BY);
	}

	/**
	 * Unsets the <b>lastModifiedBy</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetLastModifiedBy(){
		super.unset(Concurrent.LAST_MODIFIED_BY);
	}

	/**
	 * Returns the value of the <b>lastModifiedBy</b> property.
	 * @return the value of the <b>lastModifiedBy</b> property.
	 */
	public String getLastModifiedBy(){
		return (String)super.get(Concurrent.LAST_MODIFIED_BY);
	}

	/**
	 * Sets the value of the <b>lastModifiedBy</b> property to the given value.
	 */
	public void setLastModifiedBy(String value){
		super.set(Concurrent.LAST_MODIFIED_BY, value);
	}


	/**
	 * Returns true if the <b>lastModifiedOn</b> property is set.
	 * @return true if the <b>lastModifiedOn</b> property is set.
	 */
	public boolean isSetLastModifiedOn(){
		return super.isSet(Concurrent.LAST_MODIFIED_ON);
	}

	/**
	 * Unsets the <b>lastModifiedOn</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetLastModifiedOn(){
		super.unset(Concurrent.LAST_MODIFIED_ON);
	}

	/**
	 * Returns the value of the <b>lastModifiedOn</b> property.
	 * @return the value of the <b>lastModifiedOn</b> property.
	 */
	public String getLastModifiedOn(){
		return (String)super.get(Concurrent.LAST_MODIFIED_ON);
	}

	/**
	 * Sets the value of the <b>lastModifiedOn</b> property to the given value.
	 */
	public void setLastModifiedOn(String value){
		super.set(Concurrent.LAST_MODIFIED_ON, value);
	}


	/**
	 * Returns true if the <b>levelNum</b> property is set.
	 * @return true if the <b>levelNum</b> property is set.
	 */
	public boolean isSetLevelNum(){
		return super.isSet(Concurrent.LEVEL_NUM);
	}

	/**
	 * Unsets the <b>levelNum</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetLevelNum(){
		super.unset(Concurrent.LEVEL_NUM);
	}

	/**
	 * Returns the value of the <b>levelNum</b> property.
	 * @return the value of the <b>levelNum</b> property.
	 */
	public long getLevelNum(){
		Long result = (Long)super.get(Concurrent.LEVEL_NUM);
		if (result != null)
			return result.longValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>levelNum</b> property to the given value.
	 */
	public void setLevelNum(long value){
		super.set(Concurrent.LEVEL_NUM, value);
	}


	/**
	 * Returns true if the <b>longField</b> property is set.
	 * @return true if the <b>longField</b> property is set.
	 */
	public boolean isSetLongField(){
		return super.isSet(Node.LONG_FIELD);
	}

	/**
	 * Unsets the <b>longField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetLongField(){
		super.unset(Node.LONG_FIELD);
	}

	/**
	 * Returns the value of the <b>longField</b> property.
	 * @return the value of the <b>longField</b> property.
	 */
	public long getLongField(){
		Long result = (Long)super.get(Node.LONG_FIELD);
		if (result != null)
			return result.longValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>longField</b> property to the given value.
	 */
	public void setLongField(long value){
		super.set(Node.LONG_FIELD, value);
	}


	/**
	 * Returns true if the <b>monthDayField</b> property is set.
	 * @return true if the <b>monthDayField</b> property is set.
	 */
	public boolean isSetMonthDayField(){
		return super.isSet(Node.MONTH_DAY_FIELD);
	}

	/**
	 * Unsets the <b>monthDayField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetMonthDayField(){
		super.unset(Node.MONTH_DAY_FIELD);
	}

	/**
	 * Returns the value of the <b>monthDayField</b> property.
	 * @return the value of the <b>monthDayField</b> property.
	 */
	public String getMonthDayField(){
		return (String)super.get(Node.MONTH_DAY_FIELD);
	}

	/**
	 * Sets the value of the <b>monthDayField</b> property to the given value.
	 */
	public void setMonthDayField(String value){
		super.set(Node.MONTH_DAY_FIELD, value);
	}


	/**
	 * Returns true if the <b>monthField</b> property is set.
	 * @return true if the <b>monthField</b> property is set.
	 */
	public boolean isSetMonthField(){
		return super.isSet(Node.MONTH_FIELD);
	}

	/**
	 * Unsets the <b>monthField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetMonthField(){
		super.unset(Node.MONTH_FIELD);
	}

	/**
	 * Returns the value of the <b>monthField</b> property.
	 * @return the value of the <b>monthField</b> property.
	 */
	public String getMonthField(){
		return (String)super.get(Node.MONTH_FIELD);
	}

	/**
	 * Sets the value of the <b>monthField</b> property to the given value.
	 */
	public void setMonthField(String value){
		super.set(Node.MONTH_FIELD, value);
	}


	/**
	 * Returns true if the <b>name</b> property is set.
	 * @return true if the <b>name</b> property is set.
	 */
	public boolean isSetName(){
		return super.isSet(Node.NAME);
	}

	/**
	 * Unsets the <b>name</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetName(){
		super.unset(Node.NAME);
	}

	/**
	 * Returns the value of the <b>name</b> property.
	 * @return the value of the <b>name</b> property.
	 */
	public String getName(){
		return (String)super.get(Node.NAME);
	}

	/**
	 * Sets the value of the <b>name</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 60</pre>
	 */
	public void setName(String value){
		super.set(Node.NAME, value);
	}


	/**
	 * Returns true if the <b>objectField</b> property is set.
	 * @return true if the <b>objectField</b> property is set.
	 */
	public boolean isSetObjectField(){
		return super.isSet(Node.OBJECT_FIELD);
	}

	/**
	 * Unsets the <b>objectField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetObjectField(){
		super.unset(Node.OBJECT_FIELD);
	}

	/**
	 * Returns the value of the <b>objectField</b> property.
	 * @return the value of the <b>objectField</b> property.
	 */
	public Object getObjectField(){
		return (Object)super.get(Node.OBJECT_FIELD);
	}

	/**
	 * Sets the value of the <b>objectField</b> property to the given value.
	 */
	public void setObjectField(Object value){
		super.set(Node.OBJECT_FIELD, value);
	}


	/**
	 * Returns true if the <b>parent</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getParent() getParent} or {@link #setParent(Node value) setParent(...)} for a definition of property <b>parent</b>
	 * @return true if the <b>parent</b> property is set.
	 */
	public boolean isSetParent(){
		return super.isSet(Node.PARENT);
	}

	/**
	 * Unsets the <b>parent</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getParent() getParent} or {@link #setParent(Node value) setParent(...)} for a definition of property <b>parent</b>
	 */
	public void unsetParent(){
		super.unset(Node.PARENT);
	}

	/**
	 * Creates and returns a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>parent</b>.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getParent() getParent} or {@link #setParent(Node value) setParent(...)} for a definition of property <b>parent</b>
	 * @return a new instance of Type {@link Node} automatically establishing a containment relationship through the object's reference property <b>parent</b>.
	 */
	public Node createParent(){
		return (Node)super.createDataObject(Node.PARENT);
	}

	/**
	 * Returns the value of the <b>parent</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The parent node(s)
	 * @return the value of the <b>parent</b> property.
	 */
	public Node getParent(){
		return (Node)super.get(Node.PARENT);
	}

	/**
	 * Sets the value of the <b>parent</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * The parent node(s)
	 */
	public void setParent(Node value){
		super.set(Node.PARENT, value);
	}


	/**
	 * Returns true if the <b>rootId</b> property is set.
	 * @return true if the <b>rootId</b> property is set.
	 */
	public boolean isSetRootId(){
		return super.isSet(Node.ROOT_ID);
	}

	/**
	 * Unsets the <b>rootId</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetRootId(){
		super.unset(Node.ROOT_ID);
	}

	/**
	 * Returns the value of the <b>rootId</b> property.
	 * @return the value of the <b>rootId</b> property.
	 */
	public int getRootId(){
		Integer result = (Integer)super.get(Node.ROOT_ID);
		if (result != null)
			return result.intValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>rootId</b> property to the given value.
	 */
	public void setRootId(int value){
		super.set(Node.ROOT_ID, value);
	}


	/**
	 * Returns true if the <b>seqId</b> property is set.
	 * @return true if the <b>seqId</b> property is set.
	 */
	public boolean isSetSeqId(){
		return super.isSet(Concurrent.SEQ_ID);
	}

	/**
	 * Unsets the <b>seqId</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetSeqId(){
		super.unset(Concurrent.SEQ_ID);
	}

	/**
	 * Returns the value of the <b>seqId</b> property.
	 * @return the value of the <b>seqId</b> property.
	 */
	public long getSeqId(){
		Long result = (Long)super.get(Concurrent.SEQ_ID);
		if (result != null)
			return result.longValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>seqId</b> property to the given value.
	 */
	public void setSeqId(long value){
		super.set(Concurrent.SEQ_ID, value);
	}


	/**
	 * Returns true if the <b>sequenceNum</b> property is set.
	 * @return true if the <b>sequenceNum</b> property is set.
	 */
	public boolean isSetSequenceNum(){
		return super.isSet(Concurrent.SEQUENCE_NUM);
	}

	/**
	 * Unsets the <b>sequenceNum</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetSequenceNum(){
		super.unset(Concurrent.SEQUENCE_NUM);
	}

	/**
	 * Returns the value of the <b>sequenceNum</b> property.
	 * @return the value of the <b>sequenceNum</b> property.
	 */
	public long getSequenceNum(){
		Long result = (Long)super.get(Concurrent.SEQUENCE_NUM);
		if (result != null)
			return result.longValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>sequenceNum</b> property to the given value.
	 */
	public void setSequenceNum(long value){
		super.set(Concurrent.SEQUENCE_NUM, value);
	}


	/**
	 * Returns true if the <b>shortField</b> property is set.
	 * @return true if the <b>shortField</b> property is set.
	 */
	public boolean isSetShortField(){
		return super.isSet(Node.SHORT_FIELD);
	}

	/**
	 * Unsets the <b>shortField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetShortField(){
		super.unset(Node.SHORT_FIELD);
	}

	/**
	 * Returns the value of the <b>shortField</b> property.
	 * @return the value of the <b>shortField</b> property.
	 */
	public short getShortField(){
		Short result = (Short)super.get(Node.SHORT_FIELD);
		if (result != null)
			return result.shortValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>shortField</b> property to the given value.
	 */
	public void setShortField(short value){
		super.set(Node.SHORT_FIELD, value);
	}


	/**
	 * Returns true if the <b>stringField</b> property is set.
	 * @return true if the <b>stringField</b> property is set.
	 */
	public boolean isSetStringField(){
		return super.isSet(Node.STRING_FIELD);
	}

	/**
	 * Unsets the <b>stringField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetStringField(){
		super.unset(Node.STRING_FIELD);
	}

	/**
	 * Returns the value of the <b>stringField</b> property.
	 * @return the value of the <b>stringField</b> property.
	 */
	public String getStringField(){
		return (String)super.get(Node.STRING_FIELD);
	}

	/**
	 * Sets the value of the <b>stringField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 20</pre>
	 */
	public void setStringField(String value){
		super.set(Node.STRING_FIELD, value);
	}


	/**
	 * Returns true if the <b>stringsField</b> property is set.
	 * @return true if the <b>stringsField</b> property is set.
	 */
	public boolean isSetStringsField(){
		return super.isSet(Node.STRINGS_FIELD);
	}

	/**
	 * Unsets the <b>stringsField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetStringsField(){
		super.unset(Node.STRINGS_FIELD);
	}

	/**
	 * Returns the value of the <b>stringsField</b> property.
	 * @return the value of the <b>stringsField</b> property.
	 */
	public List getStringsField(){
		return (List)super.get(Node.STRINGS_FIELD);
	}

	/**
	 * Sets the value of the <b>stringsField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 30</pre>
	 */
	public void setStringsField(List value){
		super.set(Node.STRINGS_FIELD, value);
	}


	/**
	 * Returns true if the <b>timeField</b> property is set.
	 * @return true if the <b>timeField</b> property is set.
	 */
	public boolean isSetTimeField(){
		return super.isSet(Node.TIME_FIELD);
	}

	/**
	 * Unsets the <b>timeField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetTimeField(){
		super.unset(Node.TIME_FIELD);
	}

	/**
	 * Returns the value of the <b>timeField</b> property.
	 * @return the value of the <b>timeField</b> property.
	 */
	public String getTimeField(){
		return (String)super.get(Node.TIME_FIELD);
	}

	/**
	 * Sets the value of the <b>timeField</b> property to the given value.
	 */
	public void setTimeField(String value){
		super.set(Node.TIME_FIELD, value);
	}


	/**
	 * Returns true if the <b>unsignedIntField</b> property is set.
	 * @return true if the <b>unsignedIntField</b> property is set.
	 */
	public boolean isSetUnsignedIntField(){
		return super.isSet(Node.UNSIGNED_INT_FIELD);
	}

	/**
	 * Unsets the <b>unsignedIntField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetUnsignedIntField(){
		super.unset(Node.UNSIGNED_INT_FIELD);
	}

	/**
	 * Returns the value of the <b>unsignedIntField</b> property.
	 * @return the value of the <b>unsignedIntField</b> property.
	 */
	public UnsignedInteger getUnsignedIntField(){
		return (UnsignedInteger)super.get(Node.UNSIGNED_INT_FIELD);
	}

	/**
	 * Sets the value of the <b>unsignedIntField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre></pre>
	 */
	public void setUnsignedIntField(UnsignedInteger value){
		super.set(Node.UNSIGNED_INT_FIELD, value);
	}


	/**
	 * Returns true if the <b>unsignedLongField</b> property is set.
	 * @return true if the <b>unsignedLongField</b> property is set.
	 */
	public boolean isSetUnsignedLongField(){
		return super.isSet(Node.UNSIGNED_LONG_FIELD);
	}

	/**
	 * Unsets the <b>unsignedLongField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetUnsignedLongField(){
		super.unset(Node.UNSIGNED_LONG_FIELD);
	}

	/**
	 * Returns the value of the <b>unsignedLongField</b> property.
	 * @return the value of the <b>unsignedLongField</b> property.
	 */
	public UnsignedLong getUnsignedLongField(){
		return (UnsignedLong)super.get(Node.UNSIGNED_LONG_FIELD);
	}

	/**
	 * Sets the value of the <b>unsignedLongField</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre></pre>
	 */
	public void setUnsignedLongField(UnsignedLong value){
		super.set(Node.UNSIGNED_LONG_FIELD, value);
	}


	/**
	 * Returns true if the <b>uriField</b> property is set.
	 * @return true if the <b>uriField</b> property is set.
	 */
	public boolean isSetUriField(){
		return super.isSet(Node.URI_FIELD);
	}

	/**
	 * Unsets the <b>uriField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetUriField(){
		super.unset(Node.URI_FIELD);
	}

	/**
	 * Returns the value of the <b>uriField</b> property.
	 * @return the value of the <b>uriField</b> property.
	 */
	public String getUriField(){
		return (String)super.get(Node.URI_FIELD);
	}

	/**
	 * Sets the value of the <b>uriField</b> property to the given value.
	 */
	public void setUriField(String value){
		super.set(Node.URI_FIELD, value);
	}


	/**
	 * Returns true if the <b>yearMonthDayField</b> property is set.
	 * @return true if the <b>yearMonthDayField</b> property is set.
	 */
	public boolean isSetYearMonthDayField(){
		return super.isSet(Node.YEAR_MONTH_DAY_FIELD);
	}

	/**
	 * Unsets the <b>yearMonthDayField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetYearMonthDayField(){
		super.unset(Node.YEAR_MONTH_DAY_FIELD);
	}

	/**
	 * Returns the value of the <b>yearMonthDayField</b> property.
	 * @return the value of the <b>yearMonthDayField</b> property.
	 */
	public String getYearMonthDayField(){
		return (String)super.get(Node.YEAR_MONTH_DAY_FIELD);
	}

	/**
	 * Sets the value of the <b>yearMonthDayField</b> property to the given value.
	 */
	public void setYearMonthDayField(String value){
		super.set(Node.YEAR_MONTH_DAY_FIELD, value);
	}


	/**
	 * Returns true if the <b>yearMonthField</b> property is set.
	 * @return true if the <b>yearMonthField</b> property is set.
	 */
	public boolean isSetYearMonthField(){
		return super.isSet(Node.YEAR_MONTH_FIELD);
	}

	/**
	 * Unsets the <b>yearMonthField</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetYearMonthField(){
		super.unset(Node.YEAR_MONTH_FIELD);
	}

	/**
	 * Returns the value of the <b>yearMonthField</b> property.
	 * @return the value of the <b>yearMonthField</b> property.
	 */
	public String getYearMonthField(){
		return (String)super.get(Node.YEAR_MONTH_FIELD);
	}

	/**
	 * Sets the value of the <b>yearMonthField</b> property to the given value.
	 */
	public void setYearMonthField(String value){
		super.set(Node.YEAR_MONTH_FIELD, value);
	}
}