package org.cloudgraph.test.datatypes.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;
import org.plasma.query.StringDataProperty;
import org.plasma.query.TemporalDataProperty;
import org.plasma.query.IntegralDataProperty;


import org.cloudgraph.test.datatypes.Concurrent;

/**
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>Concurrent</b>.
 */
public class QConcurrent extends DomainRoot
{


	private QConcurrent() {
		super(PlasmaTypeHelper.INSTANCE.getType(Concurrent.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QConcurrent(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QConcurrent(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Concurrent</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QConcurrent newQuery() {
		return new QConcurrent();
	}

	/**
	 * Returns a DSL data element for property, <b>createdBy</b>.
	 * @return a String DSL data element for property, <b>createdBy</b>.
	 */
	public StringDataProperty createdBy() {
		return new DataNode(this, Concurrent.CREATED_BY);
	}

	/**
	 * Returns a DSL data element for property, <b>createdOn</b>.
	 * @return a Temporal DSL data element for property, <b>createdOn</b>.
	 */
	public TemporalDataProperty createdOn() {
		return new DataNode(this, Concurrent.CREATED_ON);
	}

	/**
	 * Returns a DSL data element for property, <b>lastAccessedOn</b>.
	 * @return a Temporal DSL data element for property, <b>lastAccessedOn</b>.
	 */
	public TemporalDataProperty lastAccessedOn() {
		return new DataNode(this, Concurrent.LAST_ACCESSED_ON);
	}

	/**
	 * Returns a DSL data element for property, <b>lastModifiedBy</b>.
	 * @return a String DSL data element for property, <b>lastModifiedBy</b>.
	 */
	public StringDataProperty lastModifiedBy() {
		return new DataNode(this, Concurrent.LAST_MODIFIED_BY);
	}

	/**
	 * Returns a DSL data element for property, <b>lastModifiedOn</b>.
	 * @return a Temporal DSL data element for property, <b>lastModifiedOn</b>.
	 */
	public TemporalDataProperty lastModifiedOn() {
		return new DataNode(this, Concurrent.LAST_MODIFIED_ON);
	}

	/**
	 * Returns a DSL data element for property, <b>levelNum</b>.
	 * @return an Integral DSL data element for property, <b>levelNum</b>.
	 */
	public IntegralDataProperty levelNum() {
		return new DataNode(this, Concurrent.LEVEL_NUM);
	}

	/**
	 * Returns a DSL data element for property, <b>seqId</b>.
	 * @return an Integral DSL data element for property, <b>seqId</b>.
	 */
	public IntegralDataProperty seqId() {
		return new DataNode(this, Concurrent.SEQ_ID);
	}

	/**
	 * Returns a DSL data element for property, <b>sequenceNum</b>.
	 * @return an Integral DSL data element for property, <b>sequenceNum</b>.
	 */
	public IntegralDataProperty sequenceNum() {
		return new DataNode(this, Concurrent.SEQUENCE_NUM);
	}
}