package org.cloudgraph.test.datatypes.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;
import org.plasma.query.DataProperty;
import org.plasma.query.StringDataProperty;
import org.plasma.query.TemporalDataProperty;
import org.plasma.query.RealDataProperty;
import org.plasma.query.IntegralDataProperty;

import org.cloudgraph.test.datatypes.Concurrent;
import org.cloudgraph.test.datatypes.Node;

import org.cloudgraph.test.datatypes.query.QNode;
import org.cloudgraph.test.datatypes.LongNode;

/**
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>LongNode</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>L</b>.
 *
 */
public class QLongNode extends DomainRoot
{


	private QLongNode() {
		super(PlasmaTypeHelper.INSTANCE.getType(LongNode.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QLongNode(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QLongNode(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>LongNode</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QLongNode newQuery() {
		return new QLongNode();
	}

	/**
	 * Returns a DSL data element for property, <b>YearField</b>.
	 * @return a Temporal DSL data element for property, <b>YearField</b>.
	 */
	public TemporalDataProperty YearField() {
		return new DataNode(this, Node.YEAR_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>booleanField</b>.
	 * @return an Integral DSL data element for property, <b>booleanField</b>.
	 */
	public IntegralDataProperty booleanField() {
		return new DataNode(this, Node.BOOLEAN_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>byteField</b>.
	 * @return a DSL data element for property, <b>byteField</b>.
	 */
	public DataProperty byteField() {
		return new DataNode(this, Node.BYTE_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>bytesField</b>.
	 * @return a DSL data element for property, <b>bytesField</b>.
	 */
	public DataProperty bytesField() {
		return new DataNode(this, Node.BYTES_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>characterField</b>.
	 * @return a String DSL data element for property, <b>characterField</b>.
	 */
	public StringDataProperty characterField() {
		return new DataNode(this, Node.CHARACTER_FIELD);
	}

	/**
	 * Returns a DSL query element for reference property, <b>child</b>.
	 * @return a DSL query element for reference property, <b>child</b>.
	 */
	public QNode child() {
		return new QNode(this, Node.CHILD);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>child</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>child</b>.
	 */
	public QNode child(Expression expr) {
		return new QNode(this, Node.CHILD, expr);
	}

	/**
	 * Returns a DSL data element for property, <b>createdBy</b>.
	 * @return a String DSL data element for property, <b>createdBy</b>.
	 */
	public StringDataProperty createdBy() {
		return new DataNode(this, Concurrent.CREATED_BY);
	}

	/**
	 * Returns a DSL data element for property, <b>createdOn</b>.
	 * @return a Temporal DSL data element for property, <b>createdOn</b>.
	 */
	public TemporalDataProperty createdOn() {
		return new DataNode(this, Concurrent.CREATED_ON);
	}

	/**
	 * Returns a DSL data element for property, <b>dateField</b>.
	 * @return a Temporal DSL data element for property, <b>dateField</b>.
	 */
	public TemporalDataProperty dateField() {
		return new DataNode(this, Node.DATE_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>dateTimeField</b>.
	 * @return a Temporal DSL data element for property, <b>dateTimeField</b>.
	 */
	public TemporalDataProperty dateTimeField() {
		return new DataNode(this, Node.DATE_TIME_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>dayField</b>.
	 * @return a Temporal DSL data element for property, <b>dayField</b>.
	 */
	public TemporalDataProperty dayField() {
		return new DataNode(this, Node.DAY_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>decimalField</b>.
	 * @return a Real DSL data element for property, <b>decimalField</b>.
	 */
	public RealDataProperty decimalField() {
		return new DataNode(this, Node.DECIMAL_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>doubleField</b>.
	 * @return a Real DSL data element for property, <b>doubleField</b>.
	 */
	public RealDataProperty doubleField() {
		return new DataNode(this, Node.DOUBLE_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>durationField</b>.
	 * @return a Temporal DSL data element for property, <b>durationField</b>.
	 */
	public TemporalDataProperty durationField() {
		return new DataNode(this, Node.DURATION_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>floatField</b>.
	 * @return a Real DSL data element for property, <b>floatField</b>.
	 */
	public RealDataProperty floatField() {
		return new DataNode(this, Node.FLOAT_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>id</b>.
	 * @return a String DSL data element for property, <b>id</b>.
	 */
	public StringDataProperty id() {
		return new DataNode(this, Node.ID);
	}

	/**
	 * Returns a DSL data element for property, <b>intField</b>.
	 * @return an Integral DSL data element for property, <b>intField</b>.
	 */
	public IntegralDataProperty intField() {
		return new DataNode(this, Node.INT_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>integerField</b>.
	 * @return an Integral DSL data element for property, <b>integerField</b>.
	 */
	public IntegralDataProperty integerField() {
		return new DataNode(this, Node.INTEGER_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>lastAccessedOn</b>.
	 * @return a Temporal DSL data element for property, <b>lastAccessedOn</b>.
	 */
	public TemporalDataProperty lastAccessedOn() {
		return new DataNode(this, Concurrent.LAST_ACCESSED_ON);
	}

	/**
	 * Returns a DSL data element for property, <b>lastModifiedBy</b>.
	 * @return a String DSL data element for property, <b>lastModifiedBy</b>.
	 */
	public StringDataProperty lastModifiedBy() {
		return new DataNode(this, Concurrent.LAST_MODIFIED_BY);
	}

	/**
	 * Returns a DSL data element for property, <b>lastModifiedOn</b>.
	 * @return a Temporal DSL data element for property, <b>lastModifiedOn</b>.
	 */
	public TemporalDataProperty lastModifiedOn() {
		return new DataNode(this, Concurrent.LAST_MODIFIED_ON);
	}

	/**
	 * Returns a DSL data element for property, <b>levelNum</b>.
	 * @return an Integral DSL data element for property, <b>levelNum</b>.
	 */
	public IntegralDataProperty levelNum() {
		return new DataNode(this, Concurrent.LEVEL_NUM);
	}

	/**
	 * Returns a DSL data element for property, <b>longField</b>.
	 * @return an Integral DSL data element for property, <b>longField</b>.
	 */
	public IntegralDataProperty longField() {
		return new DataNode(this, Node.LONG_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>monthDayField</b>.
	 * @return a Temporal DSL data element for property, <b>monthDayField</b>.
	 */
	public TemporalDataProperty monthDayField() {
		return new DataNode(this, Node.MONTH_DAY_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>monthField</b>.
	 * @return a Temporal DSL data element for property, <b>monthField</b>.
	 */
	public TemporalDataProperty monthField() {
		return new DataNode(this, Node.MONTH_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>name</b>.
	 * @return a String DSL data element for property, <b>name</b>.
	 */
	public StringDataProperty name() {
		return new DataNode(this, Node.NAME);
	}

	/**
	 * Returns a DSL data element for property, <b>objectField</b>.
	 * @return a DSL data element for property, <b>objectField</b>.
	 */
	public DataProperty objectField() {
		return new DataNode(this, Node.OBJECT_FIELD);
	}

	/**
	 * Returns a DSL query element for reference property, <b>parent</b>.
	 * @return a DSL query element for reference property, <b>parent</b>.
	 */
	public QNode parent() {
		return new QNode(this, Node.PARENT);
	}

	/**
	 * Returns a DSL data element for property, <b>rootId</b>.
	 * @return an Integral DSL data element for property, <b>rootId</b>.
	 */
	public IntegralDataProperty rootId() {
		return new DataNode(this, Node.ROOT_ID);
	}

	/**
	 * Returns a DSL data element for property, <b>seqId</b>.
	 * @return an Integral DSL data element for property, <b>seqId</b>.
	 */
	public IntegralDataProperty seqId() {
		return new DataNode(this, Concurrent.SEQ_ID);
	}

	/**
	 * Returns a DSL data element for property, <b>sequenceNum</b>.
	 * @return an Integral DSL data element for property, <b>sequenceNum</b>.
	 */
	public IntegralDataProperty sequenceNum() {
		return new DataNode(this, Concurrent.SEQUENCE_NUM);
	}

	/**
	 * Returns a DSL data element for property, <b>shortField</b>.
	 * @return an Integral DSL data element for property, <b>shortField</b>.
	 */
	public IntegralDataProperty shortField() {
		return new DataNode(this, Node.SHORT_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>stringField</b>.
	 * @return a String DSL data element for property, <b>stringField</b>.
	 */
	public StringDataProperty stringField() {
		return new DataNode(this, Node.STRING_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>stringsField</b>.
	 * @return a String DSL data element for property, <b>stringsField</b>.
	 */
	public StringDataProperty stringsField() {
		return new DataNode(this, Node.STRINGS_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>timeField</b>.
	 * @return a Temporal DSL data element for property, <b>timeField</b>.
	 */
	public TemporalDataProperty timeField() {
		return new DataNode(this, Node.TIME_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>unsignedIntField</b>.
	 * @return an Integral DSL data element for property, <b>unsignedIntField</b>.
	 */
	public IntegralDataProperty unsignedIntField() {
		return new DataNode(this, Node.UNSIGNED_INT_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>unsignedLongField</b>.
	 * @return an Integral DSL data element for property, <b>unsignedLongField</b>.
	 */
	public IntegralDataProperty unsignedLongField() {
		return new DataNode(this, Node.UNSIGNED_LONG_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>uriField</b>.
	 * @return a DSL data element for property, <b>uriField</b>.
	 */
	public DataProperty uriField() {
		return new DataNode(this, Node.URI_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>yearMonthDayField</b>.
	 * @return a Temporal DSL data element for property, <b>yearMonthDayField</b>.
	 */
	public TemporalDataProperty yearMonthDayField() {
		return new DataNode(this, Node.YEAR_MONTH_DAY_FIELD);
	}

	/**
	 * Returns a DSL data element for property, <b>yearMonthField</b>.
	 * @return a Temporal DSL data element for property, <b>yearMonthField</b>.
	 */
	public TemporalDataProperty yearMonthField() {
		return new DataNode(this, Node.YEAR_MONTH_FIELD);
	}
}