package org.cloudgraph.test.socialgraph.actor;


import org.cloudgraph.test.socialgraph.actor.Node;
import org.cloudgraph.test.socialgraph.actor.Photo;
import org.cloudgraph.test.socialgraph.story.Blog;

/**
 * Represents a person or a group of people. An actor node 
 * has stories to tell and therefore has a story feed. It 
 * has an identity (Avatar and Information). It often uses a 
 * collection of content creation social applications such 
 * as photos, discussions. Following an actor node results into
 * subscribing to all the stories generated by that actor. 
 * A person actor node can also follow you back.
 * <p></p>
 * Generated interface representing the domain model entity <b>Actor</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/actor</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>A</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Node Node
 * @see org.cloudgraph.test.socialgraph.actor.Photo Photo
 * @see org.cloudgraph.test.socialgraph.story.Blog Blog
 */
public interface Actor extends Node
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_ACTOR = "Actor";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>blog</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Actor</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>A.BLG</b>.
	 */
	public static final String BLOG = "blog";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>photo</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Actor</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>A.PHT</b>.
	 */
	public static final String PHOTO = "photo";
	
	/**
	 * the physical age of the actor
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>age</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Actor</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>A.AG</b>.
	 */
	public static final String AGE = "age";
	
	/**
	 * the intelligence quotent
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>iq</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Actor</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>A.IQ</b>.
	 */
	public static final String IQ = "iq";
	



	/**
	 * Returns true if the <b>blog</b> property is set.
	 * @return true if the <b>blog</b> property is set.
	 */
	public boolean isSetBlog();

	/**
	 * Unsets the <b>blog</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetBlog();

	/**
	 * Creates and returns a new instance of Type {@link Blog} automatically establishing a containment relationship through the object's reference property, <b>blog</b>.
	 * @return a new instance of Type {@link Blog} automatically establishing a containment relationship through the object's reference property <b>blog</b>.
	 */
	public Blog createBlog();

	/**
	 * Returns an array of <b>Blog</b> set for the object's multi-valued property <b>blog</b>.
	 * @return an array of <b>Blog</b> set for the object's multi-valued property <b>blog</b>.
	 */
	public Blog[] getBlog();

	/**
	 * Returns the <b>Blog</b> set for the object's multi-valued property <b>blog</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Blog</b> set for the object's multi-valued property <b>blog</b> based on the given index.
	 */
	public Blog getBlog(int idx);

	/**
	 * Returns a count for multi-valued property <b>blog</b>.
	 * @return a count for multi-valued property <b>blog</b>.
	 */
	public int getBlogCount();

	/**
	 * Sets the given array of Type <b>Blog</b> for the object's multi-valued property <b>blog</b>.
	 * @param value the array value
	 */
	public void setBlog(Blog[] value);

	/**
	 * Adds the given value of Type <b>Blog</b> for the object's multi-valued property <b>blog</b>.
	 * @param value the value to add
	 */
	public void addBlog(Blog value);

	/**
	 * Removes the given value of Type <b>Blog</b> for the object's multi-valued property <b>blog</b>.
	 * @param value the value to remove
	 */
	public void removeBlog(Blog value);


	/**
	 * Returns true if the <b>photo</b> property is set.
	 * @return true if the <b>photo</b> property is set.
	 */
	public boolean isSetPhoto();

	/**
	 * Unsets the <b>photo</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetPhoto();

	/**
	 * Creates and returns a new instance of Type {@link Photo} automatically establishing a containment relationship through the object's reference property, <b>photo</b>.
	 * @return a new instance of Type {@link Photo} automatically establishing a containment relationship through the object's reference property <b>photo</b>.
	 */
	public Photo createPhoto();

	/**
	 * Returns an array of <b>Photo</b> set for the object's multi-valued property <b>photo</b>.
	 * @return an array of <b>Photo</b> set for the object's multi-valued property <b>photo</b>.
	 */
	public Photo[] getPhoto();

	/**
	 * Returns the <b>Photo</b> set for the object's multi-valued property <b>photo</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Photo</b> set for the object's multi-valued property <b>photo</b> based on the given index.
	 */
	public Photo getPhoto(int idx);

	/**
	 * Returns a count for multi-valued property <b>photo</b>.
	 * @return a count for multi-valued property <b>photo</b>.
	 */
	public int getPhotoCount();

	/**
	 * Sets the given array of Type <b>Photo</b> for the object's multi-valued property <b>photo</b>.
	 * @param value the array value
	 */
	public void setPhoto(Photo[] value);

	/**
	 * Adds the given value of Type <b>Photo</b> for the object's multi-valued property <b>photo</b>.
	 * @param value the value to add
	 */
	public void addPhoto(Photo value);

	/**
	 * Removes the given value of Type <b>Photo</b> for the object's multi-valued property <b>photo</b>.
	 * @param value the value to remove
	 */
	public void removePhoto(Photo value);


	/**
	 * Returns true if the <b>age</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getAge() getAge} or {@link #setAge(int value) setAge(...)} for a definition of property <b>age</b>
	 * @return true if the <b>age</b> property is set.
	 */
	public boolean isSetAge();

	/**
	 * Unsets the <b>age</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getAge() getAge} or {@link #setAge(int value) setAge(...)} for a definition of property <b>age</b>
	 */
	public void unsetAge();

	/**
	 * Returns the value of the <b>age</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the physical age of the actor
	 * @return the value of the <b>age</b> property.
	 */
	public int getAge();

	/**
	 * Sets the value of the <b>age</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the physical age of the actor
	 */
	public void setAge(int value);


	/**
	 * Returns true if the <b>iq</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getIq() getIq} or {@link #setIq(int value) setIq(...)} for a definition of property <b>iq</b>
	 * @return true if the <b>iq</b> property is set.
	 */
	public boolean isSetIq();

	/**
	 * Unsets the <b>iq</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getIq() getIq} or {@link #setIq(int value) setIq(...)} for a definition of property <b>iq</b>
	 */
	public void unsetIq();

	/**
	 * Returns the value of the <b>iq</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the intelligence quotent
	 * @return the value of the <b>iq</b> property.
	 */
	public int getIq();

	/**
	 * Sets the value of the <b>iq</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the intelligence quotent
	 */
	public void setIq(int value);
}