package org.cloudgraph.test.socialgraph.actor;


import org.cloudgraph.test.socialgraph.actor.Node;
import org.plasma.sdo.PlasmaDataObject;

/**
 * A directed link between two nodes.
 * <p></p>
 * Generated interface representing the domain model entity <b>Edge</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/actor</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>E</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Node Node
 */
public interface Edge extends PlasmaDataObject
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_EDGE = "Edge";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>source</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Edge</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>E.S</b>.
	 */
	public static final String SOURCE = "source";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>target</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Edge</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>E.T</b>.
	 */
	public static final String TARGET = "target";
	



	/**
	 * Returns true if the <b>source</b> property is set.
	 * @return true if the <b>source</b> property is set.
	 */
	public boolean isSetSource();

	/**
	 * Unsets the <b>source</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetSource();

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>source</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Node}.
	 */
	public Node createSource(Class<? extends Node> clss);

	/**
	 * Returns the value of the <b>source</b> property.
	 * @return the value of the <b>source</b> property.
	 */
	public Node getSource();

	/**
	 * Sets the value of the <b>source</b> property to the given value.
	 */
	public void setSource(Node value);


	/**
	 * Returns true if the <b>target</b> property is set.
	 * @return true if the <b>target</b> property is set.
	 */
	public boolean isSetTarget();

	/**
	 * Unsets the <b>target</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetTarget();

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>target</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Node}.
	 */
	public Node createTarget(Class<? extends Node> clss);

	/**
	 * Returns the value of the <b>target</b> property.
	 * @return the value of the <b>target</b> property.
	 */
	public Node getTarget();

	/**
	 * Sets the value of the <b>target</b> property to the given value.
	 */
	public void setTarget(Node value);
}