package org.cloudgraph.test.socialgraph.actor;


import java.util.Date;
import org.cloudgraph.test.socialgraph.actor.Edge;
import org.plasma.sdo.PlasmaDataObject;

/**
 * In a social network all entities such as people, groups, 
 * events, topics, images, stories, etc. are represented as 
 * nodes. Nodes have some common characteristics. For 
 * example: title, description, unique URL, and Geo-location 
 * information. All nodes can be tagged and commented on.
 * <p></p>
 * Generated interface representing the domain model entity <b>Node</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/actor</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>N</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Edge Edge
 */
public interface Node extends PlasmaDataObject
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_NODE = "Node";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>sourceEdge</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.S</b>.
	 */
	public static final String SOURCE_EDGE = "sourceEdge";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>targetEdge</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.T</b>.
	 */
	public static final String TARGET_EDGE = "targetEdge";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>name</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.N</b>.
	 */
	public static final String NAME = "name";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>description</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.D</b>.
	 */
	public static final String DESCRIPTION = "description";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>createdDate</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.C</b>.
	 */
	public static final String CREATED_DATE = "createdDate";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>modifiedDate</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.M</b>.
	 */
	public static final String MODIFIED_DATE = "modifiedDate";
	
	/**
	 * the id
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>id</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.I</b>.
	 */
	public static final String ID = "id";
	
	/**
	 * the version num
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>modifiedVersion</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Node</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>N.V</b>.
	 */
	public static final String MODIFIED_VERSION = "modifiedVersion";
	



	/**
	 * Returns true if the <b>sourceEdge</b> property is set.
	 * @return true if the <b>sourceEdge</b> property is set.
	 */
	public boolean isSetSourceEdge();

	/**
	 * Unsets the <b>sourceEdge</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetSourceEdge();

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Edge} automatically establishing a containment relationship through the object's reference property, <b>sourceEdge</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Edge}.
	 */
	public Edge createSourceEdge(Class<? extends Edge> clss);

	/**
	 * Returns an array of <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b>.
	 * @return an array of <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b>.
	 */
	public Edge[] getSourceEdge();

	/**
	 * Returns the <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b> based on the given index.
	 */
	public Edge getSourceEdge(int idx);

	/**
	 * Returns a count for multi-valued property <b>sourceEdge</b>.
	 * @return a count for multi-valued property <b>sourceEdge</b>.
	 */
	public int getSourceEdgeCount();

	/**
	 * Sets the given array of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the array value
	 */
	public void setSourceEdge(Edge[] value);

	/**
	 * Adds the given value of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the value to add
	 */
	public void addSourceEdge(Edge value);

	/**
	 * Removes the given value of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the value to remove
	 */
	public void removeSourceEdge(Edge value);


	/**
	 * Returns true if the <b>targetEdge</b> property is set.
	 * @return true if the <b>targetEdge</b> property is set.
	 */
	public boolean isSetTargetEdge();

	/**
	 * Unsets the <b>targetEdge</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetTargetEdge();

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Edge} automatically establishing a containment relationship through the object's reference property, <b>targetEdge</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Edge}.
	 */
	public Edge createTargetEdge(Class<? extends Edge> clss);

	/**
	 * Returns an array of <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b>.
	 * @return an array of <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b>.
	 */
	public Edge[] getTargetEdge();

	/**
	 * Returns the <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b> based on the given index.
	 */
	public Edge getTargetEdge(int idx);

	/**
	 * Returns a count for multi-valued property <b>targetEdge</b>.
	 * @return a count for multi-valued property <b>targetEdge</b>.
	 */
	public int getTargetEdgeCount();

	/**
	 * Sets the given array of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the array value
	 */
	public void setTargetEdge(Edge[] value);

	/**
	 * Adds the given value of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the value to add
	 */
	public void addTargetEdge(Edge value);

	/**
	 * Removes the given value of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the value to remove
	 */
	public void removeTargetEdge(Edge value);


	/**
	 * Returns true if the <b>name</b> property is set.
	 * @return true if the <b>name</b> property is set.
	 */
	public boolean isSetName();

	/**
	 * Unsets the <b>name</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetName();

	/**
	 * Returns the value of the <b>name</b> property.
	 * @return the value of the <b>name</b> property.
	 */
	public String getName();

	/**
	 * Sets the value of the <b>name</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 32</pre>
	 */
	public void setName(String value);


	/**
	 * Returns true if the <b>description</b> property is set.
	 * @return true if the <b>description</b> property is set.
	 */
	public boolean isSetDescription();

	/**
	 * Unsets the <b>description</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDescription();

	/**
	 * Returns the value of the <b>description</b> property.
	 * @return the value of the <b>description</b> property.
	 */
	public String getDescription();

	/**
	 * Sets the value of the <b>description</b> property to the given value.
	 */
	public void setDescription(String value);


	/**
	 * Returns true if the <b>createdDate</b> property is set.
	 * @return true if the <b>createdDate</b> property is set.
	 */
	public boolean isSetCreatedDate();

	/**
	 * Unsets the <b>createdDate</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCreatedDate();

	/**
	 * Returns the value of the <b>createdDate</b> property.
	 * @return the value of the <b>createdDate</b> property.
	 */
	public Date getCreatedDate();

	/**
	 * Sets the value of the <b>createdDate</b> property to the given value.
	 */
	public void setCreatedDate(Date value);


	/**
	 * Returns true if the <b>modifiedDate</b> property is set.
	 * @return true if the <b>modifiedDate</b> property is set.
	 */
	public boolean isSetModifiedDate();

	/**
	 * Unsets the <b>modifiedDate</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetModifiedDate();

	/**
	 * Returns the value of the <b>modifiedDate</b> property.
	 * @return the value of the <b>modifiedDate</b> property.
	 */
	public Date getModifiedDate();

	/**
	 * Sets the value of the <b>modifiedDate</b> property to the given value.
	 */
	public void setModifiedDate(Date value);


	/**
	 * Returns true if the <b>id</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getId() getId} or {@link #setId(String value) setId(...)} for a definition of property <b>id</b>
	 * @return true if the <b>id</b> property is set.
	 */
	public boolean isSetId();

	/**
	 * Unsets the <b>id</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getId() getId} or {@link #setId(String value) setId(...)} for a definition of property <b>id</b>
	 */
	public void unsetId();

	/**
	 * Returns the value of the <b>id</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the id
	 * @return the value of the <b>id</b> property.
	 */
	public String getId();

	/**
	 * Sets the value of the <b>id</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the id
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 36</pre>
	 */
	public void setId(String value);


	/**
	 * Returns true if the <b>modifiedVersion</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getModifiedVersion() getModifiedVersion} or {@link #setModifiedVersion(long value) setModifiedVersion(...)} for a definition of property <b>modifiedVersion</b>
	 * @return true if the <b>modifiedVersion</b> property is set.
	 */
	public boolean isSetModifiedVersion();

	/**
	 * Unsets the <b>modifiedVersion</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getModifiedVersion() getModifiedVersion} or {@link #setModifiedVersion(long value) setModifiedVersion(...)} for a definition of property <b>modifiedVersion</b>
	 */
	public void unsetModifiedVersion();

	/**
	 * Returns the value of the <b>modifiedVersion</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the version num
	 * @return the value of the <b>modifiedVersion</b> property.
	 */
	public long getModifiedVersion();

	/**
	 * Sets the value of the <b>modifiedVersion</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the version num
	 */
	public void setModifiedVersion(long value);
}