package org.cloudgraph.test.socialgraph.actor;


import org.cloudgraph.test.socialgraph.actor.Actor;
import org.cloudgraph.test.socialgraph.actor.Media;
import org.cloudgraph.test.socialgraph.actor.Node;

/**
 * Generated interface representing the domain model entity <b>Photo</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/actor</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>P</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Actor Actor
 * @see org.cloudgraph.test.socialgraph.actor.Media Media
 * @see org.cloudgraph.test.socialgraph.actor.Node Node
 */
public interface Photo extends Media
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_PHOTO = "Photo";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>content</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Photo</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>P.B</b>.
	 */
	public static final String CONTENT = "content";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>actor</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Photo</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>P.A</b>.
	 */
	public static final String ACTOR = "actor";
	



	/**
	 * Returns true if the <b>content</b> property is set.
	 * @return true if the <b>content</b> property is set.
	 */
	public boolean isSetContent();

	/**
	 * Unsets the <b>content</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetContent();

	/**
	 * Returns the value of the <b>content</b> property.
	 * @return the value of the <b>content</b> property.
	 */
	public byte[] getContent();

	/**
	 * Sets the value of the <b>content</b> property to the given value.
	 */
	public void setContent(byte[] value);


	/**
	 * Returns true if the <b>actor</b> property is set.
	 * @return true if the <b>actor</b> property is set.
	 */
	public boolean isSetActor();

	/**
	 * Unsets the <b>actor</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetActor();

	/**
	 * Creates and returns a new instance of Type {@link Actor} automatically establishing a containment relationship through the object's reference property, <b>actor</b>.
	 * @return a new instance of Type {@link Actor} automatically establishing a containment relationship through the object's reference property <b>actor</b>.
	 */
	public Actor createActor();

	/**
	 * Returns an array of <b>Actor</b> set for the object's multi-valued property <b>actor</b>.
	 * @return an array of <b>Actor</b> set for the object's multi-valued property <b>actor</b>.
	 */
	public Actor[] getActor();

	/**
	 * Returns the <b>Actor</b> set for the object's multi-valued property <b>actor</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Actor</b> set for the object's multi-valued property <b>actor</b> based on the given index.
	 */
	public Actor getActor(int idx);

	/**
	 * Returns a count for multi-valued property <b>actor</b>.
	 * @return a count for multi-valued property <b>actor</b>.
	 */
	public int getActorCount();

	/**
	 * Sets the given array of Type <b>Actor</b> for the object's multi-valued property <b>actor</b>.
	 * @param value the array value
	 */
	public void setActor(Actor[] value);

	/**
	 * Adds the given value of Type <b>Actor</b> for the object's multi-valued property <b>actor</b>.
	 * @param value the value to add
	 */
	public void addActor(Actor value);

	/**
	 * Removes the given value of Type <b>Actor</b> for the object's multi-valued property <b>actor</b>.
	 * @param value the value to remove
	 */
	public void removeActor(Actor value);
}