package org.cloudgraph.test.socialgraph.actor;


import org.cloudgraph.test.socialgraph.actor.Node;
import org.cloudgraph.test.socialgraph.actor.Topic;
import org.cloudgraph.test.socialgraph.story.Story;

/**
 * Generated interface representing the domain model entity <b>Topic</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/actor</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>T</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Node Node
 * @see org.cloudgraph.test.socialgraph.actor.Topic Topic
 * @see org.cloudgraph.test.socialgraph.story.Story Story
 */
public interface Topic extends Node
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_TOPIC = "Topic";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>parent</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Topic</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>T.P</b>.
	 */
	public static final String PARENT = "parent";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>child</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Topic</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>T.CT</b>.
	 */
	public static final String CHILD = "child";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>story</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Topic</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>T.Y</b>.
	 */
	public static final String STORY = "story";
	



	/**
	 * Returns true if the <b>parent</b> property is set.
	 * @return true if the <b>parent</b> property is set.
	 */
	public boolean isSetParent();

	/**
	 * Unsets the <b>parent</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetParent();

	/**
	 * Creates and returns a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property, <b>parent</b>.
	 * @return a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property <b>parent</b>.
	 */
	public Topic createParent();

	/**
	 * Returns the value of the <b>parent</b> property.
	 * @return the value of the <b>parent</b> property.
	 */
	public Topic getParent();

	/**
	 * Sets the value of the <b>parent</b> property to the given value.
	 */
	public void setParent(Topic value);


	/**
	 * Returns true if the <b>child</b> property is set.
	 * @return true if the <b>child</b> property is set.
	 */
	public boolean isSetChild();

	/**
	 * Unsets the <b>child</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetChild();

	/**
	 * Creates and returns a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property, <b>child</b>.
	 * @return a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property <b>child</b>.
	 */
	public Topic createChild();

	/**
	 * Returns an array of <b>Topic</b> set for the object's multi-valued property <b>child</b>.
	 * @return an array of <b>Topic</b> set for the object's multi-valued property <b>child</b>.
	 */
	public Topic[] getChild();

	/**
	 * Returns the <b>Topic</b> set for the object's multi-valued property <b>child</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Topic</b> set for the object's multi-valued property <b>child</b> based on the given index.
	 */
	public Topic getChild(int idx);

	/**
	 * Returns a count for multi-valued property <b>child</b>.
	 * @return a count for multi-valued property <b>child</b>.
	 */
	public int getChildCount();

	/**
	 * Sets the given array of Type <b>Topic</b> for the object's multi-valued property <b>child</b>.
	 * @param value the array value
	 */
	public void setChild(Topic[] value);

	/**
	 * Adds the given value of Type <b>Topic</b> for the object's multi-valued property <b>child</b>.
	 * @param value the value to add
	 */
	public void addChild(Topic value);

	/**
	 * Removes the given value of Type <b>Topic</b> for the object's multi-valued property <b>child</b>.
	 * @param value the value to remove
	 */
	public void removeChild(Topic value);


	/**
	 * Returns true if the <b>story</b> property is set.
	 * @return true if the <b>story</b> property is set.
	 */
	public boolean isSetStory();

	/**
	 * Unsets the <b>story</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetStory();

	/**
	 * Creates and returns a new instance of Type {@link Story} automatically establishing a containment relationship through the object's reference property, <b>story</b>.
	 * @return a new instance of Type {@link Story} automatically establishing a containment relationship through the object's reference property <b>story</b>.
	 */
	public Story createStory();

	/**
	 * Returns an array of <b>Story</b> set for the object's multi-valued property <b>story</b>.
	 * @return an array of <b>Story</b> set for the object's multi-valued property <b>story</b>.
	 */
	public Story[] getStory();

	/**
	 * Returns the <b>Story</b> set for the object's multi-valued property <b>story</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Story</b> set for the object's multi-valued property <b>story</b> based on the given index.
	 */
	public Story getStory(int idx);

	/**
	 * Returns a count for multi-valued property <b>story</b>.
	 * @return a count for multi-valued property <b>story</b>.
	 */
	public int getStoryCount();

	/**
	 * Sets the given array of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the array value
	 */
	public void setStory(Story[] value);

	/**
	 * Adds the given value of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the value to add
	 */
	public void addStory(Story value);

	/**
	 * Removes the given value of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the value to remove
	 */
	public void removeStory(Story value);
}