package org.cloudgraph.test.socialgraph.actor.impl;

import java.io.Serializable;
import org.plasma.sdo.core.CoreDataObject;
import java.util.List;
import java.util.ArrayList;
import java.lang.String;
import java.util.Date;
import org.cloudgraph.test.socialgraph.actor.Actor;
import org.cloudgraph.test.socialgraph.actor.Edge;
import org.cloudgraph.test.socialgraph.actor.Node;
import org.cloudgraph.test.socialgraph.actor.Photo;
import org.cloudgraph.test.socialgraph.story.Blog;

/**
 * Represents a person or a group of people. An actor node 
 * has stories to tell and therefore has a story feed. It 
 * has an identity (Avatar and Information). It often uses a 
 * collection of content creation social applications such 
 * as photos, discussions. Following an actor node results into
 * subscribing to all the stories generated by that actor. 
 * A person actor node can also follow you back.
 * <p></p>
 * Generated implementation class representing the domain model entity <b>Actor</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>A</b>.
 * <p></p>
 *
 */
public class ActorSDO extends CoreDataObject implements Serializable, Actor
{
	private static final long serialVersionUID = 1L;
	/** The SDO namespace URI associated with the SDO Type for this class */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/**
	 * Default No-arg constructor required for serialization operations. This method
	 * is NOT intended to be used within application source code.
	 */
	public ActorSDO() {
		super();
	}
	public ActorSDO(commonj.sdo.Type type) {
		super(type);
	}


	/**
	 * Returns true if the <b>age</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getAge() getAge} or {@link #setAge(int value) setAge(...)} for a definition of property <b>age</b>
	 * @return true if the <b>age</b> property is set.
	 */
	public boolean isSetAge(){
		return super.isSet(Actor.AGE);
	}

	/**
	 * Unsets the <b>age</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getAge() getAge} or {@link #setAge(int value) setAge(...)} for a definition of property <b>age</b>
	 */
	public void unsetAge(){
		super.unset(Actor.AGE);
	}

	/**
	 * Returns the value of the <b>age</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the physical age of the actor
	 * @return the value of the <b>age</b> property.
	 */
	public int getAge(){
		Integer result = (Integer)super.get(Actor.AGE);
		if (result != null)
			return result.intValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>age</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the physical age of the actor
	 */
	public void setAge(int value){
		super.set(Actor.AGE, value);
	}


	/**
	 * Returns true if the <b>blog</b> property is set.
	 * @return true if the <b>blog</b> property is set.
	 */
	public boolean isSetBlog(){
		return super.isSet(Actor.BLOG);
	}

	/**
	 * Unsets the <b>blog</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetBlog(){
		super.unset(Actor.BLOG);
	}

	/**
	 * Creates and returns a new instance of Type {@link Blog} automatically establishing a containment relationship through the object's reference property, <b>blog</b>.
	 * @return a new instance of Type {@link Blog} automatically establishing a containment relationship through the object's reference property <b>blog</b>.
	 */
	public Blog createBlog(){
		return (Blog)super.createDataObject(Actor.BLOG);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Blog</b> set for the object's multi-valued property <b>blog</b>.
	 * @return an array of <b>Blog</b> set for the object's multi-valued property <b>blog</b>.
	 */
	public Blog[] getBlog(){
		List<Blog> list = (List<Blog>)super.get(Actor.BLOG);
		if (list != null) {
			Blog[] array = new Blog[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Blog[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Blog</b> set for the object's multi-valued property <b>blog</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Blog</b> set for the object's multi-valued property <b>blog</b> based on the given index.
	 */
	public Blog getBlog(int idx){
		List<Blog> list = (List<Blog>)super.get(Actor.BLOG);
		if (list != null) {
			return (Blog)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>blog</b>.
	 * @return a count for multi-valued property <b>blog</b>.
	 */
	public int getBlogCount(){
		List<Blog> list = (List<Blog>)super.get(Actor.BLOG);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Blog</b> for the object's multi-valued property <b>blog</b>.
	 * @param value the array value
	 */
	public void setBlog(Blog[] value){
		List<Blog> list = (List<Blog>)super.get(Actor.BLOG);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Blog>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Actor.BLOG, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetBlog() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Blog</b> for the object's multi-valued property <b>blog</b>.
	 * @param value the value to add
	 */
	public void addBlog(Blog value){
		List<Blog> list = (List<Blog>)super.get(Actor.BLOG);
		if (list == null)
			list = new ArrayList<Blog>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Actor.BLOG, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Blog</b> for the object's multi-valued property <b>blog</b>.
	 * @param value the value to remove
	 */
	public void removeBlog(Blog value){
		List<Blog> list = (List<Blog>)super.get(Actor.BLOG);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Actor.BLOG, list);
	}


	/**
	 * Returns true if the <b>createdDate</b> property is set.
	 * @return true if the <b>createdDate</b> property is set.
	 */
	public boolean isSetCreatedDate(){
		return super.isSet(Node.CREATED_DATE);
	}

	/**
	 * Unsets the <b>createdDate</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCreatedDate(){
		super.unset(Node.CREATED_DATE);
	}

	/**
	 * Returns the value of the <b>createdDate</b> property.
	 * @return the value of the <b>createdDate</b> property.
	 */
	public Date getCreatedDate(){
		return (Date)super.get(Node.CREATED_DATE);
	}

	/**
	 * Sets the value of the <b>createdDate</b> property to the given value.
	 */
	public void setCreatedDate(Date value){
		super.set(Node.CREATED_DATE, value);
	}


	/**
	 * Returns true if the <b>description</b> property is set.
	 * @return true if the <b>description</b> property is set.
	 */
	public boolean isSetDescription(){
		return super.isSet(Node.DESCRIPTION);
	}

	/**
	 * Unsets the <b>description</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDescription(){
		super.unset(Node.DESCRIPTION);
	}

	/**
	 * Returns the value of the <b>description</b> property.
	 * @return the value of the <b>description</b> property.
	 */
	public String getDescription(){
		return (String)super.get(Node.DESCRIPTION);
	}

	/**
	 * Sets the value of the <b>description</b> property to the given value.
	 */
	public void setDescription(String value){
		super.set(Node.DESCRIPTION, value);
	}


	/**
	 * Returns true if the <b>id</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getId() getId} or {@link #setId(String value) setId(...)} for a definition of property <b>id</b>
	 * @return true if the <b>id</b> property is set.
	 */
	public boolean isSetId(){
		return super.isSet(Node.ID);
	}

	/**
	 * Unsets the <b>id</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getId() getId} or {@link #setId(String value) setId(...)} for a definition of property <b>id</b>
	 */
	public void unsetId(){
		super.unset(Node.ID);
	}

	/**
	 * Returns the value of the <b>id</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the id
	 * @return the value of the <b>id</b> property.
	 */
	public String getId(){
		return (String)super.get(Node.ID);
	}

	/**
	 * Sets the value of the <b>id</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the id
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 36</pre>
	 */
	public void setId(String value){
		super.set(Node.ID, value);
	}


	/**
	 * Returns true if the <b>iq</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getIq() getIq} or {@link #setIq(int value) setIq(...)} for a definition of property <b>iq</b>
	 * @return true if the <b>iq</b> property is set.
	 */
	public boolean isSetIq(){
		return super.isSet(Actor.IQ);
	}

	/**
	 * Unsets the <b>iq</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getIq() getIq} or {@link #setIq(int value) setIq(...)} for a definition of property <b>iq</b>
	 */
	public void unsetIq(){
		super.unset(Actor.IQ);
	}

	/**
	 * Returns the value of the <b>iq</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the intelligence quotent
	 * @return the value of the <b>iq</b> property.
	 */
	public int getIq(){
		Integer result = (Integer)super.get(Actor.IQ);
		if (result != null)
			return result.intValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>iq</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the intelligence quotent
	 */
	public void setIq(int value){
		super.set(Actor.IQ, value);
	}


	/**
	 * Returns true if the <b>modifiedDate</b> property is set.
	 * @return true if the <b>modifiedDate</b> property is set.
	 */
	public boolean isSetModifiedDate(){
		return super.isSet(Node.MODIFIED_DATE);
	}

	/**
	 * Unsets the <b>modifiedDate</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetModifiedDate(){
		super.unset(Node.MODIFIED_DATE);
	}

	/**
	 * Returns the value of the <b>modifiedDate</b> property.
	 * @return the value of the <b>modifiedDate</b> property.
	 */
	public Date getModifiedDate(){
		return (Date)super.get(Node.MODIFIED_DATE);
	}

	/**
	 * Sets the value of the <b>modifiedDate</b> property to the given value.
	 */
	public void setModifiedDate(Date value){
		super.set(Node.MODIFIED_DATE, value);
	}


	/**
	 * Returns true if the <b>modifiedVersion</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getModifiedVersion() getModifiedVersion} or {@link #setModifiedVersion(long value) setModifiedVersion(...)} for a definition of property <b>modifiedVersion</b>
	 * @return true if the <b>modifiedVersion</b> property is set.
	 */
	public boolean isSetModifiedVersion(){
		return super.isSet(Node.MODIFIED_VERSION);
	}

	/**
	 * Unsets the <b>modifiedVersion</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getModifiedVersion() getModifiedVersion} or {@link #setModifiedVersion(long value) setModifiedVersion(...)} for a definition of property <b>modifiedVersion</b>
	 */
	public void unsetModifiedVersion(){
		super.unset(Node.MODIFIED_VERSION);
	}

	/**
	 * Returns the value of the <b>modifiedVersion</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the version num
	 * @return the value of the <b>modifiedVersion</b> property.
	 */
	public long getModifiedVersion(){
		Long result = (Long)super.get(Node.MODIFIED_VERSION);
		if (result != null)
			return result.longValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>modifiedVersion</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the version num
	 */
	public void setModifiedVersion(long value){
		super.set(Node.MODIFIED_VERSION, value);
	}


	/**
	 * Returns true if the <b>name</b> property is set.
	 * @return true if the <b>name</b> property is set.
	 */
	public boolean isSetName(){
		return super.isSet(Node.NAME);
	}

	/**
	 * Unsets the <b>name</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetName(){
		super.unset(Node.NAME);
	}

	/**
	 * Returns the value of the <b>name</b> property.
	 * @return the value of the <b>name</b> property.
	 */
	public String getName(){
		return (String)super.get(Node.NAME);
	}

	/**
	 * Sets the value of the <b>name</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 32</pre>
	 */
	public void setName(String value){
		super.set(Node.NAME, value);
	}


	/**
	 * Returns true if the <b>photo</b> property is set.
	 * @return true if the <b>photo</b> property is set.
	 */
	public boolean isSetPhoto(){
		return super.isSet(Actor.PHOTO);
	}

	/**
	 * Unsets the <b>photo</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetPhoto(){
		super.unset(Actor.PHOTO);
	}

	/**
	 * Creates and returns a new instance of Type {@link Photo} automatically establishing a containment relationship through the object's reference property, <b>photo</b>.
	 * @return a new instance of Type {@link Photo} automatically establishing a containment relationship through the object's reference property <b>photo</b>.
	 */
	public Photo createPhoto(){
		return (Photo)super.createDataObject(Actor.PHOTO);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Photo</b> set for the object's multi-valued property <b>photo</b>.
	 * @return an array of <b>Photo</b> set for the object's multi-valued property <b>photo</b>.
	 */
	public Photo[] getPhoto(){
		List<Photo> list = (List<Photo>)super.get(Actor.PHOTO);
		if (list != null) {
			Photo[] array = new Photo[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Photo[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Photo</b> set for the object's multi-valued property <b>photo</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Photo</b> set for the object's multi-valued property <b>photo</b> based on the given index.
	 */
	public Photo getPhoto(int idx){
		List<Photo> list = (List<Photo>)super.get(Actor.PHOTO);
		if (list != null) {
			return (Photo)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>photo</b>.
	 * @return a count for multi-valued property <b>photo</b>.
	 */
	public int getPhotoCount(){
		List<Photo> list = (List<Photo>)super.get(Actor.PHOTO);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Photo</b> for the object's multi-valued property <b>photo</b>.
	 * @param value the array value
	 */
	public void setPhoto(Photo[] value){
		List<Photo> list = (List<Photo>)super.get(Actor.PHOTO);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Photo>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Actor.PHOTO, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetPhoto() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Photo</b> for the object's multi-valued property <b>photo</b>.
	 * @param value the value to add
	 */
	public void addPhoto(Photo value){
		List<Photo> list = (List<Photo>)super.get(Actor.PHOTO);
		if (list == null)
			list = new ArrayList<Photo>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Actor.PHOTO, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Photo</b> for the object's multi-valued property <b>photo</b>.
	 * @param value the value to remove
	 */
	public void removePhoto(Photo value){
		List<Photo> list = (List<Photo>)super.get(Actor.PHOTO);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Actor.PHOTO, list);
	}


	/**
	 * Returns true if the <b>sourceEdge</b> property is set.
	 * @return true if the <b>sourceEdge</b> property is set.
	 */
	public boolean isSetSourceEdge(){
		return super.isSet(Node.SOURCE_EDGE);
	}

	/**
	 * Unsets the <b>sourceEdge</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetSourceEdge(){
		super.unset(Node.SOURCE_EDGE);
	}

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Edge} automatically establishing a containment relationship through the object's reference property, <b>sourceEdge</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Edge}.
	 */
	public Edge createSourceEdge(Class<? extends Edge> clss){
		commonj.sdo.Type classType = org.plasma.sdo.helper.PlasmaTypeHelper.INSTANCE.getType(clss);
		return (Edge)super.createDataObject(this.getType().getProperty(Node.SOURCE_EDGE), classType);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b>.
	 * @return an array of <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b>.
	 */
	public Edge[] getSourceEdge(){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null) {
			Edge[] array = new Edge[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Edge[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b> based on the given index.
	 */
	public Edge getSourceEdge(int idx){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null) {
			return (Edge)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>sourceEdge</b>.
	 * @return a count for multi-valued property <b>sourceEdge</b>.
	 */
	public int getSourceEdgeCount(){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the array value
	 */
	public void setSourceEdge(Edge[] value){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Edge>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Node.SOURCE_EDGE, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetSourceEdge() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the value to add
	 */
	public void addSourceEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list == null)
			list = new ArrayList<Edge>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.SOURCE_EDGE, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the value to remove
	 */
	public void removeSourceEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.SOURCE_EDGE, list);
	}


	/**
	 * Returns true if the <b>targetEdge</b> property is set.
	 * @return true if the <b>targetEdge</b> property is set.
	 */
	public boolean isSetTargetEdge(){
		return super.isSet(Node.TARGET_EDGE);
	}

	/**
	 * Unsets the <b>targetEdge</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetTargetEdge(){
		super.unset(Node.TARGET_EDGE);
	}

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Edge} automatically establishing a containment relationship through the object's reference property, <b>targetEdge</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Edge}.
	 */
	public Edge createTargetEdge(Class<? extends Edge> clss){
		commonj.sdo.Type classType = org.plasma.sdo.helper.PlasmaTypeHelper.INSTANCE.getType(clss);
		return (Edge)super.createDataObject(this.getType().getProperty(Node.TARGET_EDGE), classType);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b>.
	 * @return an array of <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b>.
	 */
	public Edge[] getTargetEdge(){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null) {
			Edge[] array = new Edge[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Edge[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b> based on the given index.
	 */
	public Edge getTargetEdge(int idx){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null) {
			return (Edge)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>targetEdge</b>.
	 * @return a count for multi-valued property <b>targetEdge</b>.
	 */
	public int getTargetEdgeCount(){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the array value
	 */
	public void setTargetEdge(Edge[] value){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Edge>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Node.TARGET_EDGE, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetTargetEdge() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the value to add
	 */
	public void addTargetEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list == null)
			list = new ArrayList<Edge>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.TARGET_EDGE, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the value to remove
	 */
	public void removeTargetEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.TARGET_EDGE, list);
	}
}