package org.cloudgraph.test.socialgraph.actor.impl;

import java.io.Serializable;
import org.plasma.sdo.core.CoreDataObject;
import org.cloudgraph.test.socialgraph.actor.Edge;
import org.cloudgraph.test.socialgraph.actor.Follow;
import org.cloudgraph.test.socialgraph.actor.Node;

/**
 * A relationship (edge) between 2 nodes where the source is 
 * a follower and the target is a leader.
 * <p></p>
 * Generated implementation class representing the domain model entity <b>Follow</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>W</b>.
 * <p></p>
 *
 */
public class FollowSDO extends CoreDataObject implements Serializable, Follow
{
	private static final long serialVersionUID = 1L;
	/** The SDO namespace URI associated with the SDO Type for this class */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/**
	 * Default No-arg constructor required for serialization operations. This method
	 * is NOT intended to be used within application source code.
	 */
	public FollowSDO() {
		super();
	}
	public FollowSDO(commonj.sdo.Type type) {
		super(type);
	}


	/**
	 * Returns true if the <b>source</b> property is set.
	 * @return true if the <b>source</b> property is set.
	 */
	public boolean isSetSource(){
		return super.isSet(Edge.SOURCE);
	}

	/**
	 * Unsets the <b>source</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetSource(){
		super.unset(Edge.SOURCE);
	}

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>source</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Node}.
	 */
	public Node createSource(Class<? extends Node> clss){
		commonj.sdo.Type classType = org.plasma.sdo.helper.PlasmaTypeHelper.INSTANCE.getType(clss);
		return (Node)super.createDataObject(this.getType().getProperty(Edge.SOURCE), classType);
	}

	/**
	 * Returns the value of the <b>source</b> property.
	 * @return the value of the <b>source</b> property.
	 */
	public Node getSource(){
		return (Node)super.get(Edge.SOURCE);
	}

	/**
	 * Sets the value of the <b>source</b> property to the given value.
	 */
	public void setSource(Node value){
		super.set(Edge.SOURCE, value);
	}


	/**
	 * Returns true if the <b>target</b> property is set.
	 * @return true if the <b>target</b> property is set.
	 */
	public boolean isSetTarget(){
		return super.isSet(Edge.TARGET);
	}

	/**
	 * Unsets the <b>target</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetTarget(){
		super.unset(Edge.TARGET);
	}

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Node} automatically establishing a containment relationship through the object's reference property, <b>target</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Node}.
	 */
	public Node createTarget(Class<? extends Node> clss){
		commonj.sdo.Type classType = org.plasma.sdo.helper.PlasmaTypeHelper.INSTANCE.getType(clss);
		return (Node)super.createDataObject(this.getType().getProperty(Edge.TARGET), classType);
	}

	/**
	 * Returns the value of the <b>target</b> property.
	 * @return the value of the <b>target</b> property.
	 */
	public Node getTarget(){
		return (Node)super.get(Edge.TARGET);
	}

	/**
	 * Sets the value of the <b>target</b> property to the given value.
	 */
	public void setTarget(Node value){
		super.set(Edge.TARGET, value);
	}
}