package org.cloudgraph.test.socialgraph.actor.impl;

import java.io.Serializable;
import org.plasma.sdo.core.CoreDataObject;
import java.util.List;
import java.util.ArrayList;
import java.lang.String;
import java.util.Date;
import org.cloudgraph.test.socialgraph.actor.Actor;
import org.cloudgraph.test.socialgraph.actor.Edge;
import org.cloudgraph.test.socialgraph.actor.Media;
import org.cloudgraph.test.socialgraph.actor.Node;
import org.cloudgraph.test.socialgraph.actor.Photo;

/**
 * Generated implementation class representing the domain model entity <b>Photo</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>P</b>.
 * <p></p>
 *
 */
public class PhotoSDO extends CoreDataObject implements Serializable, Photo
{
	private static final long serialVersionUID = 1L;
	/** The SDO namespace URI associated with the SDO Type for this class */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/actor";

	/**
	 * Default No-arg constructor required for serialization operations. This method
	 * is NOT intended to be used within application source code.
	 */
	public PhotoSDO() {
		super();
	}
	public PhotoSDO(commonj.sdo.Type type) {
		super(type);
	}


	/**
	 * Returns true if the <b>actor</b> property is set.
	 * @return true if the <b>actor</b> property is set.
	 */
	public boolean isSetActor(){
		return super.isSet(Photo.ACTOR);
	}

	/**
	 * Unsets the <b>actor</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetActor(){
		super.unset(Photo.ACTOR);
	}

	/**
	 * Creates and returns a new instance of Type {@link Actor} automatically establishing a containment relationship through the object's reference property, <b>actor</b>.
	 * @return a new instance of Type {@link Actor} automatically establishing a containment relationship through the object's reference property <b>actor</b>.
	 */
	public Actor createActor(){
		return (Actor)super.createDataObject(Photo.ACTOR);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Actor</b> set for the object's multi-valued property <b>actor</b>.
	 * @return an array of <b>Actor</b> set for the object's multi-valued property <b>actor</b>.
	 */
	public Actor[] getActor(){
		List<Actor> list = (List<Actor>)super.get(Photo.ACTOR);
		if (list != null) {
			Actor[] array = new Actor[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Actor[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Actor</b> set for the object's multi-valued property <b>actor</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Actor</b> set for the object's multi-valued property <b>actor</b> based on the given index.
	 */
	public Actor getActor(int idx){
		List<Actor> list = (List<Actor>)super.get(Photo.ACTOR);
		if (list != null) {
			return (Actor)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>actor</b>.
	 * @return a count for multi-valued property <b>actor</b>.
	 */
	public int getActorCount(){
		List<Actor> list = (List<Actor>)super.get(Photo.ACTOR);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Actor</b> for the object's multi-valued property <b>actor</b>.
	 * @param value the array value
	 */
	public void setActor(Actor[] value){
		List<Actor> list = (List<Actor>)super.get(Photo.ACTOR);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Actor>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Photo.ACTOR, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetActor() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Actor</b> for the object's multi-valued property <b>actor</b>.
	 * @param value the value to add
	 */
	public void addActor(Actor value){
		List<Actor> list = (List<Actor>)super.get(Photo.ACTOR);
		if (list == null)
			list = new ArrayList<Actor>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Photo.ACTOR, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Actor</b> for the object's multi-valued property <b>actor</b>.
	 * @param value the value to remove
	 */
	public void removeActor(Actor value){
		List<Actor> list = (List<Actor>)super.get(Photo.ACTOR);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Photo.ACTOR, list);
	}


	/**
	 * Returns true if the <b>content</b> property is set.
	 * @return true if the <b>content</b> property is set.
	 */
	public boolean isSetContent(){
		return super.isSet(Photo.CONTENT);
	}

	/**
	 * Unsets the <b>content</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetContent(){
		super.unset(Photo.CONTENT);
	}

	/**
	 * Returns the value of the <b>content</b> property.
	 * @return the value of the <b>content</b> property.
	 */
	public byte[] getContent(){
		return (byte[])super.get(Photo.CONTENT);
	}

	/**
	 * Sets the value of the <b>content</b> property to the given value.
	 */
	public void setContent(byte[] value){
		super.set(Photo.CONTENT, value);
	}


	/**
	 * Returns true if the <b>createdDate</b> property is set.
	 * @return true if the <b>createdDate</b> property is set.
	 */
	public boolean isSetCreatedDate(){
		return super.isSet(Node.CREATED_DATE);
	}

	/**
	 * Unsets the <b>createdDate</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetCreatedDate(){
		super.unset(Node.CREATED_DATE);
	}

	/**
	 * Returns the value of the <b>createdDate</b> property.
	 * @return the value of the <b>createdDate</b> property.
	 */
	public Date getCreatedDate(){
		return (Date)super.get(Node.CREATED_DATE);
	}

	/**
	 * Sets the value of the <b>createdDate</b> property to the given value.
	 */
	public void setCreatedDate(Date value){
		super.set(Node.CREATED_DATE, value);
	}


	/**
	 * Returns true if the <b>description</b> property is set.
	 * @return true if the <b>description</b> property is set.
	 */
	public boolean isSetDescription(){
		return super.isSet(Node.DESCRIPTION);
	}

	/**
	 * Unsets the <b>description</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetDescription(){
		super.unset(Node.DESCRIPTION);
	}

	/**
	 * Returns the value of the <b>description</b> property.
	 * @return the value of the <b>description</b> property.
	 */
	public String getDescription(){
		return (String)super.get(Node.DESCRIPTION);
	}

	/**
	 * Sets the value of the <b>description</b> property to the given value.
	 */
	public void setDescription(String value){
		super.set(Node.DESCRIPTION, value);
	}


	/**
	 * Returns true if the <b>id</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getId() getId} or {@link #setId(String value) setId(...)} for a definition of property <b>id</b>
	 * @return true if the <b>id</b> property is set.
	 */
	public boolean isSetId(){
		return super.isSet(Node.ID);
	}

	/**
	 * Unsets the <b>id</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getId() getId} or {@link #setId(String value) setId(...)} for a definition of property <b>id</b>
	 */
	public void unsetId(){
		super.unset(Node.ID);
	}

	/**
	 * Returns the value of the <b>id</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the id
	 * @return the value of the <b>id</b> property.
	 */
	public String getId(){
		return (String)super.get(Node.ID);
	}

	/**
	 * Sets the value of the <b>id</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the id
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 36</pre>
	 */
	public void setId(String value){
		super.set(Node.ID, value);
	}


	/**
	 * Returns true if the <b>modifiedDate</b> property is set.
	 * @return true if the <b>modifiedDate</b> property is set.
	 */
	public boolean isSetModifiedDate(){
		return super.isSet(Node.MODIFIED_DATE);
	}

	/**
	 * Unsets the <b>modifiedDate</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetModifiedDate(){
		super.unset(Node.MODIFIED_DATE);
	}

	/**
	 * Returns the value of the <b>modifiedDate</b> property.
	 * @return the value of the <b>modifiedDate</b> property.
	 */
	public Date getModifiedDate(){
		return (Date)super.get(Node.MODIFIED_DATE);
	}

	/**
	 * Sets the value of the <b>modifiedDate</b> property to the given value.
	 */
	public void setModifiedDate(Date value){
		super.set(Node.MODIFIED_DATE, value);
	}


	/**
	 * Returns true if the <b>modifiedVersion</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getModifiedVersion() getModifiedVersion} or {@link #setModifiedVersion(long value) setModifiedVersion(...)} for a definition of property <b>modifiedVersion</b>
	 * @return true if the <b>modifiedVersion</b> property is set.
	 */
	public boolean isSetModifiedVersion(){
		return super.isSet(Node.MODIFIED_VERSION);
	}

	/**
	 * Unsets the <b>modifiedVersion</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getModifiedVersion() getModifiedVersion} or {@link #setModifiedVersion(long value) setModifiedVersion(...)} for a definition of property <b>modifiedVersion</b>
	 */
	public void unsetModifiedVersion(){
		super.unset(Node.MODIFIED_VERSION);
	}

	/**
	 * Returns the value of the <b>modifiedVersion</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the version num
	 * @return the value of the <b>modifiedVersion</b> property.
	 */
	public long getModifiedVersion(){
		Long result = (Long)super.get(Node.MODIFIED_VERSION);
		if (result != null)
			return result.longValue();
		else return 0;
	}

	/**
	 * Sets the value of the <b>modifiedVersion</b> property to the given value.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the version num
	 */
	public void setModifiedVersion(long value){
		super.set(Node.MODIFIED_VERSION, value);
	}


	/**
	 * Returns true if the <b>name</b> property is set.
	 * @return true if the <b>name</b> property is set.
	 */
	public boolean isSetName(){
		return super.isSet(Node.NAME);
	}

	/**
	 * Unsets the <b>name</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetName(){
		super.unset(Node.NAME);
	}

	/**
	 * Returns the value of the <b>name</b> property.
	 * @return the value of the <b>name</b> property.
	 */
	public String getName(){
		return (String)super.get(Node.NAME);
	}

	/**
	 * Sets the value of the <b>name</b> property to the given value.
	 * <p></p>
	 * <b>Value Constraints: </b><pre>
	 *     maxLength: 32</pre>
	 */
	public void setName(String value){
		super.set(Node.NAME, value);
	}


	/**
	 * Returns true if the <b>sourceEdge</b> property is set.
	 * @return true if the <b>sourceEdge</b> property is set.
	 */
	public boolean isSetSourceEdge(){
		return super.isSet(Node.SOURCE_EDGE);
	}

	/**
	 * Unsets the <b>sourceEdge</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetSourceEdge(){
		super.unset(Node.SOURCE_EDGE);
	}

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Edge} automatically establishing a containment relationship through the object's reference property, <b>sourceEdge</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Edge}.
	 */
	public Edge createSourceEdge(Class<? extends Edge> clss){
		commonj.sdo.Type classType = org.plasma.sdo.helper.PlasmaTypeHelper.INSTANCE.getType(clss);
		return (Edge)super.createDataObject(this.getType().getProperty(Node.SOURCE_EDGE), classType);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b>.
	 * @return an array of <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b>.
	 */
	public Edge[] getSourceEdge(){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null) {
			Edge[] array = new Edge[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Edge[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Edge</b> set for the object's multi-valued property <b>sourceEdge</b> based on the given index.
	 */
	public Edge getSourceEdge(int idx){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null) {
			return (Edge)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>sourceEdge</b>.
	 * @return a count for multi-valued property <b>sourceEdge</b>.
	 */
	public int getSourceEdgeCount(){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the array value
	 */
	public void setSourceEdge(Edge[] value){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Edge>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Node.SOURCE_EDGE, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetSourceEdge() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the value to add
	 */
	public void addSourceEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list == null)
			list = new ArrayList<Edge>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.SOURCE_EDGE, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Edge</b> for the object's multi-valued property <b>sourceEdge</b>.
	 * @param value the value to remove
	 */
	public void removeSourceEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.SOURCE_EDGE);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.SOURCE_EDGE, list);
	}


	/**
	 * Returns true if the <b>targetEdge</b> property is set.
	 * @return true if the <b>targetEdge</b> property is set.
	 */
	public boolean isSetTargetEdge(){
		return super.isSet(Node.TARGET_EDGE);
	}

	/**
	 * Unsets the <b>targetEdge</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetTargetEdge(){
		super.unset(Node.TARGET_EDGE);
	}

	/**
	 * Creates and returns a new instance of the given subclass Type for abstract base Type {@link Edge} automatically establishing a containment relationship through the object's reference property, <b>targetEdge</b>.
	 * @param clss the subclass Type
	 * Returns a new instance of the given subclass Type for abstract base Type {@link Edge}.
	 */
	public Edge createTargetEdge(Class<? extends Edge> clss){
		commonj.sdo.Type classType = org.plasma.sdo.helper.PlasmaTypeHelper.INSTANCE.getType(clss);
		return (Edge)super.createDataObject(this.getType().getProperty(Node.TARGET_EDGE), classType);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b>.
	 * @return an array of <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b>.
	 */
	public Edge[] getTargetEdge(){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null) {
			Edge[] array = new Edge[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Edge[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Edge</b> set for the object's multi-valued property <b>targetEdge</b> based on the given index.
	 */
	public Edge getTargetEdge(int idx){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null) {
			return (Edge)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>targetEdge</b>.
	 * @return a count for multi-valued property <b>targetEdge</b>.
	 */
	public int getTargetEdgeCount(){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the array value
	 */
	public void setTargetEdge(Edge[] value){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Edge>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(Node.TARGET_EDGE, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetTargetEdge() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the value to add
	 */
	public void addTargetEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list == null)
			list = new ArrayList<Edge>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.TARGET_EDGE, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Edge</b> for the object's multi-valued property <b>targetEdge</b>.
	 * @param value the value to remove
	 */
	public void removeTargetEdge(Edge value){
		List<Edge> list = (List<Edge>)super.get(Node.TARGET_EDGE);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(Node.TARGET_EDGE, list);
	}
}