package org.cloudgraph.test.socialgraph.actor.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;
import org.plasma.query.StringDataProperty;
import org.plasma.query.TemporalDataProperty;
import org.plasma.query.IntegralDataProperty;

import org.cloudgraph.test.socialgraph.actor.Node;

import org.cloudgraph.test.socialgraph.actor.query.QEdge;
import org.cloudgraph.test.socialgraph.actor.query.QPhoto;
import org.cloudgraph.test.socialgraph.story.query.QBlog;
import org.cloudgraph.test.socialgraph.actor.Actor;

/**
 * Represents a person or a group of people. An actor node 
 * has stories to tell and therefore has a story feed. It 
 * has an identity (Avatar and Information). It often uses a 
 * collection of content creation social applications such 
 * as photos, discussions. Following an actor node results into
 * subscribing to all the stories generated by that actor. 
 * A person actor node can also follow you back.
 * <p></p>
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>Actor</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>A</b>.
 *
 */
public class QActor extends DomainRoot
{


	private QActor() {
		super(PlasmaTypeHelper.INSTANCE.getType(Actor.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QActor(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QActor(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Actor</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QActor newQuery() {
		return new QActor();
	}

	/**
	 * Returns a DSL data element for property, <b>age</b>.
	 * @return an Integral DSL data element for property, <b>age</b>.
	 */
	public IntegralDataProperty age() {
		return new DataNode(this, Actor.AGE);
	}

	/**
	 * Returns a DSL query element for reference property, <b>blog</b>.
	 * @return a DSL query element for reference property, <b>blog</b>.
	 */
	public QBlog blog() {
		return new QBlog(this, Actor.BLOG);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>blog</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>blog</b>.
	 */
	public QBlog blog(Expression expr) {
		return new QBlog(this, Actor.BLOG, expr);
	}

	/**
	 * Returns a DSL data element for property, <b>createdDate</b>.
	 * @return a Temporal DSL data element for property, <b>createdDate</b>.
	 */
	public TemporalDataProperty createdDate() {
		return new DataNode(this, Node.CREATED_DATE);
	}

	/**
	 * Returns a DSL data element for property, <b>description</b>.
	 * @return a String DSL data element for property, <b>description</b>.
	 */
	public StringDataProperty description() {
		return new DataNode(this, Node.DESCRIPTION);
	}

	/**
	 * Returns a DSL data element for property, <b>id</b>.
	 * @return a String DSL data element for property, <b>id</b>.
	 */
	public StringDataProperty id() {
		return new DataNode(this, Node.ID);
	}

	/**
	 * Returns a DSL data element for property, <b>iq</b>.
	 * @return an Integral DSL data element for property, <b>iq</b>.
	 */
	public IntegralDataProperty iq() {
		return new DataNode(this, Actor.IQ);
	}

	/**
	 * Returns a DSL data element for property, <b>modifiedDate</b>.
	 * @return a Temporal DSL data element for property, <b>modifiedDate</b>.
	 */
	public TemporalDataProperty modifiedDate() {
		return new DataNode(this, Node.MODIFIED_DATE);
	}

	/**
	 * Returns a DSL data element for property, <b>modifiedVersion</b>.
	 * @return an Integral DSL data element for property, <b>modifiedVersion</b>.
	 */
	public IntegralDataProperty modifiedVersion() {
		return new DataNode(this, Node.MODIFIED_VERSION);
	}

	/**
	 * Returns a DSL data element for property, <b>name</b>.
	 * @return a String DSL data element for property, <b>name</b>.
	 */
	public StringDataProperty name() {
		return new DataNode(this, Node.NAME);
	}

	/**
	 * Returns a DSL query element for reference property, <b>photo</b>.
	 * @return a DSL query element for reference property, <b>photo</b>.
	 */
	public QPhoto photo() {
		return new QPhoto(this, Actor.PHOTO);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>photo</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>photo</b>.
	 */
	public QPhoto photo(Expression expr) {
		return new QPhoto(this, Actor.PHOTO, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>sourceEdge</b>.
	 * @return a DSL query element for reference property, <b>sourceEdge</b>.
	 */
	public QEdge sourceEdge() {
		return new QEdge(this, Node.SOURCE_EDGE);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>sourceEdge</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>sourceEdge</b>.
	 */
	public QEdge sourceEdge(Expression expr) {
		return new QEdge(this, Node.SOURCE_EDGE, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>targetEdge</b>.
	 * @return a DSL query element for reference property, <b>targetEdge</b>.
	 */
	public QEdge targetEdge() {
		return new QEdge(this, Node.TARGET_EDGE);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>targetEdge</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>targetEdge</b>.
	 */
	public QEdge targetEdge(Expression expr) {
		return new QEdge(this, Node.TARGET_EDGE, expr);
	}
}