package org.cloudgraph.test.socialgraph.actor.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;

import org.cloudgraph.test.socialgraph.actor.Edge;

import org.cloudgraph.test.socialgraph.actor.query.QNode;
import org.cloudgraph.test.socialgraph.actor.Lead;

/**
 * A relationship (edge) between 2 nodes where the source is 
 * a leader and the target is a follower.
 * <p></p>
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>Lead</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>L</b>.
 *
 */
public class QLead extends DomainRoot
{


	private QLead() {
		super(PlasmaTypeHelper.INSTANCE.getType(Lead.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QLead(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QLead(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Lead</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QLead newQuery() {
		return new QLead();
	}

	/**
	 * Returns a DSL query element for reference property, <b>source</b>.
	 * @return a DSL query element for reference property, <b>source</b>.
	 */
	public QNode source() {
		return new QNode(this, Edge.SOURCE);
	}

	/**
	 * Returns a DSL query element for reference property, <b>target</b>.
	 * @return a DSL query element for reference property, <b>target</b>.
	 */
	public QNode target() {
		return new QNode(this, Edge.TARGET);
	}
}