package org.cloudgraph.test.socialgraph.story;


import org.cloudgraph.test.socialgraph.actor.Actor;
import org.cloudgraph.test.socialgraph.actor.Node;
import org.cloudgraph.test.socialgraph.actor.Topic;

/**
 * Generated interface representing the domain model entity <b>Blog</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/story</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>B</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Actor Actor
 * @see org.cloudgraph.test.socialgraph.actor.Node Node
 * @see org.cloudgraph.test.socialgraph.actor.Topic Topic
 */
public interface Blog extends Node
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/story";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_BLOG = "Blog";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>actor</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Blog</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.A</b>.
	 */
	public static final String ACTOR = "actor";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>topic</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Blog</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.TC</b>.
	 */
	public static final String TOPIC = "topic";
	
	/**
	 * the likes count for a blog
	 * <p></p>
	 *
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>likes</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Blog</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>B.L</b>.
	 */
	public static final String LIKES = "likes";
	



	/**
	 * Returns true if the <b>actor</b> property is set.
	 * @return true if the <b>actor</b> property is set.
	 */
	public boolean isSetActor();

	/**
	 * Unsets the <b>actor</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetActor();

	/**
	 * Creates and returns a new instance of Type {@link Actor} automatically establishing a containment relationship through the object's reference property, <b>actor</b>.
	 * @return a new instance of Type {@link Actor} automatically establishing a containment relationship through the object's reference property <b>actor</b>.
	 */
	public Actor createActor();

	/**
	 * Returns the value of the <b>actor</b> property.
	 * @return the value of the <b>actor</b> property.
	 */
	public Actor getActor();

	/**
	 * Sets the value of the <b>actor</b> property to the given value.
	 */
	public void setActor(Actor value);


	/**
	 * Returns true if the <b>topic</b> property is set.
	 * @return true if the <b>topic</b> property is set.
	 */
	public boolean isSetTopic();

	/**
	 * Unsets the <b>topic</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetTopic();

	/**
	 * Creates and returns a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property, <b>topic</b>.
	 * @return a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property <b>topic</b>.
	 */
	public Topic createTopic();

	/**
	 * Returns an array of <b>Topic</b> set for the object's multi-valued property <b>topic</b>.
	 * @return an array of <b>Topic</b> set for the object's multi-valued property <b>topic</b>.
	 */
	public Topic[] getTopic();

	/**
	 * Returns the <b>Topic</b> set for the object's multi-valued property <b>topic</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Topic</b> set for the object's multi-valued property <b>topic</b> based on the given index.
	 */
	public Topic getTopic(int idx);

	/**
	 * Returns a count for multi-valued property <b>topic</b>.
	 * @return a count for multi-valued property <b>topic</b>.
	 */
	public int getTopicCount();

	/**
	 * Sets the given array of Type <b>Topic</b> for the object's multi-valued property <b>topic</b>.
	 * @param value the array value
	 */
	public void setTopic(Topic[] value);

	/**
	 * Adds the given value of Type <b>Topic</b> for the object's multi-valued property <b>topic</b>.
	 * @param value the value to add
	 */
	public void addTopic(Topic value);

	/**
	 * Removes the given value of Type <b>Topic</b> for the object's multi-valued property <b>topic</b>.
	 * @param value the value to remove
	 */
	public void removeTopic(Topic value);


	/**
	 * Returns true if the <b>likes</b> property is set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getLikes() getLikes} or {@link #setLikes(long value) setLikes(...)} for a definition of property <b>likes</b>
	 * @return true if the <b>likes</b> property is set.
	 */
	public boolean isSetLikes();

	/**
	 * Unsets the <b>likes</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * See {@link #getLikes() getLikes} or {@link #setLikes(long value) setLikes(...)} for a definition of property <b>likes</b>
	 */
	public void unsetLikes();

	/**
	 * Returns the value of the <b>likes</b> property.
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the likes count for a blog
	 * @return the value of the <b>likes</b> property.
	 */
	public long getLikes();

	/**
	 * Increments the value of the <b>likes</b> property by the given value. 
	 * <p></p>
	 * <b>Property Definition: </b>
	 * the likes count for a blog
	 */
	public void incrementLikes(long value);
}