package org.cloudgraph.test.socialgraph.story;


import org.cloudgraph.test.socialgraph.actor.Node;
import org.cloudgraph.test.socialgraph.actor.Topic;
import org.cloudgraph.test.socialgraph.story.StoryFeed;

/**
 * A specialized  node that contains a snip of message, 
 * information, or news update created by an actor node. 
 * Stories are messages, information, and news updates that are
 * exchanged amongst the nodes in a social network and 
 * propagate around through the graphs (edges) that connect the
 * nodes. The directions to which stories travel are 
 * determined by the directional graphs (edges).
 * <p></p>
 * Generated interface representing the domain model entity <b>Story</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/story</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>S</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.actor.Node Node
 * @see org.cloudgraph.test.socialgraph.actor.Topic Topic
 * @see org.cloudgraph.test.socialgraph.story.StoryFeed StoryFeed
 */
public interface Story extends Node
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/story";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_STORY = "Story";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>storyFeed</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Story</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>S.F</b>.
	 */
	public static final String STORY_FEED = "storyFeed";
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>topic</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Story</b>.
	 *
	 * <p></p>
	 * <b>Data Store Mapping:</b>
	 * Corresponds to the physical data store element <b>S.TC</b>.
	 */
	public static final String TOPIC = "topic";
	



	/**
	 * Returns true if the <b>storyFeed</b> property is set.
	 * @return true if the <b>storyFeed</b> property is set.
	 */
	public boolean isSetStoryFeed();

	/**
	 * Unsets the <b>storyFeed</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetStoryFeed();

	/**
	 * Creates and returns a new instance of Type {@link StoryFeed} automatically establishing a containment relationship through the object's reference property, <b>storyFeed</b>.
	 * @return a new instance of Type {@link StoryFeed} automatically establishing a containment relationship through the object's reference property <b>storyFeed</b>.
	 */
	public StoryFeed createStoryFeed();

	/**
	 * Returns an array of <b>StoryFeed</b> set for the object's multi-valued property <b>storyFeed</b>.
	 * @return an array of <b>StoryFeed</b> set for the object's multi-valued property <b>storyFeed</b>.
	 */
	public StoryFeed[] getStoryFeed();

	/**
	 * Returns the <b>StoryFeed</b> set for the object's multi-valued property <b>storyFeed</b> based on the given index.
	 * @param idx the index
	 * @return the <b>StoryFeed</b> set for the object's multi-valued property <b>storyFeed</b> based on the given index.
	 */
	public StoryFeed getStoryFeed(int idx);

	/**
	 * Returns a count for multi-valued property <b>storyFeed</b>.
	 * @return a count for multi-valued property <b>storyFeed</b>.
	 */
	public int getStoryFeedCount();

	/**
	 * Sets the given array of Type <b>StoryFeed</b> for the object's multi-valued property <b>storyFeed</b>.
	 * @param value the array value
	 */
	public void setStoryFeed(StoryFeed[] value);

	/**
	 * Adds the given value of Type <b>StoryFeed</b> for the object's multi-valued property <b>storyFeed</b>.
	 * @param value the value to add
	 */
	public void addStoryFeed(StoryFeed value);

	/**
	 * Removes the given value of Type <b>StoryFeed</b> for the object's multi-valued property <b>storyFeed</b>.
	 * @param value the value to remove
	 */
	public void removeStoryFeed(StoryFeed value);


	/**
	 * Returns true if the <b>topic</b> property is set.
	 * @return true if the <b>topic</b> property is set.
	 */
	public boolean isSetTopic();

	/**
	 * Unsets the <b>topic</b> property, the value
	 * of the property of the object being set to the property's
	 * default value. The property will no longer be
	 * considered set.
	 */
	public void unsetTopic();

	/**
	 * Creates and returns a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property, <b>topic</b>.
	 * @return a new instance of Type {@link Topic} automatically establishing a containment relationship through the object's reference property <b>topic</b>.
	 */
	public Topic createTopic();

	/**
	 * Returns the value of the <b>topic</b> property.
	 * @return the value of the <b>topic</b> property.
	 */
	public Topic getTopic();

	/**
	 * Sets the value of the <b>topic</b> property to the given value.
	 */
	public void setTopic(Topic value);
}