package org.cloudgraph.test.socialgraph.story;


import org.cloudgraph.test.socialgraph.story.Story;
import org.plasma.sdo.PlasmaDataObject;

/**
 * A list of story nodes created and owned by an actor 
 * (person or group). Following an actor means subscribing 
 * to their story feed
 * <p></p>
 * Generated interface representing the domain model entity <b>StoryFeed</b>. This <a href="http://plasma-sdo.org">SDO</a> interface directly reflects the
 * class (single or multiple) inheritance lattice of the source domain model(s)  and is part of namespace <b>http://cloudgraph.org/test/socialgraph/story</b> defined within the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html">Configuration</a>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>F</b>.
 * <p></p>
 *
 * @see org.cloudgraph.test.socialgraph.story.Story Story
 */
public interface StoryFeed extends PlasmaDataObject
{

	/** The <a href="http://plasma-sdo.org">SDO</a> namespace URI associated with the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> for this class. */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/story";

	/** The entity or <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> logical name associated with this class. */
	public static final String TYPE_NAME_STORY_FEED = "StoryFeed";
	
	
	
	/**
	 * Represents the logical <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html">Property</a> <b>story</b> which is part of the <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>StoryFeed</b>.
	 */
	public static final String STORY = "story";
	



	/**
	 * Returns true if the <b>story</b> property is set.
	 * @return true if the <b>story</b> property is set.
	 */
	public boolean isSetStory();

	/**
	 * Unsets the <b>story</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetStory();

	/**
	 * Creates and returns a new instance of Type {@link Story} automatically establishing a containment relationship through the object's reference property, <b>story</b>.
	 * @return a new instance of Type {@link Story} automatically establishing a containment relationship through the object's reference property <b>story</b>.
	 */
	public Story createStory();

	/**
	 * Returns an array of <b>Story</b> set for the object's multi-valued property <b>story</b>.
	 * @return an array of <b>Story</b> set for the object's multi-valued property <b>story</b>.
	 */
	public Story[] getStory();

	/**
	 * Returns the <b>Story</b> set for the object's multi-valued property <b>story</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Story</b> set for the object's multi-valued property <b>story</b> based on the given index.
	 */
	public Story getStory(int idx);

	/**
	 * Returns a count for multi-valued property <b>story</b>.
	 * @return a count for multi-valued property <b>story</b>.
	 */
	public int getStoryCount();

	/**
	 * Sets the given array of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the array value
	 */
	public void setStory(Story[] value);

	/**
	 * Adds the given value of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the value to add
	 */
	public void addStory(Story value);

	/**
	 * Removes the given value of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the value to remove
	 */
	public void removeStory(Story value);
}