package org.cloudgraph.test.socialgraph.story.impl;

import java.io.Serializable;
import org.plasma.sdo.core.CoreDataObject;
import java.util.List;
import java.util.ArrayList;
import org.cloudgraph.test.socialgraph.story.Story;
import org.cloudgraph.test.socialgraph.story.StoryFeed;

/**
 * A list of story nodes created and owned by an actor 
 * (person or group). Following an actor means subscribing 
 * to their story feed
 * <p></p>
 * Generated implementation class representing the domain model entity <b>StoryFeed</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>F</b>.
 * <p></p>
 *
 */
public class StoryFeedSDO extends CoreDataObject implements Serializable, StoryFeed
{
	private static final long serialVersionUID = 1L;
	/** The SDO namespace URI associated with the SDO Type for this class */
	public static final String NAMESPACE_URI = "http://cloudgraph.org/test/socialgraph/story";

	/**
	 * Default No-arg constructor required for serialization operations. This method
	 * is NOT intended to be used within application source code.
	 */
	public StoryFeedSDO() {
		super();
	}
	public StoryFeedSDO(commonj.sdo.Type type) {
		super(type);
	}


	/**
	 * Returns true if the <b>story</b> property is set.
	 * @return true if the <b>story</b> property is set.
	 */
	public boolean isSetStory(){
		return super.isSet(StoryFeed.STORY);
	}

	/**
	 * Unsets the <b>story</b> property, clearing the underlying collection. The property will no longer be
	 * considered set.
	 */
	public void unsetStory(){
		super.unset(StoryFeed.STORY);
	}

	/**
	 * Creates and returns a new instance of Type {@link Story} automatically establishing a containment relationship through the object's reference property, <b>story</b>.
	 * @return a new instance of Type {@link Story} automatically establishing a containment relationship through the object's reference property <b>story</b>.
	 */
	public Story createStory(){
		return (Story)super.createDataObject(StoryFeed.STORY);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns an array of <b>Story</b> set for the object's multi-valued property <b>story</b>.
	 * @return an array of <b>Story</b> set for the object's multi-valued property <b>story</b>.
	 */
	public Story[] getStory(){
		List<Story> list = (List<Story>)super.get(StoryFeed.STORY);
		if (list != null) {
			Story[] array = new Story[list.size()];
			for (int i = 0; i < list.size(); i++)
				array[i] = list.get(i);
			return array;
		}
		else
			return new Story[0];
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns the <b>Story</b> set for the object's multi-valued property <b>story</b> based on the given index.
	 * @param idx the index
	 * @return the <b>Story</b> set for the object's multi-valued property <b>story</b> based on the given index.
	 */
	public Story getStory(int idx){
		List<Story> list = (List<Story>)super.get(StoryFeed.STORY);
		if (list != null) {
			return (Story)list.get(idx);
		}
		else
			throw new ArrayIndexOutOfBoundsException(idx);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Returns a count for multi-valued property <b>story</b>.
	 * @return a count for multi-valued property <b>story</b>.
	 */
	public int getStoryCount(){
		List<Story> list = (List<Story>)super.get(StoryFeed.STORY);
		if (list != null) {
			return list.size();
		}
		else
			return 0;
	}

	@SuppressWarnings("unchecked")
	/**
	 * Sets the given array of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the array value
	 */
	public void setStory(Story[] value){
		List<Story> list = (List<Story>)super.get(StoryFeed.STORY);
		if (value != null && value.length > 0) {
			if (list == null)
				list = new ArrayList<Story>();
			for (int i = 0; i < value.length; i++)
				list.add(value[i]);
			super.set(StoryFeed.STORY, list);
		}
		else
			throw new IllegalArgumentException("expected non-null and non-zero length array argument 'value' - use unsetStory() method to remove this property");
	}

	@SuppressWarnings("unchecked")
	/**
	 * Adds the given value of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the value to add
	 */
	public void addStory(Story value){
		List<Story> list = (List<Story>)super.get(StoryFeed.STORY);
		if (list == null)
			list = new ArrayList<Story>();
				list.add(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(StoryFeed.STORY, list);
	}

	@SuppressWarnings("unchecked")
	/**
	 * Removes the given value of Type <b>Story</b> for the object's multi-valued property <b>story</b>.
	 * @param value the value to remove
	 */
	public void removeStory(Story value){
		List<Story> list = (List<Story>)super.get(StoryFeed.STORY);
		if (list != null)
				list.remove(value);
		// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation
		super.setList(StoryFeed.STORY, list);
	}
}