package org.cloudgraph.test.socialgraph.story.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;
import org.plasma.query.StringDataProperty;
import org.plasma.query.TemporalDataProperty;
import org.plasma.query.IntegralDataProperty;

import org.cloudgraph.test.socialgraph.actor.Node;

import org.cloudgraph.test.socialgraph.actor.query.QActor;
import org.cloudgraph.test.socialgraph.actor.query.QEdge;
import org.cloudgraph.test.socialgraph.actor.query.QTopic;
import org.cloudgraph.test.socialgraph.story.Blog;

/**
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>Blog</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>B</b>.
 *
 */
public class QBlog extends DomainRoot
{


	private QBlog() {
		super(PlasmaTypeHelper.INSTANCE.getType(Blog.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QBlog(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QBlog(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Blog</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QBlog newQuery() {
		return new QBlog();
	}

	/**
	 * Returns a DSL query element for reference property, <b>actor</b>.
	 * @return a DSL query element for reference property, <b>actor</b>.
	 */
	public QActor actor() {
		return new QActor(this, Blog.ACTOR);
	}

	/**
	 * Returns a DSL data element for property, <b>createdDate</b>.
	 * @return a Temporal DSL data element for property, <b>createdDate</b>.
	 */
	public TemporalDataProperty createdDate() {
		return new DataNode(this, Node.CREATED_DATE);
	}

	/**
	 * Returns a DSL data element for property, <b>description</b>.
	 * @return a String DSL data element for property, <b>description</b>.
	 */
	public StringDataProperty description() {
		return new DataNode(this, Node.DESCRIPTION);
	}

	/**
	 * Returns a DSL data element for property, <b>id</b>.
	 * @return a String DSL data element for property, <b>id</b>.
	 */
	public StringDataProperty id() {
		return new DataNode(this, Node.ID);
	}

	/**
	 * Returns a DSL data element for property, <b>likes</b>.
	 * @return an Integral DSL data element for property, <b>likes</b>.
	 */
	public IntegralDataProperty likes() {
		return new DataNode(this, Blog.LIKES);
	}

	/**
	 * Returns a DSL data element for property, <b>modifiedDate</b>.
	 * @return a Temporal DSL data element for property, <b>modifiedDate</b>.
	 */
	public TemporalDataProperty modifiedDate() {
		return new DataNode(this, Node.MODIFIED_DATE);
	}

	/**
	 * Returns a DSL data element for property, <b>modifiedVersion</b>.
	 * @return an Integral DSL data element for property, <b>modifiedVersion</b>.
	 */
	public IntegralDataProperty modifiedVersion() {
		return new DataNode(this, Node.MODIFIED_VERSION);
	}

	/**
	 * Returns a DSL data element for property, <b>name</b>.
	 * @return a String DSL data element for property, <b>name</b>.
	 */
	public StringDataProperty name() {
		return new DataNode(this, Node.NAME);
	}

	/**
	 * Returns a DSL query element for reference property, <b>sourceEdge</b>.
	 * @return a DSL query element for reference property, <b>sourceEdge</b>.
	 */
	public QEdge sourceEdge() {
		return new QEdge(this, Node.SOURCE_EDGE);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>sourceEdge</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>sourceEdge</b>.
	 */
	public QEdge sourceEdge(Expression expr) {
		return new QEdge(this, Node.SOURCE_EDGE, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>targetEdge</b>.
	 * @return a DSL query element for reference property, <b>targetEdge</b>.
	 */
	public QEdge targetEdge() {
		return new QEdge(this, Node.TARGET_EDGE);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>targetEdge</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>targetEdge</b>.
	 */
	public QEdge targetEdge(Expression expr) {
		return new QEdge(this, Node.TARGET_EDGE, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>topic</b>.
	 * @return a DSL query element for reference property, <b>topic</b>.
	 */
	public QTopic topic() {
		return new QTopic(this, Blog.TOPIC);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>topic</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>topic</b>.
	 */
	public QTopic topic(Expression expr) {
		return new QTopic(this, Blog.TOPIC, expr);
	}
}