package org.cloudgraph.test.socialgraph.story.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;
import org.plasma.query.StringDataProperty;
import org.plasma.query.TemporalDataProperty;
import org.plasma.query.IntegralDataProperty;

import org.cloudgraph.test.socialgraph.actor.Node;

import org.cloudgraph.test.socialgraph.actor.query.QEdge;
import org.cloudgraph.test.socialgraph.actor.query.QTopic;
import org.cloudgraph.test.socialgraph.story.query.QStoryFeed;
import org.cloudgraph.test.socialgraph.story.Story;

/**
 * A specialized  node that contains a snip of message, 
 * information, or news update created by an actor node. 
 * Stories are messages, information, and news updates that are
 * exchanged amongst the nodes in a social network and 
 * propagate around through the graphs (edges) that connect the
 * nodes. The directions to which stories travel are 
 * determined by the directional graphs (edges).
 * <p></p>
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>Story</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>S</b>.
 *
 */
public class QStory extends DomainRoot
{


	private QStory() {
		super(PlasmaTypeHelper.INSTANCE.getType(Story.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QStory(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QStory(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>Story</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QStory newQuery() {
		return new QStory();
	}

	/**
	 * Returns a DSL data element for property, <b>createdDate</b>.
	 * @return a Temporal DSL data element for property, <b>createdDate</b>.
	 */
	public TemporalDataProperty createdDate() {
		return new DataNode(this, Node.CREATED_DATE);
	}

	/**
	 * Returns a DSL data element for property, <b>description</b>.
	 * @return a String DSL data element for property, <b>description</b>.
	 */
	public StringDataProperty description() {
		return new DataNode(this, Node.DESCRIPTION);
	}

	/**
	 * Returns a DSL data element for property, <b>id</b>.
	 * @return a String DSL data element for property, <b>id</b>.
	 */
	public StringDataProperty id() {
		return new DataNode(this, Node.ID);
	}

	/**
	 * Returns a DSL data element for property, <b>modifiedDate</b>.
	 * @return a Temporal DSL data element for property, <b>modifiedDate</b>.
	 */
	public TemporalDataProperty modifiedDate() {
		return new DataNode(this, Node.MODIFIED_DATE);
	}

	/**
	 * Returns a DSL data element for property, <b>modifiedVersion</b>.
	 * @return an Integral DSL data element for property, <b>modifiedVersion</b>.
	 */
	public IntegralDataProperty modifiedVersion() {
		return new DataNode(this, Node.MODIFIED_VERSION);
	}

	/**
	 * Returns a DSL data element for property, <b>name</b>.
	 * @return a String DSL data element for property, <b>name</b>.
	 */
	public StringDataProperty name() {
		return new DataNode(this, Node.NAME);
	}

	/**
	 * Returns a DSL query element for reference property, <b>sourceEdge</b>.
	 * @return a DSL query element for reference property, <b>sourceEdge</b>.
	 */
	public QEdge sourceEdge() {
		return new QEdge(this, Node.SOURCE_EDGE);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>sourceEdge</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>sourceEdge</b>.
	 */
	public QEdge sourceEdge(Expression expr) {
		return new QEdge(this, Node.SOURCE_EDGE, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>storyFeed</b>.
	 * @return a DSL query element for reference property, <b>storyFeed</b>.
	 */
	public QStoryFeed storyFeed() {
		return new QStoryFeed(this, Story.STORY_FEED);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>storyFeed</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>storyFeed</b>.
	 */
	public QStoryFeed storyFeed(Expression expr) {
		return new QStoryFeed(this, Story.STORY_FEED, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>targetEdge</b>.
	 * @return a DSL query element for reference property, <b>targetEdge</b>.
	 */
	public QEdge targetEdge() {
		return new QEdge(this, Node.TARGET_EDGE);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>targetEdge</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>targetEdge</b>.
	 */
	public QEdge targetEdge(Expression expr) {
		return new QEdge(this, Node.TARGET_EDGE, expr);
	}

	/**
	 * Returns a DSL query element for reference property, <b>topic</b>.
	 * @return a DSL query element for reference property, <b>topic</b>.
	 */
	public QTopic topic() {
		return new QTopic(this, Story.TOPIC);
	}
}