package org.cloudgraph.test.socialgraph.story.query;

import org.plasma.sdo.helper.PlasmaTypeHelper;

import org.plasma.query.dsl.DomainRoot;
import org.plasma.query.dsl.PathNode;
import org.plasma.query.dsl.DataNode;
import org.plasma.query.Expression;


import org.cloudgraph.test.socialgraph.story.query.QStory;
import org.cloudgraph.test.socialgraph.story.StoryFeed;

/**
 * A list of story nodes created and owned by an actor 
 * (person or group). Following an actor means subscribing 
 * to their story feed
 * <p></p>
 * Generated Domain Specific Language (DSL) implementation class representing the domain model entity <b>StoryFeed</b>.
 *
 * <p></p>
 * <b>Data Store Mapping:</b>
 * Corresponds to the physical data store entity <b>F</b>.
 *
 */
public class QStoryFeed extends DomainRoot
{


	private QStoryFeed() {
		super(PlasmaTypeHelper.INSTANCE.getType(StoryFeed.class));
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 */
	public QStoryFeed(PathNode source, String sourceProperty) {
		super(source, sourceProperty);
	}
	
	/**
	 * Constructor which instantiates a domain query path node. A path may
	 * span multiple namespaces and therefore Java inplementation packages
	 * based on the <a href="http://docs.plasma-sdo.org/api/org/plasma/config/PlasmaConfiguration.html">Condiguration</a>.
	 * Note: while this constructor is public, it is not for application use!
	 * @param source the source path node
	 * @param sourceProperty the source property logical name
	 * @param expr the path predicate expression
	 */
	public QStoryFeed(PathNode source, String sourceProperty, Expression expr) {
		super(source, sourceProperty, expr);
	}

	/**
	 * Returns a new DSL query for <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html">Type</a> <b>StoryFeed</b> which can be used either as a query root or
	 * as the start (entry point) for a new path predicate expression.
	 * @return a new DSL query
	 */
	public static QStoryFeed newQuery() {
		return new QStoryFeed();
	}

	/**
	 * Returns a DSL query element for reference property, <b>story</b>.
	 * @return a DSL query element for reference property, <b>story</b>.
	 */
	public QStory story() {
		return new QStory(this, StoryFeed.STORY);
	}
	
	/**
	 * Returns a DSL query element for reference property, <b>story</b>, while adding the given path predicate expression. 
	 * Path predicate expressions are used to restrict
	 * the query results for a collection property within a <a href="http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaDataGraph.html">DataGraph</a>.
	 * @param expr the path predicate expression
	 * @return a DSL query element for reference property, <b>story</b>.
	 */
	public QStory story(Expression expr) {
		return new QStory(this, StoryFeed.STORY, expr);
	}
}