/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.core.ChangeableId;
import org.cloudbus.cloudsim.core.CloudInformationService;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.SimulationNull;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudbus.cloudsim.vms.VmGroup;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public interface Simulation {
    public static final Predicate<SimEvent> ANY_EVT = evt -> true;
    public static final Simulation NULL = new SimulationNull();

    public boolean isTerminationTimeSet();

    public void abort();

    public void addEntity(CloudSimEntity var1);

    public SimEvent cancel(SimEntity var1, Predicate<SimEvent> var2);

    public boolean cancelAll(SimEntity var1, Predicate<SimEvent> var2);

    public double clock();

    public String clockStr();

    public double clockInMinutes();

    public double clockInHours();

    public SimEvent findFirstDeferred(SimEntity var1, Predicate<SimEvent> var2);

    public Calendar getCalendar();

    public CloudInformationService getCloudInfoService();

    public List<SimEntity> getEntityList();

    public double getMinTimeBetweenEvents();

    public int getNumEntities();

    public boolean removeOnEventProcessingListener(EventListener<SimEvent> var1);

    public Simulation addOnSimulationPauseListener(EventListener<EventInfo> var1);

    public Simulation addOnSimulationStartListener(EventListener<EventInfo> var1);

    public boolean removeOnSimulationPauseListener(EventListener<EventInfo> var1);

    public Simulation addOnEventProcessingListener(EventListener<SimEvent> var1);

    public Simulation addOnClockTickListener(EventListener<EventInfo> var1);

    public boolean removeOnClockTickListener(EventListener<? extends EventInfo> var1);

    public void pauseEntity(SimEntity var1, double var2);

    public boolean isPaused();

    public boolean pause();

    public boolean pause(double var1);

    public boolean resume();

    public boolean isRunning();

    public SimEvent select(SimEntity var1, Predicate<SimEvent> var2);

    public void send(SimEvent var1);

    public void send(SimEntity var1, SimEntity var2, double var3, int var5, Object var6);

    public void sendFirst(SimEvent var1);

    public void sendFirst(SimEntity var1, SimEntity var2, double var3, int var5, Object var6);

    public void sendNow(SimEntity var1, SimEntity var2, int var3, Object var4);

    public double runFor(double var1);

    public double start();

    public void startSync();

    public boolean isTimeToTerminateSimulationUnderRequest();

    public boolean terminate();

    public boolean terminateAt(double var1);

    public void wait(CloudSimEntity var1, Predicate<SimEvent> var2);

    public NetworkTopology getNetworkTopology();

    public void setNetworkTopology(NetworkTopology var1);

    public static <T extends ChangeableId> T setIdForEntitiesWithoutOne(List<? extends T> list) {
        return Simulation.setIdForEntitiesWithoutOne(list, null);
    }

    public static <T extends ChangeableId> T setIdForEntitiesWithoutOne(List<? extends T> list, T lastEntity) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return lastEntity;
        }
        long id = lastEntity == null ? ((ChangeableId)list.get(list.size() - 1)).getId() : lastEntity.getId();
        id = Math.max(id, -1L);
        Object entity = lastEntity;
        for (int i = 0; i < list.size(); ++i) {
            entity = (ChangeableId)list.get(i);
            if (entity.getId() < 0L) {
                entity.setId(++id);
            }
            if (!(entity instanceof VmGroup)) continue;
            entity = Simulation.setIdForEntitiesWithoutOne(((VmGroup)entity).getVmList(), entity);
            id = entity.getId();
        }
        return (T)entity;
    }

    public long getNumberOfFutureEvents(Predicate<SimEvent> var1);

    public boolean isThereAnyFutureEvt(Predicate<SimEvent> var1);

    public double getLastCloudletProcessingUpdate();

    public void setLastCloudletProcessingUpdate(double var1);
}

