/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.core.AbstractMachine;
import org.cloudbus.cloudsim.core.Identifiable;
import org.cloudbus.cloudsim.core.ResourceStatsComputer;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostStateHistoryEntry;
import org.cloudbus.cloudsim.hosts.HostSuitability;
import org.cloudbus.cloudsim.power.models.PowerModelHost;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.provisioners.ResourceProvisionerSimple;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.resources.HarddriveStorage;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.schedulers.MipsShare;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerSpaceShared;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudbus.cloudsim.vms.HostResourceStats;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmGroup;
import org.cloudbus.cloudsim.vms.VmSimple;
import org.cloudbus.cloudsim.vms.VmStateHistoryEntry;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;

public class HostSimple
implements Host {
    private static long defaultRamCapacity = (long)Conversion.gigaToMega(10.0);
    private static long defaultBwCapacity = 1000L;
    private static long defaultStorageCapacity = (long)Conversion.gigaToMega(500.0);
    private final List<HostStateHistoryEntry> stateHistory;
    private PowerModelHost powerModel;
    private long id;
    private boolean failed;
    private boolean active;
    private boolean activationChangeInProgress;
    private boolean stateHistoryEnabled;
    private double startTime = -1.0;
    private double firstStartTime = -1.0;
    private double shutdownTime;
    private double totalUpTime;
    private double lastBusyTime;
    private double idleShutdownDeadline;
    private final Ram ram;
    private final Bandwidth bw;
    private final HarddriveStorage disk;
    private ResourceProvisioner ramProvisioner;
    private ResourceProvisioner bwProvisioner;
    private VmScheduler vmScheduler;
    private final List<Vm> vmList = new ArrayList<Vm>();
    private List<Pe> peList;
    private final Set<Vm> vmsMigratingIn;
    private final Set<Vm> vmsMigratingOut;
    private Datacenter datacenter;
    private final Set<EventListener<HostUpdatesVmsProcessingEventInfo>> onUpdateProcessingListeners;
    private final Set<EventListener<HostEventInfo>> onStartupListeners;
    private final Set<EventListener<HostEventInfo>> onShutdownListeners;
    private Simulation simulation;
    private List<ResourceManageable> resources;
    private List<ResourceProvisioner> provisioners;
    private final List<Vm> vmCreatedList;
    private int freePesNumber;
    private int failedPesNumber;
    private boolean lazySuitabilityEvaluation;
    protected HostResourceStats cpuUtilizationStats;

    public HostSimple(List<Pe> peList) {
        this(peList, true);
    }

    public HostSimple(List<Pe> peList, boolean activate) {
        this(defaultRamCapacity, defaultBwCapacity, defaultStorageCapacity, peList, activate);
    }

    public HostSimple(ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setPeList(peList);
    }

    public HostSimple(long ram, long bw, long storage, List<Pe> peList) {
        this(ram, bw, new HarddriveStorage(storage), peList);
    }

    public HostSimple(long ram, long bw, HarddriveStorage storage, List<Pe> peList) {
        this(ram, bw, storage, peList, true);
    }

    public HostSimple(long ram, long bw, long storage, List<Pe> peList, boolean activate) {
        this(ram, bw, new HarddriveStorage(storage), peList, activate);
    }

    private HostSimple(long ram, long bw, HarddriveStorage storage, List<Pe> peList, boolean activate) {
        this.setId(-1L);
        this.setSimulation(Simulation.NULL);
        this.idleShutdownDeadline = -1.0;
        this.lazySuitabilityEvaluation = true;
        this.ram = new Ram(ram);
        this.bw = new Bandwidth(bw);
        this.disk = Objects.requireNonNull(storage);
        this.setRamProvisioner(new ResourceProvisionerSimple());
        this.setBwProvisioner(new ResourceProvisionerSimple());
        this.setVmScheduler(new VmSchedulerSpaceShared());
        this.setPeList(peList);
        this.setFailed(false);
        this.shutdownTime = -1.0;
        this.setDatacenter(Datacenter.NULL);
        this.onUpdateProcessingListeners = new HashSet<EventListener<HostUpdatesVmsProcessingEventInfo>>();
        this.onStartupListeners = new HashSet<EventListener<HostEventInfo>>();
        this.onShutdownListeners = new HashSet<EventListener<HostEventInfo>>();
        this.cpuUtilizationStats = HostResourceStats.NULL;
        this.resources = new ArrayList<ResourceManageable>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.provisioners = new ArrayList<ResourceProvisioner>();
        this.vmsMigratingIn = new HashSet<Vm>();
        this.vmsMigratingOut = new HashSet<Vm>();
        this.powerModel = PowerModelHost.NULL;
        this.stateHistory = new LinkedList<HostStateHistoryEntry>();
        this.setActive(activate);
    }

    public static long getDefaultRamCapacity() {
        return defaultRamCapacity;
    }

    public static void setDefaultRamCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultRamCapacity = defaultCapacity;
    }

    public static long getDefaultBwCapacity() {
        return defaultBwCapacity;
    }

    public static void setDefaultBwCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultBwCapacity = defaultCapacity;
    }

    public static long getDefaultStorageCapacity() {
        return defaultStorageCapacity;
    }

    public static void setDefaultStorageCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultStorageCapacity = defaultCapacity;
    }

    @Override
    public double updateProcessing(double currentTime) {
        if (this.vmList.isEmpty() && this.isIdleEnough(this.idleShutdownDeadline)) {
            this.setActive(false);
        }
        double nextSimulationDelay = Double.MAX_VALUE;
        for (int i = 0; i < this.vmList.size(); ++i) {
            Vm vm = this.vmList.get(i);
            double delay = vm.updateProcessing(currentTime, this.vmScheduler.getAllocatedMips(vm));
            nextSimulationDelay = delay > 0.0 ? Math.min(delay, nextSimulationDelay) : nextSimulationDelay;
        }
        this.notifyOnUpdateProcessingListeners(currentTime);
        this.cpuUtilizationStats.add(currentTime);
        this.addStateHistory(currentTime);
        if (!this.vmList.isEmpty()) {
            this.lastBusyTime = currentTime;
        }
        return nextSimulationDelay;
    }

    private void notifyOnUpdateProcessingListeners(double nextSimulationTime) {
        this.onUpdateProcessingListeners.forEach(l -> l.update(HostUpdatesVmsProcessingEventInfo.of(l, this, nextSimulationTime)));
    }

    @Override
    public HostSuitability createVm(Vm vm) {
        HostSuitability suitability = this.createVmInternal(vm);
        if (suitability.fully()) {
            this.addVmToCreatedList(vm);
            vm.setHost(this);
            vm.setCreated(true);
            vm.notifyOnHostAllocationListeners();
            vm.setStartTime(this.getSimulation().clock());
        }
        return suitability;
    }

    @Override
    public HostSuitability createTemporaryVm(Vm vm) {
        return this.createVmInternal(vm);
    }

    private HostSuitability createVmInternal(Vm vm) {
        if (vm instanceof VmGroup) {
            return new HostSuitability("Just internal VMs inside a VmGroup can be created, not the VmGroup itself.");
        }
        HostSuitability suitability = this.allocateResourcesForVm(vm, false);
        if (suitability.fully()) {
            this.vmList.add(vm);
        }
        return suitability;
    }

    private HostSuitability allocateResourcesForVm(Vm vm, boolean inMigration) {
        HostSuitability suitability = this.isSuitableForVm(vm, inMigration, true);
        if (!suitability.fully()) {
            return suitability;
        }
        vm.setInMigration(inMigration);
        this.allocateResourcesForVm(vm);
        return suitability;
    }

    private void allocateResourcesForVm(Vm vm) {
        this.ramProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedRam());
        this.bwProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedBw());
        this.disk.getStorage().allocateResource(vm.getStorage());
        this.vmScheduler.allocatePesForVm(vm, vm.getCurrentRequestedMips());
    }

    private void logAllocationError(boolean showFailureLog, Vm vm, boolean inMigration, String resourceUnit, Resource pmResource, Resource vmRequestedResource) {
        if (!showFailureLog) {
            return;
        }
        String migration = inMigration ? "VM Migration" : "VM Creation";
        String msg = pmResource.getAvailableResource() > 0L ? "just " + pmResource.getAvailableResource() + " " + resourceUnit : "no amount";
        LOGGER.error("{}: {}: [{}] Allocation of {} to {} failed due to lack of {}. Required {} but there is {} available.", new Object[]{this.simulation.clockStr(), this.getClass().getSimpleName(), migration, vm, this, pmResource.getClass().getSimpleName(), vmRequestedResource.getCapacity(), msg});
    }

    @Override
    public void reallocateMigratingInVms() {
        for (Vm vm : this.getVmsMigratingIn()) {
            if (!this.vmList.contains(vm)) {
                this.vmList.add(vm);
            }
            this.allocateResourcesForVm(vm);
        }
    }

    @Override
    public boolean isSuitableForVm(Vm vm) {
        return this.getSuitabilityFor(vm).fully();
    }

    @Override
    public HostSuitability getSuitabilityFor(Vm vm) {
        return this.isSuitableForVm(vm, false, false);
    }

    private HostSuitability isSuitableForVm(Vm vm, boolean inMigration, boolean showFailureLog) {
        HostSuitability suitability = new HostSuitability();
        suitability.setForStorage(this.disk.isAmountAvailable(vm.getStorage()));
        if (!suitability.forStorage()) {
            this.logAllocationError(showFailureLog, vm, inMigration, "MB", this.getStorage(), vm.getStorage());
            if (this.lazySuitabilityEvaluation) {
                return suitability;
            }
        }
        suitability.setForRam(this.ramProvisioner.isSuitableForVm(vm, vm.getRam()));
        if (!suitability.forRam()) {
            this.logAllocationError(showFailureLog, vm, inMigration, "MB", this.getRam(), vm.getRam());
            if (this.lazySuitabilityEvaluation) {
                return suitability;
            }
        }
        suitability.setForBw(this.bwProvisioner.isSuitableForVm(vm, vm.getBw()));
        if (!suitability.forBw()) {
            this.logAllocationError(showFailureLog, vm, inMigration, "Mbps", this.getBw(), vm.getBw());
            if (this.lazySuitabilityEvaluation) {
                return suitability;
            }
        }
        return suitability.setForPes(this.vmScheduler.isSuitableForVm(vm));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean hasEverStarted() {
        return this.firstStartTime > -1.0;
    }

    @Override
    public final Host setActive(boolean activate) {
        double delay;
        double d = delay = activate ? this.powerModel.getStartupDelay() : this.powerModel.getShutDownDelay();
        if (this.active == activate || delay > 0.0 && this.activationChangeInProgress) {
            return this;
        }
        if (this.isFailed() && activate) {
            throw new IllegalStateException("The Host is failed and cannot be activated.");
        }
        if (delay == 0.0) {
            this.processHostActivation(activate);
            return this;
        }
        int tag = activate ? 71 : 72;
        String msg = (activate ? "on" : "off") + " (expected time: {} seconds).";
        LOGGER.info("{}: {} is being powered " + msg, new Object[]{this.getSimulation().clockStr(), this, delay});
        this.datacenter.schedule(delay, tag, this);
        this.activationChangeInProgress = true;
        return this;
    }

    public final void processHostActivation(boolean activate) {
        boolean wasActive = this.active;
        if (activate) {
            this.setStartTime(this.getSimulation().clock());
        } else {
            this.setShutdownTime(this.getSimulation().clock());
        }
        this.active = activate;
        this.activationChangeInProgress = false;
        this.notifyStartupOrShutdown(activate, wasActive);
    }

    private void notifyStartupOrShutdown(boolean activate, boolean wasActive) {
        if (this.simulation == null || !this.simulation.isRunning()) {
            return;
        }
        if (activate && !wasActive) {
            LOGGER.info("{}: {} is powered on.", (Object)this.getSimulation().clockStr(), (Object)this);
            this.onStartupListeners.forEach(l -> l.update(HostEventInfo.of(l, this, this.simulation.clock())));
        } else if (!activate && wasActive) {
            String reason = this.isIdleEnough(this.idleShutdownDeadline) ? " after becoming idle" : "";
            LOGGER.info("{}: {} is powered off{}.", new Object[]{this.getSimulation().clockStr(), this, reason});
            this.onShutdownListeners.forEach(l -> l.update(HostEventInfo.of(l, this, this.simulation.clock())));
        }
    }

    @Override
    public void destroyVm(Vm vm) {
        if (!vm.isCreated()) {
            return;
        }
        this.destroyVmInternal(vm);
        vm.notifyOnHostDeallocationListeners(this);
        vm.setStopTime(this.getSimulation().clock());
    }

    @Override
    public void destroyTemporaryVm(Vm vm) {
        this.destroyVmInternal(vm);
    }

    private void destroyVmInternal(Vm vm) {
        this.deallocateResourcesOfVm(Objects.requireNonNull(vm));
        this.vmList.remove(vm);
        vm.getBroker().getVmExecList().remove(vm);
    }

    protected void deallocateResourcesOfVm(Vm vm) {
        vm.setCreated(false);
        this.ramProvisioner.deallocateResourceForVm(vm);
        this.bwProvisioner.deallocateResourceForVm(vm);
        this.vmScheduler.deallocatePesFromVm(vm);
        this.disk.getStorage().deallocateResource(vm.getStorage());
    }

    @Override
    public void destroyAllVms() {
        this.deallocateResourcesOfAllVms();
        for (Vm vm : this.vmList) {
            vm.setCreated(false);
            this.disk.getStorage().deallocateResource(vm.getStorage());
        }
        this.vmList.clear();
    }

    @Override
    public Host addOnStartupListener(EventListener<HostEventInfo> listener) {
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.onStartupListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnStartupListener(EventListener<HostEventInfo> listener) {
        return this.onStartupListeners.remove(listener);
    }

    @Override
    public Host addOnShutdownListener(EventListener<HostEventInfo> listener) {
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.onShutdownListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnShutdownListener(EventListener<HostEventInfo> listener) {
        return this.onShutdownListeners.remove(listener);
    }

    protected void deallocateResourcesOfAllVms() {
        this.ramProvisioner.deallocateResourceForAllVms();
        this.bwProvisioner.deallocateResourceForAllVms();
        this.vmScheduler.deallocatePesForAllVms();
    }

    @Override
    public long getNumberOfPes() {
        return this.peList.size();
    }

    protected MipsShare getAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getAllocatedMips(vm);
    }

    @Override
    public double getMips() {
        return this.peList.stream().mapToDouble(Pe::getCapacity).findFirst().orElse(0.0);
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.peList.stream().filter(Pe::isWorking).mapToDouble(Pe::getCapacity).sum();
    }

    @Override
    public double getTotalAvailableMips() {
        return this.vmScheduler.getTotalAvailableMips();
    }

    @Override
    public double getTotalAllocatedMips() {
        return this.getTotalMipsCapacity() - this.getTotalAvailableMips();
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getTotalAllocatedMipsForVm(vm);
    }

    @Override
    public Resource getBw() {
        return this.bwProvisioner.getResource();
    }

    @Override
    public Resource getRam() {
        return this.ramProvisioner.getResource();
    }

    @Override
    public FileStorage getStorage() {
        return this.disk;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public final void setId(long id) {
        this.id = id;
    }

    @Override
    public ResourceProvisioner getRamProvisioner() {
        return this.ramProvisioner;
    }

    @Override
    public final Host setRamProvisioner(ResourceProvisioner ramProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("RAM");
        this.ramProvisioner = Objects.requireNonNull(ramProvisioner);
        this.ramProvisioner.setResource(this.ram);
        return this;
    }

    private void checkSimulationIsRunningAndAttemptedToChangeHost(String resourceName) {
        if (this.simulation.isRunning()) {
            throw new IllegalStateException("It is not allowed to change a Host's " + resourceName + " after the simulation started.");
        }
    }

    @Override
    public ResourceProvisioner getBwProvisioner() {
        return this.bwProvisioner;
    }

    @Override
    public final Host setBwProvisioner(ResourceProvisioner bwProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("BW");
        this.bwProvisioner = Objects.requireNonNull(bwProvisioner);
        this.bwProvisioner.setResource(this.bw);
        return this;
    }

    @Override
    public VmScheduler getVmScheduler() {
        return this.vmScheduler;
    }

    @Override
    public final Host setVmScheduler(VmScheduler vmScheduler) {
        this.vmScheduler = Objects.requireNonNull(vmScheduler);
        vmScheduler.setHost(this);
        return this;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public double getFirstStartTime() {
        return this.firstStartTime;
    }

    @Override
    public Host setStartTime(double startTime) {
        if (startTime < 0.0) {
            throw new IllegalArgumentException("Host start time cannot be negative");
        }
        this.startTime = Math.floor(startTime);
        if (this.firstStartTime == -1.0) {
            this.firstStartTime = this.startTime;
        }
        this.lastBusyTime = startTime;
        this.shutdownTime = -1.0;
        return this;
    }

    @Override
    public double getShutdownTime() {
        return this.shutdownTime;
    }

    @Override
    public void setShutdownTime(double shutdownTime) {
        if (shutdownTime < 0.0) {
            throw new IllegalArgumentException("Host shutdown time cannot be negative");
        }
        this.shutdownTime = Math.floor(shutdownTime);
        this.totalUpTime += this.getUpTime();
    }

    @Override
    public double getUpTime() {
        return this.active ? this.simulation.clock() - this.startTime : this.shutdownTime - this.startTime;
    }

    @Override
    public double getTotalUpTime() {
        return this.totalUpTime + (this.active ? this.getUpTime() : 0.0);
    }

    @Override
    public double getUpTimeHours() {
        return TimeUtil.secondsToHours(this.getUpTime());
    }

    @Override
    public double getTotalUpTimeHours() {
        return TimeUtil.secondsToHours(this.getTotalUpTime());
    }

    @Override
    public double getIdleShutdownDeadline() {
        return this.idleShutdownDeadline;
    }

    @Override
    public Host setIdleShutdownDeadline(double deadline) {
        this.idleShutdownDeadline = deadline;
        return this;
    }

    @Override
    public List<Pe> getPeList() {
        return this.peList;
    }

    private void setPeList(List<Pe> peList) {
        Objects.requireNonNull(peList);
        this.checkSimulationIsRunningAndAttemptedToChangeHost("List of PE");
        this.peList = peList;
        long peId = this.peList.stream().filter(pe -> pe.getId() > 0L).mapToLong(Identifiable::getId).max().orElse(-1L);
        List pesWithoutIds = this.peList.stream().filter(pe -> pe.getId() < 0L).collect(Collectors.toList());
        for (Pe pe2 : pesWithoutIds) {
            pe2.setId(++peId);
        }
        this.failedPesNumber = 0;
        this.setPeStatus(peList, Pe.Status.FREE);
        this.freePesNumber = peList.size();
    }

    @Override
    public <T extends Vm> List<T> getVmList() {
        return Collections.unmodifiableList(this.vmList);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return Collections.unmodifiableList(this.vmCreatedList);
    }

    protected void addVmToList(Vm vm) {
        this.vmList.add(Objects.requireNonNull(vm));
    }

    protected void addVmToCreatedList(Vm vm) {
        this.vmCreatedList.add(Objects.requireNonNull(vm));
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public final boolean setFailed(boolean failed) {
        this.failed = failed;
        Pe.Status newStatus = failed ? Pe.Status.FAILED : Pe.Status.FREE;
        this.setPeStatus(this.peList, newStatus);
        if (failed && this.active) {
            this.active = false;
        }
        return true;
    }

    public final void setPeStatus(List<Pe> peList, Pe.Status newStatus) {
        for (Pe pe : peList) {
            this.updatePeStatus(pe, newStatus);
        }
    }

    private void updatePeStatus(Pe pe, Pe.Status newStatus) {
        if (pe.getStatus() != newStatus) {
            this.updateFailedAndFreePesNumber(pe.getStatus(), false);
            this.updateFailedAndFreePesNumber(newStatus, true);
            pe.setStatus(newStatus);
        }
    }

    private void updateFailedAndFreePesNumber(Pe.Status newStatus, boolean increment) {
        int i = increment ? 1 : -1;
        switch (newStatus) {
            case FAILED: {
                this.failedPesNumber += i;
                break;
            }
            case FREE: {
                this.freePesNumber += i;
            }
        }
    }

    @Override
    public <T extends Vm> Set<T> getVmsMigratingIn() {
        return this.vmsMigratingIn;
    }

    @Override
    public boolean hasMigratingVms() {
        return !this.vmsMigratingIn.isEmpty() || !this.vmsMigratingOut.isEmpty();
    }

    @Override
    public boolean addMigratingInVm(Vm vm) {
        if (this.vmsMigratingIn.contains(vm)) {
            return false;
        }
        this.vmsMigratingIn.add(vm);
        if (!this.allocateResourcesForVm(vm, true).fully()) {
            this.vmsMigratingIn.remove(vm);
            return false;
        }
        ((VmSimple)vm).updateMigrationStartListeners(this);
        this.updateProcessing(this.simulation.clock());
        vm.getHost().updateProcessing(this.simulation.clock());
        return true;
    }

    @Override
    public void removeMigratingInVm(Vm vm) {
        this.vmsMigratingIn.remove(vm);
        this.vmList.remove(vm);
        vm.setInMigration(false);
    }

    @Override
    public Set<Vm> getVmsMigratingOut() {
        return Collections.unmodifiableSet(this.vmsMigratingOut);
    }

    @Override
    public boolean addVmMigratingOut(Vm vm) {
        return this.vmsMigratingOut.add(vm);
    }

    @Override
    public boolean removeVmMigratingOut(Vm vm) {
        return this.vmsMigratingOut.remove(vm);
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final void setDatacenter(Datacenter datacenter) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("Datacenter");
        this.datacenter = datacenter;
    }

    public String toString() {
        String dc = this.datacenter == null || Datacenter.NULL.equals(this.datacenter) ? "" : String.format("/DC %d", this.datacenter.getId());
        return String.format("Host %d%s", this.getId(), dc);
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Host addOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        if (EventListener.NULL.equals(listener)) {
            return this;
        }
        this.onUpdateProcessingListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public long getAvailableStorage() {
        return this.disk.getAvailableResource();
    }

    @Override
    public int getFreePesNumber() {
        return this.freePesNumber;
    }

    @Override
    public int getWorkingPesNumber() {
        return this.peList.size() - this.getFailedPesNumber();
    }

    @Override
    public int getBusyPesNumber() {
        return this.getWorkingPesNumber() - this.getFreePesNumber();
    }

    @Override
    public double getBusyPesPercent() {
        return (double)this.getBusyPesNumber() / (double)this.getNumberOfPes();
    }

    @Override
    public double getBusyPesPercent(boolean hundredScale) {
        double scale = hundredScale ? 100.0 : 1.0;
        return this.getBusyPesPercent() * scale;
    }

    @Override
    public int getFailedPesNumber() {
        return this.failedPesNumber;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public double getLastBusyTime() {
        return this.lastBusyTime;
    }

    @Override
    public final Host setSimulation(Simulation simulation) {
        this.simulation = simulation;
        return this;
    }

    @Override
    public int compareTo(Host o) {
        return Double.compare(this.getTotalMipsCapacity(), o.getTotalMipsCapacity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostSimple that = (HostSimple)o;
        if (this.id != that.id) {
            return false;
        }
        return this.simulation.equals(that.simulation);
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = 31 * result + this.simulation.hashCode();
        return result;
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.simulation.isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ramProvisioner.getResource(), this.bwProvisioner.getResource());
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public ResourceProvisioner getProvisioner(Class<? extends ResourceManageable> resourceClass) {
        if (this.simulation.isRunning() && this.provisioners.isEmpty()) {
            this.provisioners = Arrays.asList(this.ramProvisioner, this.bwProvisioner);
        }
        return this.provisioners.stream().filter(provisioner -> provisioner.getResource().isSubClassOf(resourceClass)).findFirst().orElse(ResourceProvisioner.NULL);
    }

    @Override
    public List<Pe> getWorkingPeList() {
        return this.getFilteredPeList(Pe::isWorking);
    }

    @Override
    public List<Pe> getBusyPeList() {
        return this.getFilteredPeList(Pe::isBusy);
    }

    @Override
    public List<Pe> getFreePeList() {
        return this.getFilteredPeList(Pe::isFree);
    }

    private List<Pe> getFilteredPeList(Predicate<Pe> status) {
        return this.peList.stream().filter(status).collect(Collectors.toList());
    }

    @Override
    public double getCpuPercentUtilization() {
        return this.computeCpuUtilizationPercent(this.getCpuMipsUtilization());
    }

    @Override
    public double getCpuPercentRequested() {
        return this.computeCpuUtilizationPercent(this.getCpuMipsRequested());
    }

    private double computeCpuUtilizationPercent(double mipsUsage) {
        double totalMips = this.getTotalMipsCapacity();
        if (totalMips == 0.0) {
            return 0.0;
        }
        double utilization = mipsUsage / totalMips;
        return utilization > 1.0 && utilization < 1.01 ? 1.0 : utilization;
    }

    @Override
    public double getCpuMipsUtilization() {
        return this.vmList.stream().mapToDouble(Vm::getTotalCpuMipsUtilization).sum();
    }

    private double getCpuMipsRequested() {
        return this.vmList.stream().mapToDouble(Vm::getTotalCpuMipsRequested).sum();
    }

    @Override
    public long getRamUtilization() {
        return this.ramProvisioner.getTotalAllocatedResource();
    }

    @Override
    public long getBwUtilization() {
        return this.bwProvisioner.getTotalAllocatedResource();
    }

    @Override
    public HostResourceStats getCpuUtilizationStats() {
        return this.cpuUtilizationStats;
    }

    @Override
    public void enableUtilizationStats() {
        if (this.cpuUtilizationStats != null && this.cpuUtilizationStats != HostResourceStats.NULL) {
            return;
        }
        this.cpuUtilizationStats = new HostResourceStats(this, Host::getCpuPercentUtilization);
        if (this.vmList.isEmpty()) {
            String host = this.getId() > -1L ? this.toString() : "Host";
            LOGGER.info("Automatically enabling computation of utilization statistics for VMs on {} could not be performed because it doesn't have VMs yet. You need to enable it for each VM created.", (Object)host);
        } else {
            this.vmList.forEach(ResourceStatsComputer::enableUtilizationStats);
        }
    }

    @Override
    public PowerModelHost getPowerModel() {
        return this.powerModel;
    }

    @Override
    public final void setPowerModel(PowerModelHost powerModel) {
        Objects.requireNonNull(powerModel, "powerModel cannot be null. You could provide a " + PowerModelHost.class.getSimpleName() + ".NULL instead.");
        if (powerModel.getHost() != null && powerModel.getHost() != Host.NULL && !this.equals(powerModel.getHost())) {
            throw new IllegalStateException("The given PowerModel is already assigned to another Host. Each Host must have its own PowerModel instance.");
        }
        this.powerModel = powerModel;
        powerModel.setHost(this);
    }

    @Override
    public void enableStateHistory() {
        this.stateHistoryEnabled = true;
    }

    @Override
    public void disableStateHistory() {
        this.stateHistoryEnabled = false;
    }

    @Override
    public boolean isStateHistoryEnabled() {
        return this.stateHistoryEnabled;
    }

    @Override
    public List<Vm> getFinishedVms() {
        return this.getVmList().stream().filter(vm -> !vm.isInMigration()).filter(vm -> vm.getTotalCpuMipsRequested() == 0.0).collect(Collectors.toList());
    }

    private double addVmResourceUseToHistoryIfNotMigratingIn(Vm vm, double currentTime) {
        double totalAllocatedMips = this.getVmScheduler().getTotalAllocatedMipsForVm(vm);
        if (this.getVmsMigratingIn().contains(vm)) {
            LOGGER.info("{}: {}: {} is migrating in", new Object[]{this.getSimulation().clockStr(), this, vm});
            return totalAllocatedMips;
        }
        double totalRequestedMips = vm.getTotalCpuMipsRequested();
        if (totalAllocatedMips + 0.1 < totalRequestedMips) {
            String reason = this.getVmsMigratingOut().contains(vm) ? "migration overhead" : "capacity unavailability";
            long notAllocatedMipsByPe = (long)((totalRequestedMips - totalAllocatedMips) / (double)vm.getNumberOfPes());
            LOGGER.warn("{}: {}: {} MIPS not allocated for each one of the {} PEs from {} due to {}.", new Object[]{this.getSimulation().clockStr(), this, notAllocatedMipsByPe, vm.getNumberOfPes(), vm, reason});
        }
        VmStateHistoryEntry entry = new VmStateHistoryEntry(currentTime, totalAllocatedMips, totalRequestedMips, vm.isInMigration() && !this.getVmsMigratingIn().contains(vm));
        vm.addStateHistoryEntry(entry);
        if (vm.isInMigration()) {
            LOGGER.info("{}: {}: {} is migrating out ", new Object[]{this.getSimulation().clockStr(), this, vm});
            totalAllocatedMips /= this.getVmScheduler().getMaxCpuUsagePercentDuringOutMigration();
        }
        return totalAllocatedMips;
    }

    private void addStateHistory(double currentTime) {
        if (!this.stateHistoryEnabled) {
            return;
        }
        double hostTotalRequestedMips = 0.0;
        for (Vm vm : this.getVmList()) {
            double totalRequestedMips = vm.getTotalCpuMipsRequested();
            this.addVmResourceUseToHistoryIfNotMigratingIn(vm, currentTime);
            hostTotalRequestedMips += totalRequestedMips;
        }
        this.addStateHistoryEntry(currentTime, this.getCpuMipsUtilization(), hostTotalRequestedMips, this.active);
    }

    private void addStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean isActive) {
        HostStateHistoryEntry previousState;
        HostStateHistoryEntry newState = new HostStateHistoryEntry(time, allocatedMips, requestedMips, isActive);
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).getTime() == time) {
            this.stateHistory.set(this.stateHistory.size() - 1, newState);
            return;
        }
        this.stateHistory.add(newState);
    }

    @Override
    public List<HostStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    @Override
    public List<Vm> getMigratableVms() {
        return this.vmList.stream().filter(vm -> !vm.isInMigration()).collect(Collectors.toList());
    }

    @Override
    public boolean isLazySuitabilityEvaluation() {
        return this.lazySuitabilityEvaluation;
    }

    @Override
    public Host setLazySuitabilityEvaluation(boolean lazySuitabilityEvaluation) {
        this.lazySuitabilityEvaluation = lazySuitabilityEvaluation;
        return this;
    }
}

