/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

import java.util.Objects;

public final class HostSuitability {
    public static final HostSuitability NULL = new HostSuitability();
    private boolean forStorage;
    private boolean forRam;
    private boolean forBw;
    private boolean forPes;
    private String reason;

    public HostSuitability() {
    }

    public HostSuitability(String reason) {
        this.reason = Objects.requireNonNull(reason);
    }

    public void setSuitability(HostSuitability other) {
        this.forPes = this.forPes && other.forPes;
        this.forRam = this.forRam && other.forRam;
        this.forBw = this.forBw && other.forBw;
        this.forStorage = this.forStorage && other.forStorage;
    }

    public boolean forStorage() {
        return this.forStorage;
    }

    HostSuitability setForStorage(boolean suitable) {
        this.forStorage = suitable;
        return this;
    }

    public boolean forRam() {
        return this.forRam;
    }

    HostSuitability setForRam(boolean suitable) {
        this.forRam = suitable;
        return this;
    }

    public boolean forBw() {
        return this.forBw;
    }

    HostSuitability setForBw(boolean suitable) {
        this.forBw = suitable;
        return this;
    }

    public boolean forPes() {
        return this.forPes;
    }

    HostSuitability setForPes(boolean forPes) {
        this.forPes = forPes;
        return this;
    }

    public boolean fully() {
        return this.forStorage && this.forRam && this.forBw && this.forPes;
    }

    public String toString() {
        if (this.fully()) {
            return "Host is fully suitable for the last requested VM";
        }
        if (this.reason != null) {
            return this.reason;
        }
        String msg = "lack of";
        if (!this.forPes) {
            msg = msg + " PEs,";
        }
        if (!this.forRam) {
            msg = msg + " RAM,";
        }
        if (!this.forStorage) {
            msg = msg + " Storage,";
        }
        if (!this.forBw) {
            msg = msg + " BW,";
        }
        return msg.substring(0, msg.length() - 1);
    }
}

