/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts.network;

import java.util.ArrayList;
import java.util.List;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.hosts.HostSuitability;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.VmPacket;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.CloudletTaskScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.CloudletTaskSchedulerSimple;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkHost
extends HostSimple {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)NetworkHost.class.getSimpleName());
    private int totalDataTransferBytes;
    private final List<HostPacket> pktsToSendForLocalVms;
    private final List<HostPacket> pktsToSendForExternalVms;
    private final List<HostPacket> hostPktsReceived = new ArrayList<HostPacket>();
    private EdgeSwitch edgeSwitch;

    public NetworkHost(long ram, long bw, long storage, List<Pe> peList) {
        super(ram, bw, storage, peList);
        this.pktsToSendForExternalVms = new ArrayList<HostPacket>();
        this.pktsToSendForLocalVms = new ArrayList<HostPacket>();
    }

    @Override
    public double updateProcessing(double currentTime) {
        double timeOfNextFinishingCloudlet = super.updateProcessing(currentTime);
        this.receivePackets();
        this.sendAllPacketListsOfAllVms();
        return timeOfNextFinishingCloudlet;
    }

    private void receivePackets() {
        for (HostPacket hostPkt : this.hostPktsReceived) {
            this.receivePacket(hostPkt.getVmPacket());
        }
        this.hostPktsReceived.clear();
    }

    private void receivePacket(VmPacket vmPacket) {
        Vm destinationVm = this.receiveVmPacket(vmPacket);
        if (this.getVmList().contains(destinationVm)) {
            CloudletTaskScheduler taskScheduler = this.getVmPacketScheduler(destinationVm);
            taskScheduler.addPacketToListOfPacketsSentFromVm(vmPacket);
            LOGGER.trace("{}: {}: {} received pkt with {} bytes from {} in {} and forwarded it to {} in {}", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), this, vmPacket.getSize(), vmPacket.getSenderCloudlet(), vmPacket.getSource(), vmPacket.getReceiverCloudlet(), vmPacket.getDestination()});
        } else {
            LOGGER.warn("{}: {}: Destination {} was not found inside {}", new Object[]{this.getSimulation().clockStr(), this.getClass(), vmPacket.getDestination(), this});
        }
    }

    private Vm receiveVmPacket(VmPacket vmPacket) {
        vmPacket.setReceiveTime(this.getSimulation().clock());
        return vmPacket.getDestination();
    }

    private void sendAllPacketListsOfAllVms() {
        this.getVmList().forEach(this::collectListOfPacketsToSendFromVm);
        this.sendPacketsToLocalVms();
        this.sendPacketsToExternalVms();
    }

    private void sendPacketsToLocalVms() {
        for (HostPacket hostPkt : this.pktsToSendForLocalVms) {
            hostPkt.setSendTime(hostPkt.getReceiveTime());
            Vm destinationVm = this.receiveVmPacket(hostPkt.getVmPacket());
            this.getVmPacketScheduler(destinationVm).addPacketToListOfPacketsSentFromVm(hostPkt.getVmPacket());
        }
        if (!this.pktsToSendForLocalVms.isEmpty()) {
            for (Vm vm : this.getVmList()) {
                vm.updateProcessing(this.getVmScheduler().getAllocatedMips(vm));
            }
        }
        this.pktsToSendForLocalVms.clear();
    }

    private void sendPacketsToExternalVms() {
        for (HostPacket pkt : this.pktsToSendForExternalVms) {
            double delay = this.edgeSwitch.downlinkTransferDelay(pkt, this.pktsToSendForExternalVms.size());
            this.totalDataTransferBytes = (int)((long)this.totalDataTransferBytes + pkt.getSize());
            this.getSimulation().send(this.getDatacenter(), this.getEdgeSwitch(), delay, 43, pkt);
        }
        this.pktsToSendForExternalVms.clear();
    }

    private CloudletTaskScheduler getVmPacketScheduler(Vm vm) {
        return vm.getCloudletScheduler().getTaskScheduler();
    }

    @Override
    public HostSuitability createVm(Vm vm) {
        HostSuitability suitability = super.createVm(vm);
        this.setPacketScheduler(vm);
        return suitability;
    }

    private void setPacketScheduler(Vm vm) {
        CloudletScheduler scheduler = vm.getCloudletScheduler();
        if (!scheduler.isThereTaskScheduler()) {
            scheduler.setTaskScheduler(new CloudletTaskSchedulerSimple());
        }
    }

    private void collectListOfPacketsToSendFromVm(Vm sourceVm) {
        CloudletTaskScheduler taskScheduler = this.getVmPacketScheduler(sourceVm);
        for (VmPacket vmPkt : taskScheduler.getVmPacketsToSend()) {
            this.collectPacketToSendFromVm(vmPkt);
        }
        taskScheduler.clearVmPacketsToSend();
    }

    private void collectPacketToSendFromVm(VmPacket vmPkt) {
        HostPacket hostPkt = new HostPacket(this, vmPkt);
        Vm receiverVm = vmPkt.getDestination();
        List<HostPacket> pktsToSend = this.getVmList().contains(receiverVm) ? this.pktsToSendForLocalVms : this.pktsToSendForExternalVms;
        pktsToSend.add(hostPkt);
    }

    public int getTotalDataTransferBytes() {
        return this.totalDataTransferBytes;
    }

    public void addReceivedNetworkPacket(HostPacket hostPacket) {
        this.hostPktsReceived.add(hostPacket);
    }

    public EdgeSwitch getEdgeSwitch() {
        return this.edgeSwitch;
    }

    public void setEdgeSwitch(EdgeSwitch edgeSwitch) {
        this.edgeSwitch = edgeSwitch;
    }
}

