/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.power.PowerAware;
import org.cloudbus.cloudsim.power.PowerMeasurement;
import org.cloudbus.cloudsim.power.models.PowerModel;

public class PowerMeter
extends CloudSimEntity {
    private final Supplier<List<? extends PowerAware<? extends PowerModel>>> powerAwareEntitiesSupplier;
    private double measurementInterval = 1.0;
    private final List<PowerMeasurement> powerMeasurements = new LinkedList<PowerMeasurement>();

    public PowerMeter(Simulation simulation, PowerAware<? extends PowerModel> powerAwareEntity) {
        this(simulation, Arrays.asList(powerAwareEntity));
    }

    public PowerMeter(Simulation simulation, List<? extends PowerAware<? extends PowerModel>> powerAwareEntities) {
        this(simulation, () -> powerAwareEntities);
    }

    public PowerMeter(Simulation simulation, Supplier<List<? extends PowerAware<? extends PowerModel>>> powerAwareEntitiesSupplier) {
        super(simulation);
        this.powerAwareEntitiesSupplier = Objects.requireNonNull(powerAwareEntitiesSupplier, "powerAwareEntitiesSupplier cannot be null");
    }

    @Override
    protected void startInternal() {
        this.schedule(70);
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case 70: {
                this.measurePowerConsumption();
                this.scheduleMeasurement();
                break;
            }
            case -1: {
                this.shutdown();
                break;
            }
            default: {
                throw new RuntimeException("Unknown Event: " + evt);
            }
        }
    }

    private void measurePowerConsumption() {
        List<? extends PowerAware<? extends PowerModel>> powerAwareEntities = this.powerAwareEntitiesSupplier.get();
        PowerMeasurement measurement = powerAwareEntities.stream().map(PowerAware::getPowerModel).map(PowerModel::getPowerMeasurement).reduce(PowerMeasurement::add).orElse(new PowerMeasurement());
        this.powerMeasurements.add(measurement);
    }

    private void scheduleMeasurement() {
        if (this.getSimulation().isThereAnyFutureEvt(evt -> evt.getTag() != 70)) {
            this.schedule(this.measurementInterval, 70);
        }
    }

    @Override
    public PowerMeter setName(String name) {
        super.setName(name);
        return this;
    }

    public List<PowerMeasurement> getPowerMeasurements() {
        return this.powerMeasurements;
    }

    public double getMeasurementInterval() {
        return this.measurementInterval;
    }

    public PowerMeter setMeasurementInterval(double measurementInterval) {
        if (measurementInterval <= 0.0) {
            throw new IllegalArgumentException("measurementInterval must be a positive number.");
        }
        this.measurementInterval = measurementInterval;
        return this;
    }
}

