/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.HashMap;
import java.util.Map;
import org.cloudbus.cloudsim.schedulers.MipsShare;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerTimeShared;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSchedulerTimeSharedOverSubscription
extends VmSchedulerTimeShared {
    public VmSchedulerTimeSharedOverSubscription() {
        this(0.1);
    }

    public VmSchedulerTimeSharedOverSubscription(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, MipsShare requestedMips) {
        return (long)this.getHost().getWorkingPesNumber() >= requestedMips.pes();
    }

    @Override
    protected void allocateMipsShareForVm(Vm vm, MipsShare requestedMipsReduced) {
        if (requestedMipsReduced.isEmpty()) {
            return;
        }
        double totalRequestedMips = requestedMipsReduced.totalMips();
        if (this.getTotalAvailableMips() >= totalRequestedMips) {
            super.allocateMipsShareForVm(vm, requestedMipsReduced);
            return;
        }
        this.redistributeMipsDueToOverSubscription();
    }

    private void redistributeMipsDueToOverSubscription() {
        Map<Vm, MipsShare> mipsMapRequestedReduced = this.getNewTotalRequestedMipsByAllVms();
        double scalingFactor = this.getVmsMipsScalingFactor(mipsMapRequestedReduced);
        this.getAllocatedMipsMap().clear();
        for (Map.Entry<Vm, MipsShare> entry : mipsMapRequestedReduced.entrySet()) {
            Vm vm = entry.getKey();
            MipsShare updatedMipsAllocation = this.getMipsShareToAllocate(vm, entry.getValue());
            updatedMipsAllocation = this.getMipsShareToAllocate(updatedMipsAllocation, scalingFactor);
            this.putAllocatedMipsMap(vm, updatedMipsAllocation);
        }
    }

    private double getVmsMipsScalingFactor(Map<Vm, MipsShare> mipsMapRequestedReduced) {
        double totalMipsCapacity = this.getHost().getTotalMipsCapacity();
        double totalMipsToAllocateForAllVms = this.getTotalMipsToAllocateForAllVms(mipsMapRequestedReduced);
        return Math.min(1.0, totalMipsCapacity / totalMipsToAllocateForAllVms);
    }

    private Map<Vm, MipsShare> getNewTotalRequestedMipsByAllVms() {
        HashMap<Vm, MipsShare> mipsMapRequestedReduced = new HashMap<Vm, MipsShare>(this.getRequestedMipsMap().entrySet().size());
        for (Map.Entry<Vm, MipsShare> entry : this.getRequestedMipsMap().entrySet()) {
            Vm vm = entry.getKey();
            MipsShare requestedMipsReduced = this.getMipsShareRequestedReduced(entry.getKey(), entry.getValue());
            mipsMapRequestedReduced.put(vm, requestedMipsReduced);
        }
        return mipsMapRequestedReduced;
    }

    private double getTotalMipsToAllocateForAllVms(Map<Vm, MipsShare> mipsMapRequestedReduced) {
        return mipsMapRequestedReduced.entrySet().stream().mapToDouble(this::getMipsToBeAllocatedForVmPes).sum();
    }

    private double getMipsToBeAllocatedForVmPes(Map.Entry<Vm, MipsShare> entry) {
        double vmTotalRequiredMips = entry.getValue().totalMips();
        if (this.getHost().getVmsMigratingIn().contains(entry.getKey())) {
            return vmTotalRequiredMips * this.getVmMigrationCpuOverhead();
        }
        return vmTotalRequiredMips;
    }
}

