/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.listeners;

import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.HostSuitability;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;

public interface DatacenterVmMigrationEventInfo
extends VmDatacenterEventInfo {
    @Override
    public Vm getVm();

    public boolean isMigrationSuccessful();

    public HostSuitability getHostSuitability();

    public static DatacenterVmMigrationEventInfo of(final EventListener<DatacenterVmMigrationEventInfo> listener, final Vm vm, final HostSuitability suitability) {
        final double time = vm.getSimulation().clock();
        return new DatacenterVmMigrationEventInfo(){

            @Override
            public Datacenter getDatacenter() {
                return vm.getHost().getDatacenter();
            }

            @Override
            public Vm getVm() {
                return vm;
            }

            @Override
            public boolean isMigrationSuccessful() {
                return suitability.fully();
            }

            @Override
            public double getTime() {
                return time;
            }

            @Override
            public HostSuitability getHostSuitability() {
                return suitability;
            }

            public EventListener<DatacenterVmMigrationEventInfo> getListener() {
                return listener;
            }
        };
    }
}

