/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.listeners;

import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostEventInfo;
import org.cloudsimplus.listeners.VmEventInfo;

public interface VmHostEventInfo
extends VmEventInfo,
HostEventInfo {
    public static VmHostEventInfo of(EventListener<VmHostEventInfo> listener, Vm vm) {
        return VmHostEventInfo.of(listener, vm, vm.getHost());
    }

    public static VmHostEventInfo of(final EventListener<VmHostEventInfo> listener, final Vm vm, final Host host) {
        final double time = vm.getSimulation().clock();
        return new VmHostEventInfo(){

            @Override
            public Host getHost() {
                return host;
            }

            @Override
            public Vm getVm() {
                return vm;
            }

            @Override
            public double getTime() {
                return time;
            }

            public EventListener<VmHostEventInfo> getListener() {
                return listener;
            }
        };
    }
}

