/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.testbeds;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.StatisticalDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudbus.cloudsim.util.Util;
import org.cloudsimplus.testbeds.AbstractExperiment;
import org.cloudsimplus.testbeds.Experiment;

public abstract class ExperimentRunner<T extends Experiment>
extends AbstractExperiment {
    public static final double CONFIDENCE_LEVEL = 0.95;
    private final boolean parallel;
    private boolean showProgress;
    private boolean progressBarInNewLine;
    private int firstExperimentCreated = -1;
    private final long baseSeed;
    private final List<Long> seeds;
    private int simulationRuns;
    private AtomicInteger finishedRuns;
    private long experimentsStartTimeSecs;
    private long experimentsExecutionTimeSecs;
    private final boolean applyAntitheticVariatesTechnique;
    private int batchesNumber;
    private final Map<String, List<Double>> metricsMap;
    private String description;
    private String resultsTableId;
    private boolean latexTableResultsGeneration;
    private List<Experiment> experiments;

    protected ExperimentRunner(long baseSeed, int simulationRuns) {
        this(baseSeed, simulationRuns, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, boolean latexTableResultsGeneration, boolean parallel) {
        this(baseSeed, simulationRuns, 0, false, parallel, latexTableResultsGeneration);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, boolean antitheticVariatesTechnique) {
        this(baseSeed, simulationRuns, 0, antitheticVariatesTechnique, false, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, int batchesNumber, boolean antitheticVariatesTechnique) {
        this(baseSeed, simulationRuns, batchesNumber, antitheticVariatesTechnique, false, false);
    }

    protected ExperimentRunner(long baseSeed, int simulationRuns, int batchesNumber, boolean antitheticVariatesTechnique, boolean parallel, boolean latexTableResultsGeneration) {
        this.baseSeed = baseSeed;
        this.applyAntitheticVariatesTechnique = antitheticVariatesTechnique;
        if (simulationRuns <= 0) {
            throw new IllegalArgumentException("Simulation runs must be greater than 0.");
        }
        this.simulationRuns = simulationRuns;
        this.finishedRuns = new AtomicInteger();
        this.parallel = parallel && simulationRuns > 1;
        this.showProgress = true;
        if (batchesNumber < 0 || batchesNumber == 1) {
            throw new IllegalArgumentException("Batches number must be greater than 1. Use 0 just to disable the Batch Means method.");
        }
        this.batchesNumber = batchesNumber;
        this.latexTableResultsGeneration = latexTableResultsGeneration;
        this.seeds = parallel ? Collections.synchronizedList(new ArrayList()) : new ArrayList();
        Map<Object, Object> map = this.metricsMap = parallel ? Collections.synchronizedMap(new TreeMap()) : new TreeMap();
        if (this.isApplyBatchMeansMethod() || this.isApplyAntitheticVariatesTechnique()) {
            this.setSimulationRunsAndBatchesToEvenNumber();
        }
        if (this.isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches()) {
            this.setNumberOfSimulationRunsAsMultipleOfNumberOfBatches();
        }
    }

    private void setSimulationRunsAndBatchesToEvenNumber() {
        if (this.getSimulationRuns() % 2 != 0) {
            ++this.simulationRuns;
        }
        if (this.getBatchesNumber() > 0 && this.getSimulationRuns() % this.getBatchesNumber() != 0) {
            this.setSimulationRunsAsMultipleOfBatchNumber();
        }
    }

    private void setNumberOfSimulationRunsAsMultipleOfNumberOfBatches() {
        this.simulationRuns = this.batchSizeCeil() * this.getBatchesNumber();
    }

    private boolean isApplyBatchMeansAndSimulationRunsIsNotMultipleOfBatches() {
        return this.isApplyBatchMeansMethod() && this.getSimulationRuns() % this.getBatchesNumber() != 0;
    }

    public int batchSizeCeil() {
        return (int)Math.ceil((double)this.simulationRuns / (double)this.batchesNumber);
    }

    public boolean isApplyBatchMeansMethod() {
        boolean batchesGreaterThan1 = this.batchesNumber > 1;
        boolean numSimulationRunsGraterThanBatches = this.simulationRuns > this.batchesNumber;
        return batchesGreaterThan1 && numSimulationRunsGraterThanBatches;
    }

    protected List<Double> computeBatchMeans(List<Double> samples) {
        if (!this.isApplyBatchMeansMethod()) {
            return samples;
        }
        ArrayList<Double> batchMeans = new ArrayList<Double>(this.getBatchesNumber());
        for (int i = 0; i < this.getBatchesNumber(); ++i) {
            batchMeans.add(this.getBatchAverage(samples, i));
        }
        System.out.printf("\tBatch Means Method applied. The number of samples was reduced to %d after computing the mean for each batch.%n", this.getBatchesNumber());
        return batchMeans;
    }

    private double getBatchAverage(List<Double> samples, int i) {
        int k = this.batchSizeCeil();
        return IntStream.range(0, k).mapToDouble(j -> (Double)samples.get(this.getBatchElementIndex(i, j))).average().orElse(0.0);
    }

    private int getBatchElementIndex(int i, int j) {
        int k = this.batchSizeCeil();
        return i * k + j;
    }

    public boolean isApplyAntitheticVariatesTechnique() {
        return this.applyAntitheticVariatesTechnique;
    }

    public int getSimulationRuns() {
        return this.simulationRuns;
    }

    public boolean isSingleRun() {
        return this.simulationRuns == 1;
    }

    private ExperimentRunner setSimulationRunsAsMultipleOfBatchNumber() {
        this.simulationRuns = this.getBatchesNumber() * (int)Math.ceil(this.getSimulationRuns() / this.getBatchesNumber());
        return this;
    }

    public int getBatchesNumber() {
        return this.batchesNumber;
    }

    public long getBaseSeed() {
        return this.baseSeed;
    }

    long getSeed(int experimentIndex) {
        return this.seeds.get(experimentIndex);
    }

    public <T extends StatisticalDistribution> T createRandomGen(int experimentIndex, Function<Long, T> randomGenCreator) {
        Objects.requireNonNull(randomGenCreator, "The Function to instantiate the Random Number Generator cannot be null.");
        if (this.seeds.isEmpty()) {
            throw new IllegalStateException("You have to create at least 1 SimulationExperiment before requesting a ExperimentRunner to create a pseudo random number generator (PRNG)!");
        }
        if (this.isToReuseSeedFromFirstHalfOfExperiments(experimentIndex)) {
            int expIndexFromFirstHalf = experimentIndex - this.halfSimulationRuns();
            StatisticalDistribution prng = (StatisticalDistribution)randomGenCreator.apply(this.getSeed(expIndexFromFirstHalf));
            prng.setApplyAntitheticVariates(true);
            return (T)prng;
        }
        return (T)((StatisticalDistribution)randomGenCreator.apply(this.getSeed(experimentIndex)));
    }

    public ContinuousDistribution createRandomGen(int experimentIndex) {
        return this.createRandomGen(experimentIndex, 0.0, 1.0);
    }

    public ContinuousDistribution createRandomGen(int experimentIndex, double minInclusive, double maxExclusive) {
        return this.createRandomGen(experimentIndex, seed -> new UniformDistr(minInclusive, maxExclusive, (long)seed));
    }

    public boolean isToReuseSeedFromFirstHalfOfExperiments(int currentExperimentIndex) {
        return this.isApplyAntitheticVariatesTechnique() && this.simulationRuns > 1 && currentExperimentIndex >= this.halfSimulationRuns();
    }

    void addSeed(long seed) {
        if (!this.seeds.contains(seed)) {
            this.seeds.add(seed);
        }
    }

    public int halfSimulationRuns() {
        return this.simulationRuns / 2;
    }

    public long getExperimentsExecutionTimeSecs() {
        return this.experimentsExecutionTimeSecs;
    }

    public long getExperimentsStartTimeSecs() {
        return this.experimentsStartTimeSecs;
    }

    @Override
    public void run() {
        this.createAllExperimentsBeforeFirstRun();
        String runWord = this.simulationRuns > 1 ? "runs" : "run";
        System.out.printf("Started %s for %d %s using %s (real local time: %s)%n", this.getClass().getSimpleName(), this.simulationRuns, runWord, "CloudSim Plus 6.4.0", LocalTime.now());
        if (this.description != null && !this.description.trim().isEmpty()) {
            System.out.println(this.description);
        }
        this.printSimulationParameters();
        this.experimentsStartTimeSecs = Math.round((double)System.currentTimeMillis() / 1000.0);
        this.printProgress(0);
        this.getStream(this.experiments).forEach(Experiment::run);
        System.out.println();
        this.experimentsExecutionTimeSecs = TimeUtil.elapsedSeconds(this.experimentsStartTimeSecs);
        System.out.printf("%nFinal simulation results for %d metrics in %d simulation runs -------------------%n", this.metricsMap.size(), this.simulationRuns);
        if (this.batchesNumber > 1 && !this.isApplyBatchMeansMethod()) {
            System.out.println("Batch means method was not be applied because the number of simulation runs is not greater than the number of batches.");
        }
        this.computeAndPrintFinalResults();
        System.out.printf("%nExperiments for %d runs finished in %s (real local time: %s)!%n", this.simulationRuns, TimeUtil.secondsToStr(this.experimentsExecutionTimeSecs), LocalTime.now());
    }

    private void createAllExperimentsBeforeFirstRun() {
        if (this.experiments == null) {
            this.experiments = IntStream.range(0, this.simulationRuns).mapToObj(this::createExperiment).collect(Collectors.toList());
        }
    }

    private void computeAndPrintFinalResults() {
        TreeMap<String, SummaryStatistics> statsMap = new TreeMap<String, SummaryStatistics>();
        this.metricsMap.entrySet().forEach(e -> statsMap.put((String)e.getKey(), this.computeAndPrintFinalResults((Map.Entry<String, List<Double>>)e)));
        this.buildLatexMetricsResultTable(statsMap);
    }

    private void buildLatexMetricsResultTable(Map<String, SummaryStatistics> statsMap) {
        if (!this.latexTableResultsGeneration) {
            return;
        }
        if (this.simulationRuns == 1) {
            System.out.println("Latex table with metrics' results is just built when the number of simulation runs is greater than 1.");
            return;
        }
        StringBuilder latex = this.startLatexTable();
        statsMap.forEach((metric, stats) -> this.latexRow(latex, (String)metric, (SummaryStatistics)stats));
        latex.append("  \\end{tabular}\n").append("\\end{table}\n");
        System.out.println();
        System.out.println(latex);
    }

    private void latexRow(StringBuilder latex, String metricName, SummaryStatistics stats) {
        String errorMargin = this.confidenceErrorMargin(stats).map(margin -> String.format("$\\pm$ & %.6f", margin)).orElse(" & ");
        String escapedMetricName = StringUtils.replace((String)metricName, (String)"%", (String)"\\%");
        latex.append(escapedMetricName).append(" & ").append(String.format("%.6f", stats.getMean())).append(errorMargin).append(" & ").append(String.format("%.6f", stats.getStandardDeviation())).append("\\\\ \\hline\n");
    }

    private StringBuilder startLatexTable() {
        StringBuilder latex = new StringBuilder();
        latex.append("\\begin{table}[!hbt]\n").append(String.format("  \\caption{%s}\n", this.description)).append(String.format("  \\label{%s}\n", this.resultsTableId)).append("  \\begin{tabular}{|p{2.5cm}|p{1.5cm}p{1.2cm}|>{\\raggedleft\\arraybackslash}p{1.3cm}|}\n").append("      \\hline\n").append("      \\textbf{Metric} & \\multicolumn{2}{p{3.0cm}|}{\\textbf{95\\% Confidence Interval}} & \\textbf{*Std. Dev.} \\\\ \\hline\n");
        return latex;
    }

    private Stream<Experiment> getStream(List<Experiment> experiments) {
        return this.parallel ? (Stream)experiments.stream().parallel() : experiments.stream();
    }

    private Experiment createExperiment(int i) {
        this.print((i + 1) % 100 == 0 ? String.format(". Run #%d%n", i + 1) : ".");
        this.setFirstExperimentCreated(i);
        return this.createExperimentInternal(i);
    }

    protected abstract T createExperimentInternal(int var1);

    protected SummaryStatistics computeAndPrintFinalResults(Map.Entry<String, List<Double>> metricEntry) {
        List<Double> metricValues = metricEntry.getValue();
        SummaryStatistics stats = this.computeFinalStatistics(metricValues);
        String valuesStr = metricValues.stream().map(v -> String.format("%.2f", v)).collect(Collectors.joining(", "));
        String sampleWord = metricValues.size() > 1 ? "samples" : "sample";
        System.out.printf("# %s: %.6f (%d %s: %s)%n", metricEntry.getKey(), stats.getMean(), metricValues.size(), sampleWord, valuesStr);
        if (this.simulationRuns > 1) {
            this.showConfidenceInterval(stats);
        }
        return stats;
    }

    protected final SummaryStatistics computeFinalStatistics(List<Double> values) {
        SummaryStatistics stats = new SummaryStatistics();
        List<Double> adjustedValues = this.computeAntitheticMeans(this.computeBatchMeans(values));
        adjustedValues.forEach(arg_0 -> ((SummaryStatistics)stats).addValue(arg_0));
        return stats;
    }

    private void showConfidenceInterval(SummaryStatistics stats) {
        Optional<Double> optional = this.confidenceErrorMargin(stats);
        if (optional.isPresent()) {
            double intervalSize = optional.get();
            double criticalValue = this.getConfidenceIntervalCriticalValue(stats.getN());
            System.out.printf("\tt-Distribution critical value for %d samples: %f%n", stats.getN(), criticalValue);
            double lower = stats.getMean() - intervalSize;
            double upper = stats.getMean() + intervalSize;
            System.out.printf("\t95%% Confidence Interval: %.6f \u2213 %.4f, that is [%.4f to %.4f]%n", stats.getMean(), intervalSize, lower, upper);
        } else {
            System.out.printf("\tValue for %d sample: %.6f%n", stats.getN(), stats.getMean());
        }
        System.out.printf("\tStandard Deviation: %.4f%n", stats.getStandardDeviation());
    }

    protected Optional<Double> confidenceErrorMargin(SummaryStatistics stats) {
        long samples = stats.getN();
        if (samples < 1L) {
            return Optional.empty();
        }
        try {
            double criticalValue = this.getConfidenceIntervalCriticalValue(samples);
            return Optional.of(criticalValue * stats.getStandardDeviation() / Math.sqrt(samples));
        }
        catch (MathIllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private double getConfidenceIntervalCriticalValue(long samples) {
        double freedomDegrees = samples - 1L;
        TDistribution tDist = new TDistribution(freedomDegrees);
        double significance = 0.050000000000000044;
        double criticalValue = tDist.inverseCumulativeProbability(0.975);
        return criticalValue;
    }

    protected final void addMetricValue(String metricName, Double value) {
        List<Double> metricValues = this.getMetricValues(metricName);
        if (value != null) {
            metricValues.add(value);
        }
    }

    protected final List<Double> getMetricValues(String metricName) {
        return this.metricsMap.compute(metricName, (key, values) -> values == null ? new ArrayList(this.simulationRuns) : values);
    }

    protected List<Double> computeAntitheticMeans(List<Double> samples) {
        if (!this.isApplyAntitheticVariatesTechnique()) {
            return samples;
        }
        int half = samples.size() / 2;
        ArrayList<Double> antitheticMeans = new ArrayList<Double>(half);
        for (int i = 0; i < half; ++i) {
            antitheticMeans.add((samples.get(i) + samples.get(half + i)) / 2.0);
        }
        System.out.printf("\tAntithetic Variates Technique applied. The number of samples was reduced to the half (%d).%n", half);
        return antitheticMeans;
    }

    protected abstract void printSimulationParameters();

    public void setFirstExperimentCreated(int firstExperimentCreated) {
        if (this.firstExperimentCreated < 0) {
            this.firstExperimentCreated = firstExperimentCreated;
        }
    }

    public int getFirstExperimentCreated() {
        return this.firstExperimentCreated;
    }

    public ExperimentRunner setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExperimentRunner setResultsTableId(String resultsTableId) {
        this.resultsTableId = resultsTableId;
        return this;
    }

    public ExperimentRunner enableLatexTableResultsGeneration() {
        this.latexTableResultsGeneration = true;
        return this;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public ExperimentRunner<T> setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public int getFinishedRuns() {
        return this.finishedRuns.get();
    }

    final int incFinishedRuns() {
        return this.finishedRuns.incrementAndGet();
    }

    final void printProgress(int current) {
        if (this.simulationRuns > 1 && this.showProgress) {
            Util.printProgress(current, this.simulationRuns, this.progressBarInNewLine);
        }
    }

    public ExperimentRunner<T> setProgressBarInNewLine(boolean progressBarInNewLine) {
        this.progressBarInNewLine = progressBarInNewLine;
        return this;
    }

    @Override
    public boolean isVerbose() {
        return super.isVerbose();
    }

    public boolean isParallel() {
        return this.parallel;
    }
}

