/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelDynamic;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.traces.google.GoogleTraceReaderAbstract;
import org.cloudsimplus.traces.google.TaskEvent;
import org.cloudsimplus.traces.google.TaskEventType;
import org.cloudsimplus.traces.google.TraceField;

public final class GoogleTaskEventsTraceReader
extends GoogleTraceReaderAbstract<Cloudlet> {
    private int maxCloudletsToCreate;
    private boolean autoSubmitCloudlets;
    private final List<CloudSimEvent> cloudletStatusChangeEvents;
    private Function<TaskEvent, Cloudlet> cloudletCreationFunction;
    private DatacenterBroker defaultBroker;
    private final Map<String, DatacenterBroker> brokersMap;
    private final CloudSim simulation;

    public static GoogleTaskEventsTraceReader getInstance(CloudSim simulation, String filePath, Function<TaskEvent, Cloudlet> cloudletCreationFunction) {
        InputStream reader = ResourceLoader.newInputStream(filePath, GoogleTaskEventsTraceReader.class);
        return new GoogleTaskEventsTraceReader(simulation, filePath, reader, cloudletCreationFunction);
    }

    public GoogleTaskEventsTraceReader(CloudSim simulation, String filePath, Function<TaskEvent, Cloudlet> cloudletCreationFunction) throws IOException {
        this(simulation, filePath, Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), cloudletCreationFunction);
    }

    private GoogleTaskEventsTraceReader(CloudSim simulation, String filePath, InputStream reader, Function<TaskEvent, Cloudlet> cloudletCreationFunction) {
        super(filePath, reader);
        this.simulation = Objects.requireNonNull(simulation);
        this.cloudletCreationFunction = Objects.requireNonNull(cloudletCreationFunction);
        this.autoSubmitCloudlets = true;
        this.brokersMap = new HashMap<String, DatacenterBroker>();
        this.cloudletStatusChangeEvents = new ArrayList<CloudSimEvent>();
        this.setMaxCloudletsToCreate(Integer.MAX_VALUE);
    }

    @Override
    public Collection<Cloudlet> process() {
        if (!this.autoSubmitCloudlets) {
            LOGGER.info("{}: Auto-submission of Cloudlets from trace file is disabled. Don't forget to submitted them to the broker.", (Object)this.getClass().getSimpleName());
        }
        return super.process();
    }

    @Override
    protected void preProcess() {
    }

    @Override
    protected void postProcess() {
        this.simulation.addOnSimulationStartListener(this::onSimulationStart);
    }

    private void onSimulationStart(EventInfo info) {
        this.cloudletStatusChangeEvents.forEach(evt -> evt.getSource().schedule((SimEvent)evt));
    }

    @Override
    protected boolean processParsedLineInternal() {
        return this.getEventType().process(this);
    }

    private TaskEventType getEventType() {
        return TaskEventType.getValue((Integer)FieldIndex.EVENT_TYPE.getValue(this));
    }

    protected TaskEvent createTaskEventFromTraceLine() {
        TaskEvent event = new TaskEvent();
        event.setType((Integer)FieldIndex.EVENT_TYPE.getValue(this)).setTimestamp((Double)FieldIndex.TIMESTAMP.getValue(this)).setResourceRequestForCpuCores((Double)FieldIndex.RESOURCE_REQUEST_FOR_CPU_CORES.getValue(this)).setResourceRequestForLocalDiskSpace((Double)FieldIndex.RESOURCE_REQUEST_FOR_LOCAL_DISK_SPACE.getValue(this)).setResourceRequestForRam((Double)FieldIndex.RESOURCE_REQUEST_FOR_RAM.getValue(this)).setPriority((Integer)FieldIndex.PRIORITY.getValue(this)).setSchedulingClass((Integer)FieldIndex.SCHEDULING_CLASS.getValue(this)).setUserName((String)FieldIndex.USERNAME.getValue(this)).setJobId((Long)FieldIndex.JOB_ID.getValue(this)).setTaskIndex((Long)FieldIndex.TASK_INDEX.getValue(this));
        return event;
    }

    boolean requestCloudletStatusChange(int tag) {
        TaskEvent taskEvent = this.createTaskEventFromTraceLine();
        DatacenterBroker broker = this.getBroker(taskEvent.getUserName());
        double delay = taskEvent.getTimestamp();
        return this.findObject(taskEvent.getUniqueTaskId()).map(cloudlet -> this.addCloudletStatusChangeEvents(new CloudSimEvent(delay, broker, tag, cloudlet), taskEvent)).isPresent();
    }

    private Cloudlet addCloudletStatusChangeEvents(CloudSimEvent statusChangeSimEvt, TaskEvent taskEvent) {
        this.cloudletStatusChangeEvents.add(statusChangeSimEvt);
        Cloudlet cloudlet = (Cloudlet)statusChangeSimEvt.getData();
        Cloudlet clone = this.createCloudlet(taskEvent);
        clone.setId(cloudlet.getId());
        if (!this.areCloudletAttributesDifferent(cloudlet, clone)) {
            return cloudlet;
        }
        Runnable attributesUpdateRunnable = () -> {
            DatacenterBroker broker = cloudlet.getBroker();
            StringBuilder builder = new StringBuilder();
            if (clone.getPriority() != cloudlet.getPriority()) {
                builder.append("priority: ").append(cloudlet.getPriority()).append(" -> ").append(clone.getPriority()).append(" | ");
                cloudlet.setFileSize(clone.getFileSize());
            }
            if (clone.getNumberOfPes() != cloudlet.getNumberOfPes()) {
                builder.append("PEs: ").append(cloudlet.getNumberOfPes()).append(" -> ").append(clone.getNumberOfPes()).append(" | ");
                cloudlet.setNumberOfPes(clone.getNumberOfPes());
            }
            UtilizationModelDynamic cloneRamUM = (UtilizationModelDynamic)clone.getUtilizationModelRam();
            UtilizationModelDynamic cloudletRamUM = (UtilizationModelDynamic)cloudlet.getUtilizationModelRam();
            if (cloneRamUM.getMaxResourceUtilization() != cloudletRamUM.getMaxResourceUtilization()) {
                builder.append("Max RAM Usage: ").append(this.formatPercentValue(cloudletRamUM.getMaxResourceUtilization())).append(" -> ").append(this.formatPercentValue(cloneRamUM.getMaxResourceUtilization())).append("% | ");
                cloudletRamUM.setMaxResourceUtilization(cloneRamUM.getMaxResourceUtilization());
            }
            DatacenterBroker.LOGGER.trace("{}: {}: {} attributes updated: {}", new Object[]{this.getSimulation().clockStr(), broker.getName(), cloudlet, builder});
        };
        CloudSimEvent attrsChangeSimEvt = new CloudSimEvent(taskEvent.getTimestamp(), statusChangeSimEvt.getDestination(), 27, attributesUpdateRunnable);
        this.cloudletStatusChangeEvents.add(attrsChangeSimEvt);
        return cloudlet;
    }

    protected Cloudlet createCloudlet(TaskEvent taskEvent) {
        Cloudlet cloudlet = this.cloudletCreationFunction.apply(taskEvent);
        if (cloudlet.getUtilizationModelRam() instanceof UtilizationModelDynamic) {
            return cloudlet;
        }
        throw new IllegalStateException("Since the 'task events' trace file provides a field defining the max RAM the Cloudlet can request (RESOURCE_REQUEST_FOR_RAM), it's required to use a UtilizationModelDynamic for the Cloudlet's RAM utilization model, so that the UtilizationModelDynamic.maxResourceUtilization attribute can be changed when defined in the trace file.");
    }

    private boolean areCloudletAttributesDifferent(Cloudlet cloudlet1, Cloudlet cloudlet2) {
        return cloudlet2.getFileSize() != cloudlet1.getFileSize() || cloudlet2.getNumberOfPes() != cloudlet1.getNumberOfPes() || cloudlet2.getUtilizationOfCpu() != cloudlet1.getUtilizationOfCpu() || cloudlet2.getUtilizationOfRam() != cloudlet1.getUtilizationOfRam();
    }

    protected Function<TaskEvent, Cloudlet> getCloudletCreationFunction() {
        return this.cloudletCreationFunction;
    }

    public void setCloudletCreationFunction(Function<TaskEvent, Cloudlet> cloudletCreationFunction) {
        this.cloudletCreationFunction = Objects.requireNonNull(cloudletCreationFunction);
    }

    public List<DatacenterBroker> getBrokers() {
        return this.defaultBroker == null ? new ArrayList<DatacenterBroker>(this.brokersMap.values()) : Collections.singletonList(this.defaultBroker);
    }

    public GoogleTaskEventsTraceReader setDefaultBroker(DatacenterBroker broker) {
        this.defaultBroker = Objects.requireNonNull(broker);
        this.brokersMap.clear();
        return this;
    }

    protected DatacenterBroker getOrCreateBroker(String username) {
        return this.getBroker(() -> this.brokersMap.computeIfAbsent(username, this::createBroker));
    }

    private DatacenterBroker createBroker(String username) {
        return new DatacenterBrokerSimple(this.simulation, "Broker_" + username);
    }

    private DatacenterBroker getBroker(String username) {
        return this.getBroker(() -> this.brokersMap.get(username));
    }

    private DatacenterBroker getBroker(Supplier<DatacenterBroker> supplier) {
        return this.defaultBroker == null ? supplier.get() : this.defaultBroker;
    }

    protected DatacenterBroker getBroker() {
        String value = (String)FieldIndex.USERNAME.getValue(this);
        return this.getBroker(value);
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public int getMaxCloudletsToCreate() {
        return this.maxCloudletsToCreate;
    }

    public GoogleTaskEventsTraceReader setMaxCloudletsToCreate(int maxCloudletsToCreate) {
        if (maxCloudletsToCreate <= 0) {
            throw new IllegalArgumentException("Maximum number of Cloudlets to create must be greater than 0. If you want to create all Cloudlets from the entire file, provide Integer.MAX_VALUE.");
        }
        this.maxCloudletsToCreate = maxCloudletsToCreate;
        return this;
    }

    protected boolean allowCloudletCreation() {
        return this.availableObjectsCount() < this.getMaxCloudletsToCreate();
    }

    public boolean isAutoSubmitCloudlets() {
        return this.autoSubmitCloudlets;
    }

    public GoogleTaskEventsTraceReader setAutoSubmitCloudlets(boolean autoSubmitCloudlets) {
        this.autoSubmitCloudlets = autoSubmitCloudlets;
        return this;
    }

    public static enum FieldIndex implements TraceField<GoogleTaskEventsTraceReader>
    {
        TIMESTAMP{

            @Override
            public Double getValue(GoogleTaskEventsTraceReader reader) {
                return TimeUtil.microToSeconds(reader.getFieldDoubleValue(this));
            }
        }
        ,
        MISSING_INFO{

            @Override
            public Integer getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldIntValue(this, -1);
            }
        }
        ,
        JOB_ID{

            @Override
            public Long getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldLongValue(this);
            }
        }
        ,
        TASK_INDEX{

            @Override
            public Long getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldLongValue(this);
            }
        }
        ,
        MACHINE_ID{

            @Override
            public Long getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldLongValue(this, -1L);
            }
        }
        ,
        EVENT_TYPE{

            @Override
            public Integer getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldIntValue(this);
            }
        }
        ,
        USERNAME{

            @Override
            public String getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldValue(this);
            }
        }
        ,
        SCHEDULING_CLASS{

            @Override
            public Integer getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldIntValue(this);
            }
        }
        ,
        PRIORITY{

            @Override
            public Integer getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldIntValue(this);
            }
        }
        ,
        RESOURCE_REQUEST_FOR_CPU_CORES{

            @Override
            public Double getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        RESOURCE_REQUEST_FOR_RAM{

            @Override
            public Double getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        RESOURCE_REQUEST_FOR_LOCAL_DISK_SPACE{

            @Override
            public Double getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldDoubleValue(this, 0.0);
            }
        }
        ,
        DIFFERENT_MACHINE_CONSTRAINT{

            @Override
            public Integer getValue(GoogleTaskEventsTraceReader reader) {
                return reader.getFieldIntValue(this, -1);
            }
        };

    }

    public static enum MissingInfo {
        SNAPSHOT_BUT_NO_TRANSITION,
        NO_SNAPSHOT_OR_TRANSITION,
        EXISTS_BUT_NO_CREATION;

    }
}

