/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cloudbus.cloudsim.core.Identifiable;
import org.cloudsimplus.traces.TraceReaderBase;

abstract class GoogleTraceReaderAbstract<T extends Identifiable>
extends TraceReaderBase {
    static final String VAL_SEPARATOR = " -> ";
    static final String COL_SEPARATOR = " | ";
    private final Map<Long, T> availableObjectsMap;

    GoogleTraceReaderAbstract(String filePath, InputStream reader) {
        super(filePath, reader);
        this.setFieldDelimiterRegex(",");
        this.availableObjectsMap = new HashMap<Long, T>();
    }

    public Collection<T> process() {
        this.preProcess();
        if (this.availableObjectsMap.isEmpty()) {
            try {
                this.readFile(this::processParsedLine);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when processing the trace file. Current trace line: " + this.getLastLineNumber(), e);
            }
            this.postProcess();
        }
        return this.availableObjectsMap.values();
    }

    protected abstract void preProcess();

    protected abstract void postProcess();

    final boolean processParsedLine(String[] parsedLineArray) {
        this.setLastParsedLineArray(parsedLineArray);
        return this.processParsedLineInternal();
    }

    protected abstract boolean processParsedLineInternal();

    String formatPercentValue(double percent) {
        return String.format("%.1f", percent * 100.0);
    }

    final boolean addAvailableObject(T object) {
        return this.availableObjectsMap.put(object.getId(), Objects.requireNonNull(object)) == null;
    }

    protected final int availableObjectsCount() {
        return this.availableObjectsMap.size();
    }

    protected Collection<T> getAvailableObjects() {
        return this.availableObjectsMap.values();
    }

    protected final Optional<T> findObject(long id) {
        return Optional.ofNullable(this.availableObjectsMap.get(id));
    }
}

